/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.binstore;

import ca.uhn.fhir.jpa.binstore.BaseBinaryStorageSvcImpl;
import ca.uhn.fhir.jpa.binstore.IBinaryStorageSvc;
import ca.uhn.fhir.jpa.binstore.StoredDetails;
import com.google.common.hash.HashingInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CountingInputStream;
import org.hl7.fhir.instance.model.api.IIdType;

public class MemoryBinaryStorageSvcImpl
extends BaseBinaryStorageSvcImpl
implements IBinaryStorageSvc {
    private ConcurrentHashMap<String, byte[]> myDataMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, StoredDetails> myDetailsMap = new ConcurrentHashMap();

    @Override
    public StoredDetails storeBlob(IIdType theResourceId, String theBlobIdOrNull, String theContentType, InputStream theInputStream) throws IOException {
        String id = super.provideIdForNewBlob(theBlobIdOrNull);
        String key = this.toKey(theResourceId, id);
        HashingInputStream hashingIs = this.createHashingInputStream(theInputStream);
        CountingInputStream countingIs = this.createCountingInputStream((InputStream)hashingIs);
        byte[] bytes = IOUtils.toByteArray((InputStream)countingIs);
        theInputStream.close();
        this.myDataMap.put(key, bytes);
        StoredDetails storedDetails = new StoredDetails(id, countingIs.getCount(), theContentType, hashingIs, new Date());
        this.myDetailsMap.put(key, storedDetails);
        return storedDetails;
    }

    @Override
    public StoredDetails fetchBlobDetails(IIdType theResourceId, String theBlobId) {
        String key = this.toKey(theResourceId, theBlobId);
        return this.myDetailsMap.get(key);
    }

    @Override
    public boolean writeBlob(IIdType theResourceId, String theBlobId, OutputStream theOutputStream) throws IOException {
        String key = this.toKey(theResourceId, theBlobId);
        byte[] bytes = this.myDataMap.get(key);
        if (bytes == null) {
            return false;
        }
        theOutputStream.write(bytes);
        return true;
    }

    @Override
    public void expungeBlob(IIdType theResourceId, String theBlobId) {
        String key = this.toKey(theResourceId, theBlobId);
        this.myDataMap.remove(key);
        this.myDetailsMap.remove(key);
    }

    @Override
    public byte[] fetchBlob(IIdType theResourceId, String theBlobId) {
        String key = this.toKey(theResourceId, theBlobId);
        return this.myDataMap.get(key);
    }

    private String toKey(IIdType theResourceId, String theBlobId) {
        return theBlobId + '-' + theResourceId.toUnqualifiedVersionless().getValue();
    }

    public void clear() {
        this.myDetailsMap.clear();
        this.myDataMap.clear();
    }
}

