/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.bulk.export.job;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IDao;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.batch.log.Logs;
import ca.uhn.fhir.jpa.dao.ISearchBuilder;
import ca.uhn.fhir.jpa.dao.SearchBuilderFactory;
import ca.uhn.fhir.jpa.dao.data.IBulkExportJobDao;
import ca.uhn.fhir.jpa.entity.BulkExportJobEntity;
import ca.uhn.fhir.jpa.searchparam.MatchUrlService;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.util.SearchParameterUtil;
import ca.uhn.fhir.util.UrlUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.springframework.batch.item.ItemReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public abstract class BaseBulkItemReader
implements ItemReader<List<ResourcePersistentId>> {
    private static final Logger ourLog = Logs.getBatchTroubleshootingLog();
    @Value(value="#{stepExecutionContext['resourceType']}")
    protected String myResourceType;
    @Value(value="#{jobExecutionContext['jobUUID']}")
    protected String myJobUUID;
    @Value(value="#{jobParameters['readChunkSize']}")
    protected Long myReadChunkSize;
    @Autowired
    protected DaoRegistry myDaoRegistry;
    @Autowired
    protected FhirContext myContext;
    @Autowired
    protected SearchBuilderFactory mySearchBuilderFactory;
    @Autowired
    private IBulkExportJobDao myBulkExportJobDao;
    @Autowired
    private MatchUrlService myMatchUrlService;
    private ISearchBuilder mySearchBuilder;
    private BulkExportJobEntity myJobEntity;
    private RuntimeResourceDefinition myResourceDefinition;
    private Iterator<ResourcePersistentId> myPidIterator;
    private RuntimeSearchParam myPatientSearchParam;

    protected ISearchBuilder getSearchBuilderForLocalResourceType() {
        if (this.mySearchBuilder == null) {
            IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(this.myResourceType);
            RuntimeResourceDefinition def = this.myContext.getResourceDefinition(this.myResourceType);
            Class nextTypeClass = def.getImplementingClass();
            this.mySearchBuilder = this.mySearchBuilderFactory.newSearchBuilder((IDao)dao, this.myResourceType, nextTypeClass);
        }
        return this.mySearchBuilder;
    }

    protected void loadResourcePids() {
        this.myPidIterator = this.getResourcePidIterator();
    }

    protected abstract Iterator<ResourcePersistentId> getResourcePidIterator();

    protected List<SearchParameterMap> createSearchParameterMapsForResourceType() {
        BulkExportJobEntity jobEntity = this.getJobEntity();
        RuntimeResourceDefinition theDef = this.getResourceDefinition();
        Map requestUrl = UrlUtil.parseQueryStrings((String[])new String[]{jobEntity.getRequest()});
        String[] typeFilters = (String[])requestUrl.get("_typeFilter");
        List<Object> spMaps = null;
        if (typeFilters != null) {
            spMaps = Arrays.stream(typeFilters).filter(typeFilter -> typeFilter.startsWith(this.myResourceType + "?")).map(filter -> this.buildSearchParameterMapForTypeFilter((String)filter, theDef)).collect(Collectors.toList());
        }
        if (spMaps == null || spMaps.isEmpty()) {
            SearchParameterMap defaultMap = new SearchParameterMap();
            this.enhanceSearchParameterMapWithCommonParameters(defaultMap);
            spMaps = Collections.singletonList(defaultMap);
        }
        return spMaps;
    }

    private void enhanceSearchParameterMapWithCommonParameters(SearchParameterMap map) {
        map.setLoadSynchronous(true);
        if (this.getJobEntity().getSince() != null) {
            map.setLastUpdated(new DateRangeParam(this.getJobEntity().getSince(), null));
        }
    }

    public SearchParameterMap buildSearchParameterMapForTypeFilter(String theFilter, RuntimeResourceDefinition theDef) {
        SearchParameterMap searchParameterMap = this.myMatchUrlService.translateMatchUrl(theFilter, theDef, new MatchUrlService.Flag[0]);
        this.enhanceSearchParameterMapWithCommonParameters(searchParameterMap);
        return searchParameterMap;
    }

    protected RuntimeResourceDefinition getResourceDefinition() {
        if (this.myResourceDefinition == null) {
            this.myResourceDefinition = this.myContext.getResourceDefinition(this.myResourceType);
        }
        return this.myResourceDefinition;
    }

    protected BulkExportJobEntity getJobEntity() {
        if (this.myJobEntity == null) {
            Optional<BulkExportJobEntity> jobOpt = this.myBulkExportJobDao.findByJobId(this.myJobUUID);
            if (jobOpt.isPresent()) {
                this.myJobEntity = jobOpt.get();
            } else {
                String errorMessage = String.format("Job with UUID %s does not exist!", this.myJobUUID);
                throw new IllegalStateException(errorMessage);
            }
        }
        return this.myJobEntity;
    }

    public List<ResourcePersistentId> read() {
        ourLog.info("Bulk export starting generation for batch export job: [{}] with resourceType [{}] and UUID [{}]", new Object[]{this.getJobEntity(), this.myResourceType, this.myJobUUID});
        if (this.myPidIterator == null) {
            this.loadResourcePids();
        }
        int count = 0;
        ArrayList<ResourcePersistentId> outgoing = new ArrayList<ResourcePersistentId>();
        while (this.myPidIterator.hasNext() && (long)count < this.myReadChunkSize) {
            outgoing.add(this.myPidIterator.next());
            ++count;
        }
        return outgoing.size() == 0 ? null : outgoing;
    }

    protected RuntimeSearchParam getPatientSearchParamForCurrentResourceType() {
        Optional onlyPatientSearchParamForResourceType;
        if (this.myPatientSearchParam == null && (onlyPatientSearchParamForResourceType = SearchParameterUtil.getOnlyPatientSearchParamForResourceType((FhirContext)this.myContext, (String)this.myResourceType)).isPresent()) {
            this.myPatientSearchParam = (RuntimeSearchParam)onlyPatientSearchParamForResourceType.get();
        }
        return this.myPatientSearchParam;
    }
}

