/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.bulk.export.job;

import ca.uhn.fhir.jpa.bulk.export.model.BulkExportJobStatusEnum;
import ca.uhn.fhir.jpa.bulk.export.svc.BulkExportDaoSvc;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.beans.factory.annotation.Autowired;

public class BulkExportCreateEntityStepListener
implements StepExecutionListener {
    @Autowired
    private BulkExportDaoSvc myBulkExportDaoSvc;

    public void beforeStep(StepExecution theStepExecution) {
        String jobUuid = theStepExecution.getJobExecution().getJobParameters().getString("jobUUID");
        if (jobUuid != null) {
            this.myBulkExportDaoSvc.setJobToStatus(jobUuid, BulkExportJobStatusEnum.BUILDING);
        }
    }

    public ExitStatus afterStep(StepExecution theStepExecution) {
        return ExitStatus.EXECUTING;
    }
}

