/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.bulk.export.job;

import ca.uhn.fhir.jpa.bulk.export.model.BulkExportJobStatusEnum;
import ca.uhn.fhir.jpa.bulk.export.svc.BulkExportDaoSvc;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.beans.factory.annotation.Autowired;

public class BulkExportGenerateResourceFilesStepListener
implements StepExecutionListener {
    @Autowired
    private BulkExportDaoSvc myBulkExportDaoSvc;

    public void beforeStep(@Nonnull StepExecution stepExecution) {
    }

    public ExitStatus afterStep(StepExecution theStepExecution) {
        if (theStepExecution.getExitStatus().getExitCode().equals(ExitStatus.FAILED.getExitCode())) {
            String jobUuid = theStepExecution.getJobExecution().getJobParameters().getString("jobUUID");
            if (jobUuid == null) {
                jobUuid = theStepExecution.getJobExecution().getExecutionContext().getString("jobUUID");
            }
            assert (StringUtils.isNotBlank((CharSequence)jobUuid));
            String exitDescription = theStepExecution.getExitStatus().getExitDescription();
            this.myBulkExportDaoSvc.setJobToStatus(jobUuid, BulkExportJobStatusEnum.ERROR, exitDescription);
        }
        return theStepExecution.getExitStatus();
    }
}

