/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.bulk.export.job;

import ca.uhn.fhir.jpa.bulk.export.model.BulkExportJobStatusEnum;
import ca.uhn.fhir.jpa.bulk.export.svc.BulkExportDaoSvc;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class BulkExportJobCloser
implements Tasklet {
    @Value(value="#{jobExecutionContext['jobUUID']}")
    private String myJobUUID;
    @Autowired
    private BulkExportDaoSvc myBulkExportDaoSvc;

    public RepeatStatus execute(StepContribution theStepContribution, ChunkContext theChunkContext) {
        if (theChunkContext.getStepContext().getStepExecution().getJobExecution().getStatus() == BatchStatus.STARTED) {
            this.myBulkExportDaoSvc.setJobToStatus(this.myJobUUID, BulkExportJobStatusEnum.COMPLETE);
        } else {
            this.myBulkExportDaoSvc.setJobToStatus(this.myJobUUID, BulkExportJobStatusEnum.ERROR);
        }
        return RepeatStatus.FINISHED;
    }
}

