/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.bulk.export.job;

import ca.uhn.fhir.jpa.batch.processor.GoldenResourceAnnotatingProcessor;
import ca.uhn.fhir.jpa.batch.processor.PidToIBaseResourceProcessor;
import ca.uhn.fhir.jpa.bulk.export.job.BulkExportCreateEntityStepListener;
import ca.uhn.fhir.jpa.bulk.export.job.BulkExportGenerateResourceFilesStepListener;
import ca.uhn.fhir.jpa.bulk.export.job.BulkExportJobCloser;
import ca.uhn.fhir.jpa.bulk.export.job.BulkExportJobParameterValidator;
import ca.uhn.fhir.jpa.bulk.export.job.BulkItemReader;
import ca.uhn.fhir.jpa.bulk.export.job.CreateBulkExportEntityTasklet;
import ca.uhn.fhir.jpa.bulk.export.job.GroupBulkItemReader;
import ca.uhn.fhir.jpa.bulk.export.job.GroupIdPresentValidator;
import ca.uhn.fhir.jpa.bulk.export.job.PatientBulkItemReader;
import ca.uhn.fhir.jpa.bulk.export.job.ResourceToFileWriter;
import ca.uhn.fhir.jpa.bulk.export.job.ResourceTypePartitioner;
import ca.uhn.fhir.jpa.bulk.export.svc.BulkExportDaoSvc;
import ca.uhn.fhir.jpa.dao.mdm.MdmExpansionCacheSvc;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobParametersValidator;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.JobScope;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.partition.support.Partitioner;
import org.springframework.batch.core.step.builder.AbstractTaskletStepBuilder;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.support.CompositeItemProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
public class BulkExportJobConfig {
    public static final String JOB_UUID_PARAMETER = "jobUUID";
    public static final String READ_CHUNK_PARAMETER = "readChunkSize";
    public static final String EXPAND_MDM_PARAMETER = "expandMdm";
    public static final String GROUP_ID_PARAMETER = "groupId";
    public static final String RESOURCE_TYPES_PARAMETER = "resourceTypes";
    public static final int CHUNK_SIZE = 100;
    public static final String JOB_DESCRIPTION = "jobDescription";
    @Autowired
    private StepBuilderFactory myStepBuilderFactory;
    @Autowired
    private JobBuilderFactory myJobBuilderFactory;
    @Autowired
    private PidToIBaseResourceProcessor myPidToIBaseResourceProcessor;
    @Autowired
    private GoldenResourceAnnotatingProcessor myGoldenResourceAnnotatingProcessor;

    @Bean
    public BulkExportDaoSvc bulkExportDaoSvc() {
        return new BulkExportDaoSvc();
    }

    @Bean
    @Lazy
    @JobScope
    public MdmExpansionCacheSvc mdmExpansionCacheSvc() {
        return new MdmExpansionCacheSvc();
    }

    @Bean
    @Lazy
    public Job bulkExportJob() {
        return ((JobBuilder)this.myJobBuilderFactory.get("bulkExportJob").validator(this.bulkExportJobParameterValidator())).start(this.createBulkExportEntityStep()).next(this.bulkExportPartitionStep()).next(this.closeJobStep()).build();
    }

    @Bean
    @Lazy
    @StepScope
    public CompositeItemProcessor<List<ResourcePersistentId>, List<IBaseResource>> inflateResourceThenAnnotateWithGoldenResourceProcessor() {
        CompositeItemProcessor processor = new CompositeItemProcessor();
        ArrayList<Object> delegates = new ArrayList<Object>();
        delegates.add(this.myPidToIBaseResourceProcessor);
        delegates.add(this.myGoldenResourceAnnotatingProcessor);
        processor.setDelegates(delegates);
        return processor;
    }

    @Bean
    @Lazy
    public Job groupBulkExportJob() {
        return ((JobBuilder)((JobBuilder)this.myJobBuilderFactory.get("groupBulkExportJob").validator((JobParametersValidator)this.groupBulkJobParameterValidator())).validator(this.bulkExportJobParameterValidator())).start(this.createBulkExportEntityStep()).next(this.groupPartitionStep()).next(this.closeJobStep()).build();
    }

    @Bean
    @Lazy
    public Job patientBulkExportJob() {
        return ((JobBuilder)this.myJobBuilderFactory.get("patientBulkExportJob").validator(this.bulkExportJobParameterValidator())).start(this.createBulkExportEntityStep()).next(this.patientPartitionStep()).next(this.closeJobStep()).build();
    }

    @Bean
    public GroupIdPresentValidator groupBulkJobParameterValidator() {
        return new GroupIdPresentValidator();
    }

    @Bean
    public Step createBulkExportEntityStep() {
        return ((AbstractTaskletStepBuilder)this.myStepBuilderFactory.get("createBulkExportEntityStep").tasklet((Tasklet)this.createBulkExportEntityTasklet()).listener((StepExecutionListener)this.bulkExportCreateEntityStepListener())).build();
    }

    @Bean
    public CreateBulkExportEntityTasklet createBulkExportEntityTasklet() {
        return new CreateBulkExportEntityTasklet();
    }

    @Bean
    public JobParametersValidator bulkExportJobParameterValidator() {
        return new BulkExportJobParameterValidator();
    }

    @Bean
    public Step groupBulkExportGenerateResourceFilesStep() {
        return ((AbstractTaskletStepBuilder)this.myStepBuilderFactory.get("groupBulkExportGenerateResourceFilesStep").chunk(100).reader((ItemReader)this.groupBulkItemReader()).processor(this.inflateResourceThenAnnotateWithGoldenResourceProcessor()).writer((ItemWriter)this.resourceToFileWriter()).listener((StepExecutionListener)this.bulkExportGenerateResourceFilesStepListener())).build();
    }

    @Bean
    public Step bulkExportGenerateResourceFilesStep() {
        return ((AbstractTaskletStepBuilder)this.myStepBuilderFactory.get("bulkExportGenerateResourceFilesStep").chunk(100).reader((ItemReader)this.bulkItemReader()).processor((ItemProcessor)this.myPidToIBaseResourceProcessor).writer((ItemWriter)this.resourceToFileWriter()).listener((StepExecutionListener)this.bulkExportGenerateResourceFilesStepListener())).build();
    }

    @Bean
    public Step patientBulkExportGenerateResourceFilesStep() {
        return ((AbstractTaskletStepBuilder)this.myStepBuilderFactory.get("patientBulkExportGenerateResourceFilesStep").chunk(100).reader((ItemReader)this.patientBulkItemReader()).processor((ItemProcessor)this.myPidToIBaseResourceProcessor).writer((ItemWriter)this.resourceToFileWriter()).listener((StepExecutionListener)this.bulkExportGenerateResourceFilesStepListener())).build();
    }

    @Bean
    @JobScope
    public BulkExportJobCloser bulkExportJobCloser() {
        return new BulkExportJobCloser();
    }

    @Bean
    public Step closeJobStep() {
        return this.myStepBuilderFactory.get("closeJobStep").tasklet((Tasklet)this.bulkExportJobCloser()).build();
    }

    @Bean
    @JobScope
    public BulkExportCreateEntityStepListener bulkExportCreateEntityStepListener() {
        return new BulkExportCreateEntityStepListener();
    }

    @Bean
    @JobScope
    public BulkExportGenerateResourceFilesStepListener bulkExportGenerateResourceFilesStepListener() {
        return new BulkExportGenerateResourceFilesStepListener();
    }

    @Bean
    public Step bulkExportPartitionStep() {
        return this.myStepBuilderFactory.get("partitionStep").partitioner("bulkExportGenerateResourceFilesStep", (Partitioner)this.bulkExportResourceTypePartitioner()).step(this.bulkExportGenerateResourceFilesStep()).build();
    }

    @Bean
    public Step groupPartitionStep() {
        return this.myStepBuilderFactory.get("partitionStep").partitioner("groupBulkExportGenerateResourceFilesStep", (Partitioner)this.bulkExportResourceTypePartitioner()).step(this.groupBulkExportGenerateResourceFilesStep()).build();
    }

    @Bean
    public Step patientPartitionStep() {
        return this.myStepBuilderFactory.get("partitionStep").partitioner("patientBulkExportGenerateResourceFilesStep", (Partitioner)this.bulkExportResourceTypePartitioner()).step(this.patientBulkExportGenerateResourceFilesStep()).build();
    }

    @Bean
    @StepScope
    public GroupBulkItemReader groupBulkItemReader() {
        return new GroupBulkItemReader();
    }

    @Bean
    @StepScope
    public PatientBulkItemReader patientBulkItemReader() {
        return new PatientBulkItemReader();
    }

    @Bean
    @StepScope
    public BulkItemReader bulkItemReader() {
        return new BulkItemReader();
    }

    @Bean
    @JobScope
    public ResourceTypePartitioner bulkExportResourceTypePartitioner() {
        return new ResourceTypePartitioner();
    }

    @Bean
    @StepScope
    public ResourceToFileWriter resourceToFileWriter() {
        return new ResourceToFileWriter();
    }
}

