/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.bulk.export.job;

import ca.uhn.fhir.jpa.dao.data.IBulkExportJobDao;
import ca.uhn.fhir.jpa.entity.BulkExportJobEntity;
import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.JobParametersValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class BulkExportJobParameterValidator
implements JobParametersValidator {
    @Autowired
    private IBulkExportJobDao myBulkExportJobDao;
    @Autowired
    private PlatformTransactionManager myTransactionManager;

    public void validate(JobParameters theJobParameters) throws JobParametersInvalidException {
        if (theJobParameters == null) {
            throw new JobParametersInvalidException("This job needs Parameters: [readChunkSize], [jobUUID], [filters], [outputFormat], [resourceTypes]");
        }
        TransactionTemplate txTemplate = new TransactionTemplate(this.myTransactionManager);
        String errorMessage = (String)txTemplate.execute(tx -> {
            boolean hasExistingJob;
            StringBuilder errorBuilder = new StringBuilder();
            Long readChunkSize = theJobParameters.getLong("readChunkSize");
            if (readChunkSize == null || readChunkSize < 1L) {
                errorBuilder.append("There must be a valid number for readChunkSize, which is at least 1. ");
            }
            String jobUUID = theJobParameters.getString("jobUUID");
            Optional<BulkExportJobEntity> oJob = this.myBulkExportJobDao.findByJobId(jobUUID);
            if (!StringUtils.isBlank((CharSequence)jobUUID) && !oJob.isPresent()) {
                errorBuilder.append("There is no persisted job that exists with UUID: " + jobUUID + ". ");
            }
            if (!(hasExistingJob = oJob.isPresent())) {
                String resourceTypes = theJobParameters.getString("resourceTypes");
                if (StringUtils.isBlank((CharSequence)resourceTypes)) {
                    errorBuilder.append("You must include [").append("resourceTypes").append("] as a Job Parameter");
                } else {
                    String[] resourceArray = resourceTypes.split(",");
                    Arrays.stream(resourceArray).filter(resourceType -> resourceType.equalsIgnoreCase("Binary")).findFirst().ifPresent(resourceType -> errorBuilder.append("Bulk export of Binary resources is forbidden"));
                }
                String outputFormat = theJobParameters.getString("outputFormat");
                if (!StringUtils.isBlank((CharSequence)outputFormat) && !"application/fhir+ndjson".equals(outputFormat)) {
                    errorBuilder.append("The only allowed format for Bulk Export is currently application/fhir+ndjson");
                }
            }
            return errorBuilder.toString();
        });
        if (!StringUtils.isEmpty((CharSequence)errorMessage)) {
            throw new JobParametersInvalidException(errorMessage);
        }
    }
}

