/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.bulk.export.job;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.batch.log.Logs;
import ca.uhn.fhir.jpa.bulk.export.job.BaseBulkItemReader;
import ca.uhn.fhir.jpa.dao.IResultIterator;
import ca.uhn.fhir.jpa.dao.ISearchBuilder;
import ca.uhn.fhir.jpa.model.search.SearchRuntimeDetails;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;

public class BulkItemReader
extends BaseBulkItemReader {
    private static final Logger ourLog = Logs.getBatchTroubleshootingLog();

    @Override
    protected Iterator<ResourcePersistentId> getResourcePidIterator() {
        ourLog.info("Bulk export assembling export of type {} for job {}", (Object)this.myResourceType, (Object)this.myJobUUID);
        HashSet<ResourcePersistentId> myReadPids = new HashSet<ResourcePersistentId>();
        List<SearchParameterMap> map = this.createSearchParameterMapsForResourceType();
        ISearchBuilder sb = this.getSearchBuilderForLocalResourceType();
        for (SearchParameterMap spMap : map) {
            ourLog.debug("About to evaluate query {}", (Object)spMap.toNormalizedQueryString(this.myContext));
            IResultIterator myResultIterator = sb.createQuery(spMap, new SearchRuntimeDetails(null, this.myJobUUID), null, RequestPartitionId.allPartitions());
            while (myResultIterator.hasNext()) {
                myReadPids.add((ResourcePersistentId)myResultIterator.next());
            }
        }
        return myReadPids.iterator();
    }
}

