/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.bulk.export.job;

import ca.uhn.fhir.jpa.bulk.export.api.IBulkDataExportSvc;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.server.bulk.BulkDataExportOptions;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IIdType;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Autowired;

public class CreateBulkExportEntityTasklet
implements Tasklet {
    @Autowired
    private IBulkDataExportSvc myBulkDataExportSvc;

    public RepeatStatus execute(StepContribution theStepContribution, ChunkContext theChunkContext) throws Exception {
        Map jobParameters = theChunkContext.getStepContext().getJobParameters();
        if (jobParameters.containsKey("jobUUID")) {
            CreateBulkExportEntityTasklet.addUUIDToJobContext(theChunkContext, (String)jobParameters.get("jobUUID"));
            return RepeatStatus.FINISHED;
        }
        String resourceTypes = (String)jobParameters.get("resourceTypes");
        Date since = (Date)jobParameters.get("since");
        String filters = (String)jobParameters.get("filters");
        Set filterSet = StringUtils.isBlank((CharSequence)filters) ? null : Arrays.stream(filters.split(",")).collect(Collectors.toSet());
        Set resourceTypeSet = Arrays.stream(resourceTypes.split(",")).collect(Collectors.toSet());
        String outputFormat = (String)jobParameters.get("outputFormat");
        if (StringUtils.isBlank((CharSequence)outputFormat)) {
            outputFormat = "application/fhir+ndjson";
        }
        BulkDataExportOptions bulkDataExportOptions = new BulkDataExportOptions();
        bulkDataExportOptions.setOutputFormat(outputFormat);
        bulkDataExportOptions.setResourceTypes(resourceTypeSet);
        bulkDataExportOptions.setSince(since);
        bulkDataExportOptions.setFilters(filterSet);
        String exportStyle = (String)jobParameters.get("exportStyle");
        bulkDataExportOptions.setExportStyle(BulkDataExportOptions.ExportStyle.valueOf((String)exportStyle));
        String groupId = (String)jobParameters.get("groupId");
        bulkDataExportOptions.setGroupId((IIdType)new IdDt(groupId));
        IBulkDataExportSvc.JobInfo jobInfo = this.myBulkDataExportSvc.submitJob(bulkDataExportOptions);
        CreateBulkExportEntityTasklet.addUUIDToJobContext(theChunkContext, jobInfo.getJobId());
        return RepeatStatus.FINISHED;
    }

    public static void addUUIDToJobContext(ChunkContext theChunkContext, String theJobUUID) {
        theChunkContext.getStepContext().getStepExecution().getJobExecution().getExecutionContext().putString("jobUUID", theJobUUID);
    }
}

