/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.bulk.export.job;

import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.batch.log.Logs;
import ca.uhn.fhir.jpa.bulk.export.job.BaseBulkItemReader;
import ca.uhn.fhir.jpa.dao.IResultIterator;
import ca.uhn.fhir.jpa.dao.ISearchBuilder;
import ca.uhn.fhir.jpa.dao.data.IMdmLinkDao;
import ca.uhn.fhir.jpa.dao.index.IdHelperService;
import ca.uhn.fhir.jpa.dao.mdm.MdmExpansionCacheSvc;
import ca.uhn.fhir.jpa.model.search.SearchRuntimeDetails;
import ca.uhn.fhir.jpa.partition.SystemRequestDetails;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.util.QueryChunker;
import ca.uhn.fhir.mdm.api.MdmMatchResultEnum;
import ca.uhn.fhir.model.api.IQueryParameterOr;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import ca.uhn.fhir.rest.param.ReferenceOrListParam;
import ca.uhn.fhir.rest.param.ReferenceParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.springframework.batch.item.ItemReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class GroupBulkItemReader
extends BaseBulkItemReader
implements ItemReader<List<ResourcePersistentId>> {
    private static final Logger ourLog = Logs.getBatchTroubleshootingLog();
    public static final int QUERY_CHUNK_SIZE = 100;
    @Value(value="#{jobParameters['groupId']}")
    private String myGroupId;
    @Value(value="#{jobParameters['expandMdm'] ?: false}")
    private boolean myMdmEnabled;
    @Autowired
    private IdHelperService myIdHelperService;
    @Autowired
    private IMdmLinkDao myMdmLinkDao;
    @Autowired
    private MdmExpansionCacheSvc myMdmExpansionCacheSvc;

    @Override
    protected Iterator<ResourcePersistentId> getResourcePidIterator() {
        HashSet myReadPids = new HashSet();
        if (this.myResourceType.equalsIgnoreCase("Patient")) {
            return this.getExpandedPatientIterator();
        }
        Set<String> expandedMemberResourceIds = this.expandAllPatientPidsFromGroup();
        if (ourLog.isDebugEnabled()) {
            ourLog.debug("Group/{} has been expanded to members:[{}]", (Object)this.myGroupId, (Object)String.join((CharSequence)",", expandedMemberResourceIds));
        }
        QueryChunker<String> queryChunker = new QueryChunker<String>();
        queryChunker.chunk(new ArrayList<String>(expandedMemberResourceIds), 100, idChunk -> this.queryResourceTypeWithReferencesToPatients(myReadPids, (List<String>)idChunk));
        if (ourLog.isDebugEnabled()) {
            ourLog.debug("Resource PIDs to be Bulk Exported: [{}]", (Object)myReadPids.stream().map(ResourcePersistentId::toString).collect(Collectors.joining(",")));
        }
        return myReadPids.iterator();
    }

    private Iterator<ResourcePersistentId> getExpandedPatientIterator() {
        List<String> members = this.getMembers();
        List<IIdType> ids = members.stream().map(member -> new IdDt("Patient/" + member)).collect(Collectors.toList());
        List<Long> pidsOrThrowException = this.myIdHelperService.getPidsOrThrowException(ids);
        HashSet<Long> patientPidsToExport = new HashSet<Long>(pidsOrThrowException);
        if (this.myMdmEnabled) {
            SystemRequestDetails srd = SystemRequestDetails.newSystemRequestAllPartitions();
            IBaseResource group = this.myDaoRegistry.getResourceDao("Group").read((IIdType)new IdDt(this.myGroupId), (RequestDetails)srd);
            Long pidOrNull = this.myIdHelperService.getPidOrNull(group);
            List<IMdmLinkDao.MdmPidTuple> goldenPidSourcePidTuple = this.myMdmLinkDao.expandPidsFromGroupPidGivenMatchResult(pidOrNull, MdmMatchResultEnum.MATCH);
            goldenPidSourcePidTuple.forEach(tuple -> {
                patientPidsToExport.add(tuple.getGoldenPid());
                patientPidsToExport.add(tuple.getSourcePid());
            });
            this.populateMdmResourceCache(goldenPidSourcePidTuple);
        }
        List resourcePersistentIds = patientPidsToExport.stream().map(ResourcePersistentId::new).collect(Collectors.toList());
        return resourcePersistentIds.iterator();
    }

    private void populateMdmResourceCache(List<IMdmLinkDao.MdmPidTuple> thePidTuples) {
        if (this.myMdmExpansionCacheSvc.hasBeenPopulated()) {
            return;
        }
        HashMap<Long, Set<Long>> goldenResourceToSourcePidMap = new HashMap<Long, Set<Long>>();
        this.extract(thePidTuples, goldenResourceToSourcePidMap);
        HashMap<String, String> sourceResourceIdToGoldenResourceIdMap = new HashMap<String, String>();
        goldenResourceToSourcePidMap.forEach((key, value) -> {
            String goldenResourceId = this.myIdHelperService.translatePidIdToForcedIdWithCache(new ResourcePersistentId(key)).orElse(key.toString());
            Map<Long, Optional<String>> pidsToForcedIds = this.myIdHelperService.translatePidsToForcedIds((Set<Long>)value);
            Set<String> sourceResourceIds = pidsToForcedIds.entrySet().stream().map(ent -> ((Optional)ent.getValue()).isPresent() ? (String)((Optional)ent.getValue()).get() : ((Long)ent.getKey()).toString()).collect(Collectors.toSet());
            sourceResourceIds.forEach(sourceResourceId -> sourceResourceIdToGoldenResourceIdMap.put((String)sourceResourceId, goldenResourceId));
        });
        this.myMdmExpansionCacheSvc.setCacheContents(sourceResourceIdToGoldenResourceIdMap);
    }

    private List<String> getMembers() {
        SystemRequestDetails requestDetails = SystemRequestDetails.newSystemRequestAllPartitions();
        IBaseResource group = this.myDaoRegistry.getResourceDao("Group").read((IIdType)new IdDt(this.myGroupId), (RequestDetails)requestDetails);
        List evaluate = this.myContext.newFhirPath().evaluate((IBase)group, "member.entity.reference", IPrimitiveType.class);
        return evaluate.stream().map(IPrimitiveType::getValueAsString).collect(Collectors.toList());
    }

    private Set<String> expandAllPatientPidsFromGroup() {
        HashSet<String> expandedIds = new HashSet<String>();
        SystemRequestDetails requestDetails = SystemRequestDetails.newSystemRequestAllPartitions();
        IBaseResource group = this.myDaoRegistry.getResourceDao("Group").read((IIdType)new IdDt(this.myGroupId), (RequestDetails)requestDetails);
        Long pidOrNull = this.myIdHelperService.getPidOrNull(group);
        if (this.myMdmEnabled) {
            List<IMdmLinkDao.MdmPidTuple> goldenPidTargetPidTuples = this.myMdmLinkDao.expandPidsFromGroupPidGivenMatchResult(pidOrNull, MdmMatchResultEnum.MATCH);
            HashSet<Long> uniquePids = new HashSet<Long>();
            goldenPidTargetPidTuples.forEach(tuple -> {
                uniquePids.add(tuple.getGoldenPid());
                uniquePids.add(tuple.getSourcePid());
            });
            Map<Long, Optional<String>> pidToForcedIdMap = this.myIdHelperService.translatePidsToForcedIds(uniquePids);
            HashMap<Long, Set<Long>> goldenResourceToSourcePidMap = new HashMap<Long, Set<Long>>();
            this.extract(goldenPidTargetPidTuples, goldenResourceToSourcePidMap);
            this.populateMdmResourceCache(goldenPidTargetPidTuples);
            Set resolvedResourceIds = pidToForcedIdMap.entrySet().stream().map(entry -> ((Optional)entry.getValue()).isPresent() ? (String)((Optional)entry.getValue()).get() : ((Long)entry.getKey()).toString()).collect(Collectors.toSet());
            expandedIds.addAll(resolvedResourceIds);
        }
        expandedIds.addAll(this.getMembers());
        return expandedIds;
    }

    private void extract(List<IMdmLinkDao.MdmPidTuple> theGoldenPidTargetPidTuples, Map<Long, Set<Long>> theGoldenResourceToSourcePidMap) {
        for (IMdmLinkDao.MdmPidTuple goldenPidTargetPidTuple : theGoldenPidTargetPidTuples) {
            Long goldenPid = goldenPidTargetPidTuple.getGoldenPid();
            Long sourcePid = goldenPidTargetPidTuple.getSourcePid();
            theGoldenResourceToSourcePidMap.computeIfAbsent(goldenPid, key -> new HashSet()).add(sourcePid);
        }
    }

    private void queryResourceTypeWithReferencesToPatients(Set<ResourcePersistentId> myReadPids, List<String> idChunk) {
        List<SearchParameterMap> expandedSpMaps = this.createSearchParameterMapsForResourceType();
        for (SearchParameterMap expandedSpMap : expandedSpMaps) {
            this.validateSearchParameters(expandedSpMap);
            this.filterSearchByResourceIds(idChunk, expandedSpMap);
            ISearchBuilder searchBuilder = this.getSearchBuilderForLocalResourceType();
            IResultIterator resultIterator = searchBuilder.createQuery(expandedSpMap, new SearchRuntimeDetails(null, this.myJobUUID), null, RequestPartitionId.allPartitions());
            while (resultIterator.hasNext()) {
                myReadPids.add((ResourcePersistentId)resultIterator.next());
            }
        }
    }

    private void filterSearchByResourceIds(List<String> idChunk, SearchParameterMap expandedSpMap) {
        ReferenceOrListParam orList = new ReferenceOrListParam();
        idChunk.forEach(id -> orList.add((IQueryParameterType)new ReferenceParam(id)));
        expandedSpMap.add(this.getPatientSearchParamForCurrentResourceType().getName(), (IQueryParameterOr)orList);
    }

    private RuntimeSearchParam validateSearchParameters(SearchParameterMap expandedSpMap) {
        RuntimeSearchParam runtimeSearchParam = this.getPatientSearchParamForCurrentResourceType();
        if (expandedSpMap.get(runtimeSearchParam.getName()) != null) {
            throw new IllegalArgumentException(String.format("Group Bulk Export manually modifies the Search Parameter called [%s], so you may not include this search parameter in your _typeFilter!", runtimeSearchParam.getName()));
        }
        return runtimeSearchParam;
    }
}

