/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.bulk.export.job;

import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.batch.log.Logs;
import ca.uhn.fhir.jpa.bulk.export.job.BaseBulkItemReader;
import ca.uhn.fhir.jpa.dao.IResultIterator;
import ca.uhn.fhir.jpa.dao.ISearchBuilder;
import ca.uhn.fhir.jpa.model.search.SearchRuntimeDetails;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import ca.uhn.fhir.rest.param.ReferenceParam;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.springframework.batch.item.ItemReader;
import org.springframework.beans.factory.annotation.Autowired;

public class PatientBulkItemReader
extends BaseBulkItemReader
implements ItemReader<List<ResourcePersistentId>> {
    @Autowired
    private DaoConfig myDaoConfig;
    private static final Logger ourLog = Logs.getBatchTroubleshootingLog();

    private RuntimeSearchParam validateSearchParameters(SearchParameterMap expandedSpMap) {
        RuntimeSearchParam runtimeSearchParam = this.getPatientSearchParamForCurrentResourceType();
        if (expandedSpMap.get(runtimeSearchParam.getName()) != null) {
            throw new IllegalArgumentException(String.format("Patient Bulk Export manually modifies the Search Parameter called [%s], so you may not include this search parameter in your _typeFilter!", runtimeSearchParam.getName()));
        }
        return runtimeSearchParam;
    }

    @Override
    protected Iterator<ResourcePersistentId> getResourcePidIterator() {
        if (this.myDaoConfig.getIndexMissingFields() == DaoConfig.IndexEnabledEnum.DISABLED) {
            String errorMessage = "You attempted to start a Patient Bulk Export, but the system has `Index Missing Fields` disabled. It must be enabled for Patient Bulk Export";
            ourLog.error(errorMessage);
            throw new IllegalStateException(errorMessage);
        }
        ArrayList<ResourcePersistentId> myReadPids = new ArrayList<ResourcePersistentId>();
        List<SearchParameterMap> maps = this.createSearchParameterMapsForResourceType();
        String patientSearchParam = this.getPatientSearchParamForCurrentResourceType().getName();
        for (SearchParameterMap map : maps) {
            this.validateSearchParameters(map);
            if (!this.myResourceType.equalsIgnoreCase("Patient")) {
                map.add(patientSearchParam, (IQueryParameterType)new ReferenceParam().setMissing(Boolean.valueOf(false)));
            }
            ourLog.debug("About to execute query {}", (Object)map.toNormalizedQueryString(this.myContext));
            ISearchBuilder sb = this.getSearchBuilderForLocalResourceType();
            IResultIterator myResultIterator = sb.createQuery(map, new SearchRuntimeDetails(null, this.myJobUUID), null, RequestPartitionId.allPartitions());
            while (myResultIterator.hasNext()) {
                myReadPids.add((ResourcePersistentId)myResultIterator.next());
            }
        }
        return myReadPids.iterator();
    }
}

