/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.bulk.export.job;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.model.DaoMethodOutcome;
import ca.uhn.fhir.jpa.batch.log.Logs;
import ca.uhn.fhir.jpa.bulk.export.svc.BulkExportDaoSvc;
import ca.uhn.fhir.jpa.entity.BulkExportCollectionFileEntity;
import ca.uhn.fhir.jpa.partition.SystemRequestDetails;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.util.BinaryUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.hl7.fhir.instance.model.api.IBaseBinary;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class ResourceToFileWriter
implements ItemWriter<List<IBaseResource>> {
    private static final Logger ourLog = Logs.getBatchTroubleshootingLog();
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private BulkExportDaoSvc myBulkExportDaoSvc;
    private final ByteArrayOutputStream myOutputStream = new ByteArrayOutputStream();
    private final OutputStreamWriter myWriter = new OutputStreamWriter((OutputStream)this.myOutputStream, Constants.CHARSET_UTF8);
    private IParser myParser;
    @Value(value="#{stepExecutionContext['bulkExportCollectionEntityId']}")
    private Long myBulkExportCollectionEntityId;
    @Value(value="#{stepExecutionContext['resourceType']}")
    private String myResourceType;
    private IFhirResourceDao<IBaseBinary> myBinaryDao;

    @PostConstruct
    public void start() {
        this.myParser = this.myFhirContext.newJsonParser().setPrettyPrint(false);
        this.myBinaryDao = this.getBinaryDao();
    }

    private Optional<IIdType> flushToFiles() {
        if (this.myOutputStream.size() > 0) {
            IIdType createdId = this.createBinaryFromOutputStream();
            BulkExportCollectionFileEntity file = new BulkExportCollectionFileEntity();
            file.setResource(createdId.getIdPart());
            this.myBulkExportDaoSvc.addFileToCollectionWithId(this.myBulkExportCollectionEntityId, file);
            this.myOutputStream.reset();
            return Optional.of(createdId);
        }
        return Optional.empty();
    }

    private IIdType createBinaryFromOutputStream() {
        IBaseBinary binary = BinaryUtil.newBinary((FhirContext)this.myFhirContext);
        binary.setContentType("application/fhir+ndjson");
        binary.setContent(this.myOutputStream.toByteArray());
        DaoMethodOutcome outcome = this.myBinaryDao.create((IBaseResource)binary, (RequestDetails)new SystemRequestDetails().setRequestPartitionId(RequestPartitionId.defaultPartition()));
        return outcome.getResource().getIdElement();
    }

    private IFhirResourceDao<IBaseBinary> getBinaryDao() {
        return this.myDaoRegistry.getResourceDao("Binary");
    }

    public void write(List<? extends List<IBaseResource>> theList) throws Exception {
        int count = 0;
        for (List<IBaseResource> list : theList) {
            for (IBaseResource nextFileResource : list) {
                this.myParser.encodeResourceToWriter(nextFileResource, (Writer)this.myWriter);
                this.myWriter.append("\n");
                ++count;
            }
        }
        Optional<IIdType> createdId = this.flushToFiles();
        if (createdId.isPresent()) {
            ourLog.info("Created {} resources for bulk export file containing {} resources of type {} ", new Object[]{count, createdId.get().toUnqualifiedVersionless().getValue(), this.myResourceType});
        }
    }
}

