/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.bulk.export.job;

import ca.uhn.fhir.jpa.bulk.export.svc.BulkExportDaoSvc;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.partition.support.Partitioner;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class ResourceTypePartitioner
implements Partitioner {
    private static final Logger ourLog = LoggerFactory.getLogger(ResourceTypePartitioner.class);
    @Value(value="#{jobExecutionContext['jobUUID']}")
    private String myJobUUID;
    @Autowired
    private BulkExportDaoSvc myBulkExportDaoSvc;

    public Map<String, ExecutionContext> partition(int gridSize) {
        HashMap<String, ExecutionContext> partitionContextMap = new HashMap<String, ExecutionContext>();
        Map<Long, String> idToResourceType = this.myBulkExportDaoSvc.getBulkJobCollectionIdToResourceTypeMap(this.myJobUUID);
        idToResourceType.entrySet().stream().forEach(entry -> {
            String resourceType = (String)entry.getValue();
            Long collectionEntityId = (Long)entry.getKey();
            ourLog.debug("Creating a partition step for CollectionEntity: [{}] processing resource type [{}]", (Object)collectionEntityId, (Object)resourceType);
            ExecutionContext context = new ExecutionContext();
            context.putString("resourceType", resourceType);
            context.putString("jobUUID", this.myJobUUID);
            context.putLong("bulkExportCollectionEntityId", collectionEntityId.longValue());
            partitionContextMap.put(resourceType, context);
        });
        return partitionContextMap;
    }
}

