/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.bulk.export.svc;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.model.ExpungeOptions;
import ca.uhn.fhir.jpa.batch.api.IBatchJobSubmitter;
import ca.uhn.fhir.jpa.bulk.export.api.IBulkDataExportSvc;
import ca.uhn.fhir.jpa.bulk.export.model.BulkExportJobStatusEnum;
import ca.uhn.fhir.jpa.dao.data.IBulkExportCollectionDao;
import ca.uhn.fhir.jpa.dao.data.IBulkExportCollectionFileDao;
import ca.uhn.fhir.jpa.dao.data.IBulkExportJobDao;
import ca.uhn.fhir.jpa.entity.BulkExportCollectionEntity;
import ca.uhn.fhir.jpa.entity.BulkExportCollectionFileEntity;
import ca.uhn.fhir.jpa.entity.BulkExportJobEntity;
import ca.uhn.fhir.jpa.model.sched.HapiJob;
import ca.uhn.fhir.jpa.model.sched.ISchedulerService;
import ca.uhn.fhir.jpa.model.sched.ScheduledJobDefinition;
import ca.uhn.fhir.jpa.partition.SystemRequestDetails;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.bulk.BulkDataExportOptions;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.util.CompositeInterceptorBroadcaster;
import ca.uhn.fhir.util.UrlUtil;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.hl7.fhir.instance.model.api.IBaseBinary;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.InstantType;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class BulkDataExportSvcImpl
implements IBulkDataExportSvc {
    private static final Long READ_CHUNK_SIZE = 10L;
    private static final Logger ourLog = LoggerFactory.getLogger(BulkDataExportSvcImpl.class);
    private final int myReuseBulkExportForMillis = 3600000;
    @Autowired
    private IBulkExportJobDao myBulkExportJobDao;
    @Autowired
    private IBulkExportCollectionDao myBulkExportCollectionDao;
    @Autowired
    private IBulkExportCollectionFileDao myBulkExportCollectionFileDao;
    @Autowired
    private ISchedulerService mySchedulerService;
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private FhirContext myContext;
    @Autowired
    private PlatformTransactionManager myTxManager;
    private TransactionTemplate myTxTemplate;
    @Autowired
    private IBatchJobSubmitter myJobSubmitter;
    @Autowired
    @Qualifier(value="bulkExportJob")
    private org.springframework.batch.core.Job myBulkExportJob;
    @Autowired
    @Qualifier(value="groupBulkExportJob")
    private org.springframework.batch.core.Job myGroupBulkExportJob;
    @Autowired
    @Qualifier(value="patientBulkExportJob")
    private org.springframework.batch.core.Job myPatientBulkExportJob;
    private Set<String> myCompartmentResources;
    private final int myRetentionPeriod = 0x6DDD00;
    @Autowired
    private DaoConfig myDaoConfig;
    @Autowired
    private IInterceptorBroadcaster myInterceptorBroadcaster;

    @Override
    @Transactional(value=Transactional.TxType.NEVER)
    public synchronized void buildExportFiles() {
        if (!this.myDaoConfig.isEnableTaskBulkExportJobExecution()) {
            return;
        }
        Optional jobToProcessOpt = (Optional)this.myTxTemplate.execute(t -> {
            PageRequest page = PageRequest.of((int)0, (int)1);
            Slice<BulkExportJobEntity> submittedJobs = this.myBulkExportJobDao.findByStatus((Pageable)page, BulkExportJobStatusEnum.SUBMITTED);
            if (submittedJobs.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of((BulkExportJobEntity)submittedJobs.getContent().get(0));
        });
        if (!jobToProcessOpt.isPresent()) {
            return;
        }
        BulkExportJobEntity bulkExportJobEntity = (BulkExportJobEntity)jobToProcessOpt.get();
        String jobUuid = bulkExportJobEntity.getJobId();
        try {
            this.processJob(bulkExportJobEntity);
        }
        catch (Exception e) {
            ourLog.error("Failure while preparing bulk export extract", (Throwable)e);
            this.myTxTemplate.execute(t -> {
                Optional<BulkExportJobEntity> submittedJobs = this.myBulkExportJobDao.findByJobId(jobUuid);
                if (submittedJobs.isPresent()) {
                    BulkExportJobEntity jobEntity = submittedJobs.get();
                    jobEntity.setStatus(BulkExportJobStatusEnum.ERROR);
                    jobEntity.setStatusMessage(e.getMessage());
                    this.myBulkExportJobDao.save(jobEntity);
                }
                return null;
            });
        }
    }

    private String getQueryParameterIfPresent(String theRequestString, String theParameter) {
        CharSequence[] strings;
        Map stringMap = UrlUtil.parseQueryString((String)theRequestString);
        if (stringMap != null && (strings = (String[])stringMap.get(theParameter)) != null) {
            return String.join((CharSequence)",", strings);
        }
        return null;
    }

    @Override
    @Transactional(value=Transactional.TxType.NEVER)
    public void purgeExpiredFiles() {
        if (!this.myDaoConfig.isEnableTaskBulkExportJobExecution()) {
            return;
        }
        Optional jobToDelete = (Optional)this.myTxTemplate.execute(t -> {
            PageRequest page = PageRequest.of((int)0, (int)1);
            Slice<BulkExportJobEntity> submittedJobs = this.myBulkExportJobDao.findByExpiry((Pageable)page, new Date());
            if (submittedJobs.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of((BulkExportJobEntity)submittedJobs.getContent().get(0));
        });
        if (jobToDelete.isPresent()) {
            ourLog.info("Deleting bulk export job: {}", jobToDelete.get());
            this.myTxTemplate.execute(t -> {
                BulkExportJobEntity job = (BulkExportJobEntity)this.myBulkExportJobDao.getOne(((BulkExportJobEntity)jobToDelete.get()).getId());
                for (BulkExportCollectionEntity nextCollection : job.getCollections()) {
                    for (BulkExportCollectionFileEntity nextFile : nextCollection.getFiles()) {
                        ourLog.info("Purging bulk data file: {}", (Object)nextFile.getResourceId());
                        this.getBinaryDao().delete(this.toId(nextFile.getResourceId()), (RequestDetails)new SystemRequestDetails());
                        this.getBinaryDao().forceExpungeInExistingTransaction(this.toId(nextFile.getResourceId()), new ExpungeOptions().setExpungeDeletedResources(true).setExpungeOldVersions(true), (RequestDetails)new SystemRequestDetails());
                        this.myBulkExportCollectionFileDao.deleteByPid(nextFile.getId());
                    }
                    this.myBulkExportCollectionDao.deleteByPid(nextCollection.getId());
                }
                ourLog.info("*** ABOUT TO DELETE");
                this.myBulkExportJobDao.deleteByPid(job.getId());
                return null;
            });
            ourLog.info("Finished deleting bulk export job: {}", jobToDelete.get());
        }
    }

    private void processJob(BulkExportJobEntity theBulkExportJobEntity) {
        String theJobUuid = theBulkExportJobEntity.getJobId();
        JobParametersBuilder parameters = new JobParametersBuilder().addString("jobUUID", theJobUuid).addLong("readChunkSize", READ_CHUNK_SIZE);
        ourLog.info("Submitting bulk export job {} to job scheduler", (Object)theJobUuid);
        try {
            if (this.isGroupBulkJob(theBulkExportJobEntity)) {
                this.enhanceBulkParametersWithGroupParameters(theBulkExportJobEntity, parameters);
                this.myJobSubmitter.runJob(this.myGroupBulkExportJob, parameters.toJobParameters());
            } else if (this.isPatientBulkJob(theBulkExportJobEntity)) {
                this.myJobSubmitter.runJob(this.myPatientBulkExportJob, parameters.toJobParameters());
            } else {
                this.myJobSubmitter.runJob(this.myBulkExportJob, parameters.toJobParameters());
            }
        }
        catch (JobParametersInvalidException theE) {
            ourLog.error("Unable to start job with UUID: {}, the parameters are invalid. {}", (Object)theJobUuid, (Object)theE.getMessage());
        }
    }

    private boolean isPatientBulkJob(BulkExportJobEntity theBulkExportJobEntity) {
        return theBulkExportJobEntity.getRequest().startsWith("/Patient/");
    }

    private boolean isGroupBulkJob(BulkExportJobEntity theBulkExportJobEntity) {
        return theBulkExportJobEntity.getRequest().startsWith("/Group/");
    }

    private void enhanceBulkParametersWithGroupParameters(BulkExportJobEntity theBulkExportJobEntity, JobParametersBuilder theParameters) {
        String theGroupId = this.getQueryParameterIfPresent(theBulkExportJobEntity.getRequest(), "_groupId");
        String expandMdm = this.getQueryParameterIfPresent(theBulkExportJobEntity.getRequest(), "_mdm");
        theParameters.addString("groupId", theGroupId);
        theParameters.addString("expandMdm", expandMdm);
    }

    private IFhirResourceDao<IBaseBinary> getBinaryDao() {
        return this.myDaoRegistry.getResourceDao("Binary");
    }

    @PostConstruct
    public void start() {
        this.myTxTemplate = new TransactionTemplate(this.myTxManager);
        ScheduledJobDefinition jobDetail = new ScheduledJobDefinition();
        jobDetail.setId(Job.class.getName());
        jobDetail.setJobClass(Job.class);
        this.mySchedulerService.scheduleClusteredJob(10000L, jobDetail);
        jobDetail = new ScheduledJobDefinition();
        jobDetail.setId(PurgeExpiredFilesJob.class.getName());
        jobDetail.setJobClass(PurgeExpiredFilesJob.class);
        this.mySchedulerService.scheduleClusteredJob(3600000L, jobDetail);
    }

    @Override
    @Transactional
    @Deprecated
    public IBulkDataExportSvc.JobInfo submitJob(BulkDataExportOptions theBulkDataExportOptions) {
        return this.submitJob(theBulkDataExportOptions, true, null);
    }

    @Override
    @Transactional
    public IBulkDataExportSvc.JobInfo submitJob(BulkDataExportOptions theBulkDataExportOptions, Boolean useCache, RequestDetails theRequestDetails) {
        Date since;
        String outputFormat = "application/fhir+ndjson";
        if (StringUtils.isNotBlank((CharSequence)theBulkDataExportOptions.getOutputFormat())) {
            outputFormat = theBulkDataExportOptions.getOutputFormat();
        }
        if (!Constants.CTS_NDJSON.contains(outputFormat)) {
            throw new InvalidRequestException("Invalid output format: " + theBulkDataExportOptions.getOutputFormat());
        }
        HookParams params = new HookParams().add(BulkDataExportOptions.class, (Object)theBulkDataExportOptions).add(RequestDetails.class, (Object)theRequestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)theRequestDetails);
        CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequestDetails, (Pointcut)Pointcut.STORAGE_INITIATE_BULK_EXPORT, (HookParams)params);
        StringBuilder requestBuilder = new StringBuilder();
        requestBuilder.append("/");
        if (theBulkDataExportOptions.getExportStyle().equals((Object)BulkDataExportOptions.ExportStyle.GROUP)) {
            requestBuilder.append(theBulkDataExportOptions.getGroupId().toVersionless()).append("/");
        } else if (theBulkDataExportOptions.getExportStyle().equals((Object)BulkDataExportOptions.ExportStyle.PATIENT)) {
            requestBuilder.append("Patient/");
        }
        requestBuilder.append("$export");
        requestBuilder.append("?").append("_outputFormat").append("=").append(UrlUtil.escapeUrlParam((String)outputFormat));
        Set<String> resourceTypes = theBulkDataExportOptions.getResourceTypes();
        if (resourceTypes != null) {
            requestBuilder.append("&").append("_type").append("=").append(String.join((CharSequence)",", UrlUtil.escapeUrlParams((Collection)resourceTypes)));
        }
        if ((since = theBulkDataExportOptions.getSince()) != null) {
            requestBuilder.append("&").append("_since").append("=").append(new InstantType(since).setTimeZoneZulu(true).getValueAsString());
        }
        if (theBulkDataExportOptions.getFilters() != null && theBulkDataExportOptions.getFilters().size() > 0) {
            theBulkDataExportOptions.getFilters().stream().forEach(filter -> requestBuilder.append("&").append("_typeFilter").append("=").append(UrlUtil.escapeUrlParam((String)filter)));
        }
        if (theBulkDataExportOptions.getExportStyle().equals((Object)BulkDataExportOptions.ExportStyle.GROUP)) {
            requestBuilder.append("&").append("_groupId").append("=").append(theBulkDataExportOptions.getGroupId().getValue());
            requestBuilder.append("&").append("_mdm").append("=").append(theBulkDataExportOptions.isExpandMdm());
        }
        String request = requestBuilder.toString();
        if (useCache.booleanValue()) {
            Date cutoff = DateUtils.addMilliseconds((Date)new Date(), (int)-3600000);
            PageRequest page = PageRequest.of((int)0, (int)10);
            Slice<BulkExportJobEntity> existing = this.myBulkExportJobDao.findExistingJob((Pageable)page, request, cutoff, BulkExportJobStatusEnum.ERROR);
            if (!existing.isEmpty()) {
                return this.toSubmittedJobInfo((BulkExportJobEntity)existing.iterator().next());
            }
        }
        if (resourceTypes != null && resourceTypes.contains("Binary")) {
            String msg = this.myContext.getLocalizer().getMessage(BulkDataExportSvcImpl.class, "onlyBinarySelected", new Object[0]);
            throw new InvalidRequestException(msg);
        }
        if (resourceTypes == null || resourceTypes.isEmpty()) {
            resourceTypes = this.getAllowedResourceTypesForBulkExportStyle(theBulkDataExportOptions.getExportStyle());
            if (since == null) {
                since = DateUtils.addDays((Date)new Date(), (int)-1);
            }
        }
        resourceTypes = resourceTypes.stream().filter(t -> !"Binary".equals(t)).collect(Collectors.toSet());
        BulkExportJobEntity job = new BulkExportJobEntity();
        job.setJobId(UUID.randomUUID().toString());
        job.setStatus(BulkExportJobStatusEnum.SUBMITTED);
        job.setSince(since);
        job.setCreated(new Date());
        job.setRequest(request);
        this.validateTypes(resourceTypes);
        this.validateTypeFilters(theBulkDataExportOptions.getFilters(), resourceTypes);
        this.updateExpiry(job);
        this.myBulkExportJobDao.save(job);
        for (String nextType : resourceTypes) {
            BulkExportCollectionEntity collection = new BulkExportCollectionEntity();
            collection.setJob(job);
            collection.setResourceType(nextType);
            job.getCollections().add(collection);
            this.myBulkExportCollectionDao.save(collection);
        }
        ourLog.info("Bulk export job submitted: {}", (Object)job.toString());
        return this.toSubmittedJobInfo(job);
    }

    public void validateTypes(Set<String> theResourceTypes) {
        for (String nextType : theResourceTypes) {
            if (this.myDaoRegistry.isResourceTypeSupported(nextType)) continue;
            String msg = this.myContext.getLocalizer().getMessage(BulkDataExportSvcImpl.class, "unknownResourceType", new Object[]{nextType});
            throw new InvalidRequestException(msg);
        }
    }

    public void validateTypeFilters(Set<String> theTheFilters, Set<String> theResourceTypes) {
        if (theTheFilters != null) {
            for (String next : theTheFilters) {
                if (!next.contains("?")) {
                    throw new InvalidRequestException("Invalid _typeFilter value \"" + next + "\". Must be in the form [ResourceType]?[params]");
                }
                String resourceType = next.substring(0, next.indexOf("?"));
                if (theResourceTypes.contains(resourceType)) continue;
                throw new InvalidRequestException("Invalid _typeFilter value \"" + next + "\". Resource type does not appear in " + "_type" + " list");
            }
        }
    }

    private IBulkDataExportSvc.JobInfo toSubmittedJobInfo(BulkExportJobEntity theJob) {
        return new IBulkDataExportSvc.JobInfo().setJobId(theJob.getJobId()).setStatus(theJob.getStatus());
    }

    private void updateExpiry(BulkExportJobEntity theJob) {
        theJob.setExpiry(DateUtils.addMilliseconds((Date)new Date(), (int)0x6DDD00));
    }

    @Override
    @Transactional
    public IBulkDataExportSvc.JobInfo getJobInfoOrThrowResourceNotFound(String theJobId) {
        BulkExportJobEntity job = this.myBulkExportJobDao.findByJobId(theJobId).orElseThrow(() -> new ResourceNotFoundException(theJobId));
        IBulkDataExportSvc.JobInfo retVal = new IBulkDataExportSvc.JobInfo();
        retVal.setJobId(theJobId);
        retVal.setStatus(job.getStatus());
        retVal.setStatus(job.getStatus());
        retVal.setStatusTime(job.getStatusTime());
        retVal.setStatusMessage(job.getStatusMessage());
        retVal.setRequest(job.getRequest());
        if (job.getStatus() == BulkExportJobStatusEnum.COMPLETE) {
            for (BulkExportCollectionEntity nextCollection : job.getCollections()) {
                for (BulkExportCollectionFileEntity nextFile : nextCollection.getFiles()) {
                    retVal.addFile().setResourceType(nextCollection.getResourceType()).setResourceId(this.toQualifiedBinaryId(nextFile.getResourceId()));
                }
            }
        }
        return retVal;
    }

    @Override
    public Set<String> getPatientCompartmentResources() {
        if (this.myCompartmentResources == null) {
            this.myCompartmentResources = this.myContext.getResourceTypes().stream().filter(this::resourceTypeIsInPatientCompartment).collect(Collectors.toSet());
        }
        return this.myCompartmentResources;
    }

    private boolean resourceTypeIsInPatientCompartment(String theResourceType) {
        RuntimeResourceDefinition runtimeResourceDefinition = this.myContext.getResourceDefinition(theResourceType);
        List searchParams = runtimeResourceDefinition.getSearchParamsForCompartmentName("Patient");
        return searchParams != null && searchParams.size() >= 1;
    }

    public Set<String> getAllowedResourceTypesForBulkExportStyle(BulkDataExportOptions.ExportStyle theExportStyle) {
        if (theExportStyle.equals((Object)BulkDataExportOptions.ExportStyle.SYSTEM)) {
            return this.myContext.getResourceTypes();
        }
        if (theExportStyle.equals((Object)BulkDataExportOptions.ExportStyle.GROUP) || theExportStyle.equals((Object)BulkDataExportOptions.ExportStyle.PATIENT)) {
            return this.getPatientCompartmentResources();
        }
        throw new IllegalArgumentException(String.format("HAPI FHIR does not recognize a Bulk Export request of type: %s", theExportStyle));
    }

    private IIdType toId(String theResourceId) {
        IIdType retVal = this.myContext.getVersion().newIdType();
        retVal.setValue(theResourceId);
        return retVal;
    }

    private IIdType toQualifiedBinaryId(String theIdPart) {
        IIdType retVal = this.myContext.getVersion().newIdType();
        retVal.setParts(null, "Binary", theIdPart, null);
        return retVal;
    }

    @Override
    @Transactional(value=Transactional.TxType.NEVER)
    public synchronized void cancelAndPurgeAllJobs() {
        this.myTxTemplate.execute(t -> {
            ourLog.info("Deleting all files");
            this.myBulkExportCollectionFileDao.deleteAllFiles();
            ourLog.info("Deleting all collections");
            this.myBulkExportCollectionDao.deleteAllFiles();
            ourLog.info("Deleting all jobs");
            this.myBulkExportJobDao.deleteAllFiles();
            return null;
        });
    }

    public static class Job
    implements HapiJob {
        @Autowired
        private IBulkDataExportSvc myTarget;

        public void execute(JobExecutionContext theContext) {
            this.myTarget.buildExportFiles();
        }
    }

    public static class PurgeExpiredFilesJob
    implements HapiJob {
        @Autowired
        private IBulkDataExportSvc myTarget;

        public void execute(JobExecutionContext theContext) {
            this.myTarget.purgeExpiredFiles();
        }
    }
}

