/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.bulk.export.svc;

import ca.uhn.fhir.jpa.bulk.export.model.BulkExportJobStatusEnum;
import ca.uhn.fhir.jpa.dao.data.IBulkExportCollectionDao;
import ca.uhn.fhir.jpa.dao.data.IBulkExportCollectionFileDao;
import ca.uhn.fhir.jpa.dao.data.IBulkExportJobDao;
import ca.uhn.fhir.jpa.entity.BulkExportCollectionEntity;
import ca.uhn.fhir.jpa.entity.BulkExportCollectionFileEntity;
import ca.uhn.fhir.jpa.entity.BulkExportJobEntity;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BulkExportDaoSvc {
    private static final Logger ourLog = LoggerFactory.getLogger(BulkExportDaoSvc.class);
    @Autowired
    IBulkExportJobDao myBulkExportJobDao;
    @Autowired
    IBulkExportCollectionDao myBulkExportCollectionDao;
    @Autowired
    IBulkExportCollectionFileDao myBulkExportCollectionFileDao;

    @Transactional
    public void addFileToCollectionWithId(Long theCollectionEntityId, BulkExportCollectionFileEntity theFile) {
        Optional byId = this.myBulkExportCollectionDao.findById(theCollectionEntityId);
        if (byId.isPresent()) {
            BulkExportCollectionEntity exportCollectionEntity = (BulkExportCollectionEntity)byId.get();
            theFile.setCollection(exportCollectionEntity);
            exportCollectionEntity.getFiles().add(theFile);
            this.myBulkExportCollectionFileDao.saveAndFlush(theFile);
            this.myBulkExportCollectionDao.saveAndFlush(exportCollectionEntity);
        }
    }

    @Transactional
    public Map<Long, String> getBulkJobCollectionIdToResourceTypeMap(String theJobUUID) {
        BulkExportJobEntity bulkExportJobEntity = this.loadJob(theJobUUID);
        Collection<BulkExportCollectionEntity> collections = bulkExportJobEntity.getCollections();
        return collections.stream().collect(Collectors.toMap(BulkExportCollectionEntity::getId, BulkExportCollectionEntity::getResourceType));
    }

    private BulkExportJobEntity loadJob(String theJobUUID) {
        Optional<BulkExportJobEntity> jobOpt = this.myBulkExportJobDao.findByJobId(theJobUUID);
        if (!jobOpt.isPresent()) {
            ourLog.warn("Job with UUID {} appears to be deleted", (Object)theJobUUID);
            return null;
        }
        return jobOpt.get();
    }

    @Transactional
    public void setJobToStatus(String theJobUUID, BulkExportJobStatusEnum theStatus) {
        this.setJobToStatus(theJobUUID, theStatus, null);
    }

    @Transactional
    public void setJobToStatus(String theJobUUID, BulkExportJobStatusEnum theStatus, String theStatusMessage) {
        Optional<BulkExportJobEntity> oJob = this.myBulkExportJobDao.findByJobId(theJobUUID);
        if (!oJob.isPresent()) {
            ourLog.error("Job with UUID {} doesn't exist!", (Object)theJobUUID);
            return;
        }
        ourLog.info("Setting job with UUID {} to {}", (Object)theJobUUID, (Object)theStatus);
        BulkExportJobEntity bulkExportJobEntity = oJob.get();
        bulkExportJobEntity.setStatus(theStatus);
        bulkExportJobEntity.setStatusMessage(theStatusMessage);
        this.myBulkExportJobDao.save(bulkExportJobEntity);
    }
}

