/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.bulk.imprt.job;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.batch.log.Logs;
import ca.uhn.fhir.jpa.bulk.imprt.api.IBulkDataImportSvc;
import ca.uhn.fhir.jpa.bulk.imprt.model.BulkImportJobFileJson;
import ca.uhn.fhir.jpa.bulk.imprt.model.ParsedBulkImportRecord;
import ca.uhn.fhir.util.IoUtil;
import com.google.common.io.LineReader;
import java.io.StringReader;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.springframework.batch.item.ItemReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class BulkImportFileReader
implements ItemReader<ParsedBulkImportRecord> {
    @Autowired
    private IBulkDataImportSvc myBulkDataImportSvc;
    @Autowired
    private FhirContext myFhirContext;
    @Value(value="#{stepExecutionContext['jobUUID']}")
    private String myJobUuid;
    @Value(value="#{stepExecutionContext['fileIndex']}")
    private int myFileIndex;
    private StringReader myReader;
    private LineReader myLineReader;
    private int myLineIndex;
    private String myTenantName;

    public ParsedBulkImportRecord read() throws Exception {
        String nextLine;
        if (this.myReader == null) {
            BulkImportJobFileJson file = this.myBulkDataImportSvc.fetchFile(this.myJobUuid, this.myFileIndex);
            this.myTenantName = file.getTenantName();
            this.myReader = new StringReader(file.getContents());
            this.myLineReader = new LineReader((Readable)this.myReader);
        }
        if ((nextLine = this.myLineReader.readLine()) == null) {
            IoUtil.closeQuietly((AutoCloseable)this.myReader);
            return null;
        }
        Logs.getBatchTroubleshootingLog().debug("Reading line {} file index {} for job: {}", new Object[]{this.myLineIndex++, this.myFileIndex, this.myJobUuid});
        IBaseResource parsed = this.myFhirContext.newJsonParser().parseResource(nextLine);
        return new ParsedBulkImportRecord(this.myTenantName, parsed, this.myLineIndex);
    }
}

