/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.bulk.imprt.job;

import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirSystemDao;
import ca.uhn.fhir.jpa.bulk.imprt.model.JobFileRowProcessingModeEnum;
import ca.uhn.fhir.jpa.bulk.imprt.model.ParsedBulkImportRecord;
import ca.uhn.fhir.jpa.partition.SystemRequestDetails;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.util.StopWatch;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class BulkImportFileWriter
implements ItemWriter<ParsedBulkImportRecord> {
    private static final Logger ourLog = LoggerFactory.getLogger(BulkImportFileWriter.class);
    @Value(value="#{stepExecutionContext['jobUUID']}")
    private String myJobUuid;
    @Value(value="#{stepExecutionContext['fileIndex']}")
    private int myFileIndex;
    @Value(value="#{stepExecutionContext['rowProcessingMode']}")
    private JobFileRowProcessingModeEnum myRowProcessingMode;
    @Autowired
    private DaoRegistry myDaoRegistry;

    public void write(List<? extends ParsedBulkImportRecord> theItemLists) throws Exception {
        String offsets = "unknown";
        if (theItemLists.size() > 0) {
            offsets = theItemLists.get(0).getLineIndex() + " - " + theItemLists.get(theItemLists.size() - 1).getLineIndex();
        }
        ourLog.info("Beginning bulk import write {} rows Job[{}] FileIndex[{}] Offset[{}]", new Object[]{theItemLists.size(), this.myJobUuid, this.myFileIndex, offsets});
        StopWatch sw = new StopWatch();
        for (ParsedBulkImportRecord parsedBulkImportRecord : theItemLists) {
            SystemRequestDetails requestDetails = new SystemRequestDetails();
            requestDetails.setTenantId(parsedBulkImportRecord.getTenantName());
            switch (this.myRowProcessingMode) {
                default: 
            }
            IFhirSystemDao systemDao = this.myDaoRegistry.getSystemDao();
            IBaseResource inputBundle = parsedBulkImportRecord.getRowContent();
            systemDao.transactionNested((RequestDetails)requestDetails, (Object)inputBundle);
        }
        ourLog.info("Completed bulk import write {} rows Job[{}] FileIndex[{}] Offset[{}] in {}", new Object[]{theItemLists.size(), this.myJobUuid, this.myFileIndex, offsets, sw});
    }
}

