/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.bulk.imprt.job;

import ca.uhn.fhir.jpa.bulk.imprt.api.IBulkDataImportSvc;
import ca.uhn.fhir.jpa.bulk.imprt.model.BulkImportJobStatusEnum;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class BulkImportJobCloser
implements Tasklet {
    @Value(value="#{jobParameters['jobUUID']}")
    private String myJobUUID;
    @Autowired
    private IBulkDataImportSvc myBulkDataImportSvc;

    public RepeatStatus execute(StepContribution theStepContribution, ChunkContext theChunkContext) {
        BatchStatus executionStatus = theChunkContext.getStepContext().getStepExecution().getJobExecution().getStatus();
        if (executionStatus == BatchStatus.STARTED) {
            this.myBulkDataImportSvc.setJobToStatus(this.myJobUUID, BulkImportJobStatusEnum.COMPLETE);
            this.myBulkDataImportSvc.deleteJobFiles(this.myJobUUID);
        } else {
            this.myBulkDataImportSvc.setJobToStatus(this.myJobUUID, BulkImportJobStatusEnum.ERROR, "Found job in status: " + executionStatus);
            this.myBulkDataImportSvc.deleteJobFiles(this.myJobUUID);
        }
        return RepeatStatus.FINISHED;
    }
}

