/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.bulk.imprt.job;

import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.bulk.imprt.job.ActivateBulkImportEntityStepListener;
import ca.uhn.fhir.jpa.bulk.imprt.job.BulkImportFileReader;
import ca.uhn.fhir.jpa.bulk.imprt.job.BulkImportFileWriter;
import ca.uhn.fhir.jpa.bulk.imprt.job.BulkImportJobCloser;
import ca.uhn.fhir.jpa.bulk.imprt.job.BulkImportJobParameterValidator;
import ca.uhn.fhir.jpa.bulk.imprt.job.BulkImportPartitioner;
import ca.uhn.fhir.jpa.bulk.imprt.job.BulkImportProcessStepCompletionPolicy;
import ca.uhn.fhir.jpa.bulk.imprt.job.BulkImportStepListener;
import ca.uhn.fhir.jpa.bulk.imprt.job.CreateBulkImportEntityTasklet;
import ca.uhn.fhir.jpa.bulk.imprt.model.ParsedBulkImportRecord;
import javax.batch.api.chunk.listener.RetryProcessListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobParametersValidator;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.JobScope;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.partition.PartitionHandler;
import org.springframework.batch.core.partition.support.Partitioner;
import org.springframework.batch.core.partition.support.TaskExecutorPartitionHandler;
import org.springframework.batch.core.step.builder.AbstractTaskletStepBuilder;
import org.springframework.batch.core.step.builder.PartitionStepBuilder;
import org.springframework.batch.core.step.builder.SimpleStepBuilder;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.repeat.CompletionPolicy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.task.TaskExecutor;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.policy.CompositeRetryPolicy;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.policy.TimeoutRetryPolicy;

@Configuration
public class BulkImportJobConfig {
    public static final String JOB_PARAM_COMMIT_INTERVAL = "commitInterval";
    private static final Logger ourLog = LoggerFactory.getLogger(BulkImportJobConfig.class);
    @Autowired
    private StepBuilderFactory myStepBuilderFactory;
    @Autowired
    private JobBuilderFactory myJobBuilderFactory;
    @Autowired
    @Qualifier(value="jobLaunchingTaskExecutor")
    private TaskExecutor myTaskExecutor;
    @Autowired
    private DaoConfig myDaoConfig;

    @Bean(name={"bulkImportJob"})
    @Lazy
    public Job bulkImportJob() throws Exception {
        return ((JobBuilder)this.myJobBuilderFactory.get("bulkImportJob").validator(this.bulkImportJobParameterValidator())).start(this.bulkImportProcessingStep()).next(this.bulkImportCloseJobStep()).build();
    }

    @Bean
    public JobParametersValidator bulkImportJobParameterValidator() {
        return new BulkImportJobParameterValidator();
    }

    @Bean
    public CreateBulkImportEntityTasklet createBulkImportEntityTasklet() {
        return new CreateBulkImportEntityTasklet();
    }

    @Bean
    @JobScope
    public ActivateBulkImportEntityStepListener activateBulkImportEntityStepListener() {
        return new ActivateBulkImportEntityStepListener();
    }

    @Bean
    public Step bulkImportProcessingStep() throws Exception {
        return ((PartitionStepBuilder)((PartitionStepBuilder)this.myStepBuilderFactory.get("bulkImportProcessingStep").partitioner("bulkImportProcessingStep", (Partitioner)this.bulkImportPartitioner()).partitionHandler(this.partitionHandler()).listener((StepExecutionListener)this.activateBulkImportEntityStepListener())).listener((Object)this.errorLisener())).gridSize(10).build();
    }

    private ChunkAroundListener errorLisener() {
        return new ChunkAroundListener();
    }

    private PartitionHandler partitionHandler() throws Exception {
        assert (this.myTaskExecutor != null);
        TaskExecutorPartitionHandler retVal = new TaskExecutorPartitionHandler();
        retVal.setStep(this.bulkImportProcessFilesStep());
        retVal.setTaskExecutor(this.myTaskExecutor);
        retVal.afterPropertiesSet();
        return retVal;
    }

    @Bean
    public Step bulkImportCloseJobStep() {
        return this.myStepBuilderFactory.get("bulkImportCloseJobStep").tasklet((Tasklet)this.bulkImportJobCloser()).build();
    }

    @Bean
    @JobScope
    public BulkImportJobCloser bulkImportJobCloser() {
        return new BulkImportJobCloser();
    }

    @Bean
    @JobScope
    public BulkImportPartitioner bulkImportPartitioner() {
        return new BulkImportPartitioner();
    }

    @Bean
    public Step bulkImportProcessFilesStep() {
        return ((SimpleStepBuilder)((AbstractTaskletStepBuilder)this.myStepBuilderFactory.get("bulkImportProcessFilesStep").chunk(this.completionPolicy()).reader((ItemReader)this.bulkImportFileReader()).writer(this.bulkImportFileWriter()).listener((StepExecutionListener)this.bulkImportStepListener())).listener((Object)this.completionPolicy())).faultTolerant().retryPolicy(this.bulkImportProcessFilesStepRetryPolicy()).build();
    }

    private RetryPolicy bulkImportProcessFilesStepRetryPolicy() {
        TimeoutRetryPolicy timeoutPolicy = new TimeoutRetryPolicy();
        timeoutPolicy.setTimeout(10000L);
        SimpleRetryPolicy countRetryPolicy = new SimpleRetryPolicy(this.myDaoConfig.getBulkImportMaxRetryCount());
        CompositeRetryPolicy compositeRetryPolicy = new CompositeRetryPolicy();
        compositeRetryPolicy.setPolicies(new RetryPolicy[]{timeoutPolicy, countRetryPolicy});
        return compositeRetryPolicy;
    }

    @Bean
    @StepScope
    public CompletionPolicy completionPolicy() {
        return new BulkImportProcessStepCompletionPolicy();
    }

    @Bean
    @StepScope
    public ItemWriter<ParsedBulkImportRecord> bulkImportFileWriter() {
        return new BulkImportFileWriter();
    }

    @Bean
    @StepScope
    public BulkImportFileReader bulkImportFileReader() {
        return new BulkImportFileReader();
    }

    @Bean
    @StepScope
    public BulkImportStepListener bulkImportStepListener() {
        return new BulkImportStepListener();
    }

    public static class ChunkAroundListener
    implements RetryProcessListener {
        public void onRetryProcessException(Object item, Exception ex) throws Exception {
            throw ex;
        }
    }
}

