/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.bulk.imprt.job;

import ca.uhn.fhir.jpa.dao.data.IBulkImportJobDao;
import ca.uhn.fhir.jpa.entity.BulkImportJobEntity;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.JobParametersValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class BulkImportJobParameterValidator
implements JobParametersValidator {
    @Autowired
    private IBulkImportJobDao myBulkImportJobDao;
    @Autowired
    private PlatformTransactionManager myTransactionManager;

    public void validate(JobParameters theJobParameters) throws JobParametersInvalidException {
        if (theJobParameters == null) {
            throw new JobParametersInvalidException("This job needs Parameters: [jobUUID]");
        }
        TransactionTemplate txTemplate = new TransactionTemplate(this.myTransactionManager);
        String errorMessage = (String)txTemplate.execute(tx -> {
            StringBuilder errorBuilder = new StringBuilder();
            String jobUUID = theJobParameters.getString("jobUUID");
            Optional<BulkImportJobEntity> oJob = this.myBulkImportJobDao.findByJobId(jobUUID);
            if (!StringUtils.isBlank((CharSequence)jobUUID) && !oJob.isPresent()) {
                errorBuilder.append("There is no persisted job that exists with UUID: ");
                errorBuilder.append(jobUUID);
                errorBuilder.append(". ");
            }
            return errorBuilder.toString();
        });
        if (!StringUtils.isEmpty((CharSequence)errorMessage)) {
            throw new JobParametersInvalidException(errorMessage);
        }
    }
}

