/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.cache;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.cache.IResourceVersionSvc;
import ca.uhn.fhir.jpa.cache.ResourceVersionMap;
import ca.uhn.fhir.jpa.dao.data.IResourceTableDao;
import ca.uhn.fhir.jpa.partition.SystemRequestDetails;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.util.QueryChunker;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ResourceVersionSvcDaoImpl
implements IResourceVersionSvc {
    private static final Logger ourLog = LoggerFactory.getLogger(ResourceVersionSvcDaoImpl.class);
    @Autowired
    DaoRegistry myDaoRegistry;
    @Autowired
    IResourceTableDao myResourceTableDao;

    @Nonnull
    public ResourceVersionMap getVersionMap(String theResourceName, SearchParameterMap theSearchParamMap) {
        IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(theResourceName);
        if (ourLog.isDebugEnabled()) {
            ourLog.debug("About to retrieve version map for resource type: {}", (Object)theResourceName);
        }
        List matchingIds = dao.searchForIds(theSearchParamMap, (RequestDetails)new SystemRequestDetails().setRequestPartitionId(RequestPartitionId.allPartitions())).stream().map(ResourcePersistentId::getIdAsLong).collect(Collectors.toList());
        ArrayList allById = new ArrayList();
        new QueryChunker().chunk(matchingIds, t -> {
            List nextBatch = this.myResourceTableDao.findAllById((Iterable)t);
            allById.addAll(nextBatch);
        });
        return ResourceVersionMap.fromResourceTableEntities(allById);
    }
}

