/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.config;

import ca.uhn.fhir.context.support.DefaultProfileValidationSupport;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.jpa.config.BaseConfig;
import ca.uhn.fhir.jpa.dao.JpaPersistedResourceValidationSupport;
import ca.uhn.fhir.jpa.dao.ObservationLastNIndexPersistSvc;
import ca.uhn.fhir.jpa.term.TermCodeSystemStorageSvcImpl;
import ca.uhn.fhir.jpa.term.TermDeferredStorageSvcImpl;
import ca.uhn.fhir.jpa.term.TermReindexingSvcImpl;
import ca.uhn.fhir.jpa.term.api.ITermCodeSystemStorageSvc;
import ca.uhn.fhir.jpa.term.api.ITermDeferredStorageSvc;
import ca.uhn.fhir.jpa.term.api.ITermReadSvc;
import ca.uhn.fhir.jpa.term.api.ITermReindexingSvc;
import ca.uhn.fhir.jpa.term.api.ITermVersionAdapterSvc;
import ca.uhn.fhir.jpa.validation.JpaValidationSupportChain;
import ca.uhn.fhir.jpa.validation.ValidatorResourceFetcher;
import ca.uhn.fhir.validation.IInstanceValidatorModule;
import org.hl7.fhir.common.hapi.validation.support.CachingValidationSupport;
import org.hl7.fhir.common.hapi.validation.validator.FhirInstanceValidator;
import org.hl7.fhir.r5.utils.IResourceValidator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;

@Configuration
public abstract class BaseConfigDstu3Plus
extends BaseConfig {
    @Bean
    public ITermCodeSystemStorageSvc termCodeSystemStorageSvc() {
        return new TermCodeSystemStorageSvcImpl();
    }

    @Bean
    public ITermDeferredStorageSvc termDeferredStorageSvc() {
        return new TermDeferredStorageSvcImpl();
    }

    @Bean
    public ITermReindexingSvc termReindexingSvc() {
        return new TermReindexingSvcImpl();
    }

    @Bean
    public abstract ITermVersionAdapterSvc terminologyVersionAdapterSvc();

    @Bean(name={"myDefaultProfileValidationSupport"})
    public DefaultProfileValidationSupport defaultProfileValidationSupport() {
        return new DefaultProfileValidationSupport(this.fhirContext());
    }

    @Bean(name={"myJpaValidationSupportChain"})
    public JpaValidationSupportChain jpaValidationSupportChain() {
        return new JpaValidationSupportChain(this.fhirContext());
    }

    @Bean(name={"myJpaValidationSupport"})
    public IValidationSupport jpaValidationSupport() {
        return new JpaPersistedResourceValidationSupport(this.fhirContext());
    }

    @Primary
    @Bean
    public IValidationSupport validationSupportChain() {
        CachingValidationSupport.CacheTimeouts cacheTimeouts = CachingValidationSupport.CacheTimeouts.defaultValues().setTranslateCodeMillis(1000L);
        return new CachingValidationSupport((IValidationSupport)this.jpaValidationSupportChain(), cacheTimeouts);
    }

    @Bean(name={"myInstanceValidator"})
    @Lazy
    public IInstanceValidatorModule instanceValidator() {
        FhirInstanceValidator val = new FhirInstanceValidator(this.validationSupportChain());
        val.setValidatorResourceFetcher((IResourceValidator.IValidatorResourceFetcher)this.jpaValidatorResourceFetcher());
        val.setBestPracticeWarningLevel(IResourceValidator.BestPracticeWarningLevel.Warning);
        val.setValidationSupport(this.validationSupportChain());
        return val;
    }

    @Bean
    @Lazy
    public ValidatorResourceFetcher jpaValidatorResourceFetcher() {
        return new ValidatorResourceFetcher();
    }

    @Bean
    public abstract ITermReadSvc terminologyService();

    @Bean
    public ObservationLastNIndexPersistSvc baseObservationLastNIndexpersistSvc() {
        return new ObservationLastNIndexPersistSvc();
    }
}

