/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.config;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.DefaultProfileValidationSupport;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.jpa.api.dao.IFhirSystemDao;
import ca.uhn.fhir.jpa.config.BaseConfig;
import ca.uhn.fhir.jpa.dao.BaseTransactionProcessor;
import ca.uhn.fhir.jpa.dao.FhirSystemDaoDstu2;
import ca.uhn.fhir.jpa.dao.FulltextSearchSvcImpl;
import ca.uhn.fhir.jpa.dao.IFulltextSearchSvc;
import ca.uhn.fhir.jpa.dao.JpaPersistedResourceValidationSupport;
import ca.uhn.fhir.jpa.dao.TransactionProcessorVersionAdapterDstu2;
import ca.uhn.fhir.jpa.provider.JpaSystemProviderDstu2;
import ca.uhn.fhir.jpa.term.TermReadSvcDstu2;
import ca.uhn.fhir.jpa.term.api.ITermReadSvc;
import ca.uhn.fhir.jpa.util.ResourceCountCache;
import ca.uhn.fhir.model.dstu2.composite.MetaDt;
import ca.uhn.fhir.model.dstu2.resource.Bundle;
import ca.uhn.fhir.validation.IInstanceValidatorModule;
import org.hl7.fhir.common.hapi.validation.support.CachingValidationSupport;
import org.hl7.fhir.common.hapi.validation.support.CommonCodeSystemsTerminologyService;
import org.hl7.fhir.common.hapi.validation.support.InMemoryTerminologyServerValidationSupport;
import org.hl7.fhir.common.hapi.validation.support.ValidationSupportChain;
import org.hl7.fhir.common.hapi.validation.validator.FhirInstanceValidator;
import org.hl7.fhir.common.hapi.validation.validator.HapiToHl7OrgDstu2ValidatingSupportWrapper;
import org.hl7.fhir.r5.utils.IResourceValidator;
import org.springframework.beans.factory.annotation.Autowire;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
public class BaseDstu2Config
extends BaseConfig {
    private static FhirContext ourFhirContextDstu2;
    private static FhirContext ourFhirContextDstu2Hl7Org;

    @Bean
    @Primary
    public FhirContext defaultFhirContext() {
        return this.fhirContextDstu2();
    }

    @Override
    public FhirContext fhirContext() {
        return this.fhirContextDstu2();
    }

    @Bean(name={"myFhirContextDstu2"})
    @Lazy
    public FhirContext fhirContextDstu2() {
        if (ourFhirContextDstu2 == null) {
            ourFhirContextDstu2 = FhirContext.forDstu2();
        }
        return ourFhirContextDstu2;
    }

    @Bean(name={"myFhirContextDstu2Hl7Org"})
    @Lazy
    public FhirContext fhirContextDstu2Hl7Org() {
        if (ourFhirContextDstu2Hl7Org == null) {
            ourFhirContextDstu2Hl7Org = FhirContext.forDstu2Hl7Org();
        }
        return ourFhirContextDstu2Hl7Org;
    }

    @Bean(name={"myInstanceValidator"})
    @Lazy
    public IInstanceValidatorModule instanceValidator(ValidationSupportChain theValidationSupportChain) {
        CachingValidationSupport cachingValidationSupport = new CachingValidationSupport((IValidationSupport)new HapiToHl7OrgDstu2ValidatingSupportWrapper((IValidationSupport)theValidationSupportChain));
        FhirInstanceValidator retVal = new FhirInstanceValidator((IValidationSupport)cachingValidationSupport);
        retVal.setBestPracticeWarningLevel(IResourceValidator.BestPracticeWarningLevel.Warning);
        return retVal;
    }

    @Bean
    public BaseTransactionProcessor.ITransactionProcessorVersionAdapter transactionProcessorVersionFacade() {
        return new TransactionProcessorVersionAdapterDstu2();
    }

    @Bean(name={"myDefaultProfileValidationSupport"})
    public DefaultProfileValidationSupport defaultProfileValidationSupport() {
        return new DefaultProfileValidationSupport(this.fhirContext());
    }

    @Bean(name={"myJpaValidationSupportChain"})
    public ValidationSupportChain validationSupportChain(DefaultProfileValidationSupport theDefaultProfileValidationSupport) {
        InMemoryTerminologyServerValidationSupport inMemoryTerminologyServer = new InMemoryTerminologyServerValidationSupport(this.fhirContextDstu2());
        IValidationSupport jpaValidationSupport = this.jpaValidationSupportDstu2();
        CommonCodeSystemsTerminologyService commonCodeSystemsTermSvc = new CommonCodeSystemsTerminologyService(this.fhirContext());
        return new ValidationSupportChain(new IValidationSupport[]{theDefaultProfileValidationSupport, jpaValidationSupport, inMemoryTerminologyServer, commonCodeSystemsTermSvc});
    }

    @Primary
    @Bean(name={"myJpaValidationSupport"})
    public IValidationSupport jpaValidationSupportDstu2() {
        return new JpaPersistedResourceValidationSupport(this.fhirContextDstu2());
    }

    @Bean(name={"myResourceCountsCache"})
    public ResourceCountCache resourceCountsCache() {
        ResourceCountCache retVal = new ResourceCountCache(() -> this.systemDaoDstu2().getResourceCounts());
        retVal.setCacheMillis(14400000L);
        return retVal;
    }

    @Bean(autowire=Autowire.BY_TYPE)
    public IFulltextSearchSvc searchDao() {
        FulltextSearchSvcImpl searchDao = new FulltextSearchSvcImpl();
        return searchDao;
    }

    @Bean(name={"mySystemDaoDstu2"}, autowire=Autowire.BY_NAME)
    public IFhirSystemDao<Bundle, MetaDt> systemDaoDstu2() {
        FhirSystemDaoDstu2 retVal = new FhirSystemDaoDstu2();
        return retVal;
    }

    @Bean(name={"mySystemProviderDstu2"})
    public JpaSystemProviderDstu2 systemProviderDstu2() {
        JpaSystemProviderDstu2 retVal = new JpaSystemProviderDstu2();
        retVal.setDao(this.systemDaoDstu2());
        retVal.setContext(this.fhirContextDstu2());
        return retVal;
    }

    @Bean(autowire=Autowire.BY_TYPE)
    public ITermReadSvc terminologyService() {
        return new TermReadSvcDstu2();
    }
}

