/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.config;

import ca.uhn.fhir.i18n.HapiLocalizer;
import ca.uhn.fhir.rest.server.exceptions.ResourceVersionConflictException;
import javax.persistence.PersistenceException;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.HibernateException;
import org.hibernate.PessimisticLockException;
import org.hibernate.StaleStateException;
import org.hibernate.exception.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.jpa.vendor.HibernateJpaDialect;

public class HapiFhirHibernateJpaDialect
extends HibernateJpaDialect {
    private static final Logger ourLog = LoggerFactory.getLogger(HapiFhirHibernateJpaDialect.class);
    private HapiLocalizer myLocalizer;

    public HapiFhirHibernateJpaDialect(HapiLocalizer theLocalizer) {
        this.myLocalizer = theLocalizer;
    }

    public RuntimeException translate(PersistenceException theException, String theMessageToPrepend) {
        if (theException.getCause() instanceof HibernateException) {
            return new PersistenceException((Throwable)this.convertHibernateAccessException((HibernateException)theException.getCause(), theMessageToPrepend));
        }
        return theException;
    }

    protected DataAccessException convertHibernateAccessException(HibernateException theException) {
        return this.convertHibernateAccessException(theException, null);
    }

    private DataAccessException convertHibernateAccessException(HibernateException theException, String theMessageToPrepend) {
        PessimisticLockException ex;
        String sql;
        String constraintName;
        String messageToPrepend = "";
        if (StringUtils.isNotBlank((CharSequence)theMessageToPrepend)) {
            messageToPrepend = theMessageToPrepend + " - ";
        }
        if (theException instanceof ConstraintViolationException && StringUtils.isNotBlank((CharSequence)(constraintName = ((ConstraintViolationException)theException).getConstraintName()))) {
            if ((constraintName = constraintName.toUpperCase()).contains("IDX_RESVER_ID_VER")) {
                throw new ResourceVersionConflictException(messageToPrepend + this.myLocalizer.getMessage(HapiFhirHibernateJpaDialect.class, "resourceVersionConstraintFailure", new Object[0]));
            }
            if (constraintName.contains("IDX_IDXCMPSTRUNIQ_STRING")) {
                throw new ResourceVersionConflictException(messageToPrepend + this.myLocalizer.getMessage(HapiFhirHibernateJpaDialect.class, "resourceIndexedCompositeStringUniqueConstraintFailure", new Object[0]));
            }
            if (constraintName.contains("IDX_FORCEDID_TYPE_FID")) {
                throw new ResourceVersionConflictException(messageToPrepend + this.myLocalizer.getMessage(HapiFhirHibernateJpaDialect.class, "forcedIdConstraintFailure", new Object[0]));
            }
        }
        if (theException instanceof StaleStateException) {
            String msg = messageToPrepend + this.myLocalizer.getMessage(HapiFhirHibernateJpaDialect.class, "resourceVersionConstraintFailure", new Object[0]);
            throw new ResourceVersionConflictException(msg);
        }
        if (theException instanceof PessimisticLockException && (sql = StringUtils.defaultString((String)(ex = (PessimisticLockException)theException).getSQL()).toUpperCase()).contains("HFJ_RES_VER")) {
            String msg = messageToPrepend + this.myLocalizer.getMessage(HapiFhirHibernateJpaDialect.class, "resourceVersionConstraintFailure", new Object[0]);
            throw new ResourceVersionConflictException(msg);
        }
        DataAccessException retVal = super.convertHibernateAccessException(theException);
        return retVal;
    }
}

