/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.config.dstu3;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.ParserOptions;
import ca.uhn.fhir.jpa.api.dao.IFhirSystemDao;
import ca.uhn.fhir.jpa.config.BaseConfigDstu3Plus;
import ca.uhn.fhir.jpa.dao.BaseTransactionProcessor;
import ca.uhn.fhir.jpa.dao.FulltextSearchSvcImpl;
import ca.uhn.fhir.jpa.dao.IFulltextSearchSvc;
import ca.uhn.fhir.jpa.dao.dstu3.FhirSystemDaoDstu3;
import ca.uhn.fhir.jpa.dao.dstu3.TransactionProcessorVersionAdapterDstu3;
import ca.uhn.fhir.jpa.provider.GraphQLProvider;
import ca.uhn.fhir.jpa.provider.dstu3.JpaSystemProviderDstu3;
import ca.uhn.fhir.jpa.term.TermLoaderSvcImpl;
import ca.uhn.fhir.jpa.term.TermReadSvcDstu3;
import ca.uhn.fhir.jpa.term.TermVersionAdapterSvcDstu3;
import ca.uhn.fhir.jpa.term.api.ITermCodeSystemStorageSvc;
import ca.uhn.fhir.jpa.term.api.ITermDeferredStorageSvc;
import ca.uhn.fhir.jpa.term.api.ITermLoaderSvc;
import ca.uhn.fhir.jpa.term.api.ITermReadSvcDstu3;
import ca.uhn.fhir.jpa.term.api.ITermVersionAdapterSvc;
import ca.uhn.fhir.jpa.util.ResourceCountCache;
import org.hl7.fhir.dstu3.model.Bundle;
import org.hl7.fhir.dstu3.model.Meta;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
public class BaseDstu3Config
extends BaseConfigDstu3Plus {
    public static FhirContext ourFhirContext = FhirContext.forDstu3();

    @Override
    public FhirContext fhirContext() {
        return this.fhirContextDstu3();
    }

    @Override
    @Bean
    public ITermVersionAdapterSvc terminologyVersionAdapterSvc() {
        return new TermVersionAdapterSvcDstu3();
    }

    @Bean
    @Primary
    public FhirContext fhirContextDstu3() {
        FhirContext retVal = ourFhirContext;
        ParserOptions parserOptions = retVal.getParserOptions();
        parserOptions.setDontStripVersionsFromReferencesAtPaths(new String[]{"AuditEvent.entity.reference"});
        return retVal;
    }

    @Bean(name={"myGraphQLProvider"})
    @Lazy
    public GraphQLProvider graphQLProvider() {
        return new GraphQLProvider(this.fhirContextDstu3(), this.validationSupportChain(), this.graphqlStorageServices());
    }

    @Bean
    public BaseTransactionProcessor.ITransactionProcessorVersionAdapter transactionProcessorVersionFacade() {
        return new TransactionProcessorVersionAdapterDstu3();
    }

    @Bean(name={"myResourceCountsCache"})
    public ResourceCountCache resourceCountsCache() {
        ResourceCountCache retVal = new ResourceCountCache(() -> this.systemDaoDstu3().getResourceCounts());
        retVal.setCacheMillis(14400000L);
        return retVal;
    }

    @Bean
    public IFulltextSearchSvc searchDaoDstu3() {
        return new FulltextSearchSvcImpl();
    }

    @Bean(name={"mySystemDaoDstu3"})
    public IFhirSystemDao<Bundle, Meta> systemDaoDstu3() {
        return new FhirSystemDaoDstu3();
    }

    @Bean(name={"mySystemProviderDstu3"})
    public JpaSystemProviderDstu3 systemProviderDstu3() {
        JpaSystemProviderDstu3 retVal = new JpaSystemProviderDstu3();
        retVal.setContext(this.fhirContextDstu3());
        retVal.setDao(this.systemDaoDstu3());
        return retVal;
    }

    @Bean
    public ITermLoaderSvc termLoaderService(ITermDeferredStorageSvc theDeferredStorageSvc, ITermCodeSystemStorageSvc theCodeSystemStorageSvc) {
        return new TermLoaderSvcImpl(theDeferredStorageSvc, theCodeSystemStorageSvc);
    }

    @Override
    @Bean
    public ITermReadSvcDstu3 terminologyService() {
        return new TermReadSvcDstu3();
    }
}

