/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.config.r4;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.ParserOptions;
import ca.uhn.fhir.jpa.api.dao.IFhirSystemDao;
import ca.uhn.fhir.jpa.config.BaseConfigDstu3Plus;
import ca.uhn.fhir.jpa.dao.BaseTransactionProcessor;
import ca.uhn.fhir.jpa.dao.FulltextSearchSvcImpl;
import ca.uhn.fhir.jpa.dao.IFulltextSearchSvc;
import ca.uhn.fhir.jpa.dao.r4.FhirSystemDaoR4;
import ca.uhn.fhir.jpa.dao.r4.TransactionProcessorVersionAdapterR4;
import ca.uhn.fhir.jpa.provider.GraphQLProvider;
import ca.uhn.fhir.jpa.provider.r4.JpaSystemProviderR4;
import ca.uhn.fhir.jpa.term.TermLoaderSvcImpl;
import ca.uhn.fhir.jpa.term.TermReadSvcR4;
import ca.uhn.fhir.jpa.term.TermVersionAdapterSvcR4;
import ca.uhn.fhir.jpa.term.api.ITermCodeSystemStorageSvc;
import ca.uhn.fhir.jpa.term.api.ITermDeferredStorageSvc;
import ca.uhn.fhir.jpa.term.api.ITermLoaderSvc;
import ca.uhn.fhir.jpa.term.api.ITermReadSvcR4;
import ca.uhn.fhir.jpa.term.api.ITermVersionAdapterSvc;
import ca.uhn.fhir.jpa.util.ResourceCountCache;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Meta;
import org.springframework.beans.factory.annotation.Autowire;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
public class BaseR4Config
extends BaseConfigDstu3Plus {
    public static FhirContext ourFhirContext = FhirContext.forR4();

    @Override
    public FhirContext fhirContext() {
        return this.fhirContextR4();
    }

    @Override
    @Bean
    public ITermVersionAdapterSvc terminologyVersionAdapterSvc() {
        return new TermVersionAdapterSvcR4();
    }

    @Bean
    @Primary
    public FhirContext fhirContextR4() {
        FhirContext retVal = ourFhirContext;
        ParserOptions parserOptions = retVal.getParserOptions();
        parserOptions.setDontStripVersionsFromReferencesAtPaths(new String[]{"AuditEvent.entity.what"});
        return retVal;
    }

    @Bean
    public BaseTransactionProcessor.ITransactionProcessorVersionAdapter transactionProcessorVersionFacade() {
        return new TransactionProcessorVersionAdapterR4();
    }

    @Bean(name={"myGraphQLProvider"})
    @Lazy
    public GraphQLProvider graphQLProvider() {
        return new GraphQLProvider(this.fhirContextR4(), this.validationSupportChain(), this.graphqlStorageServices());
    }

    @Bean(name={"myResourceCountsCache"})
    public ResourceCountCache resourceCountsCache() {
        ResourceCountCache retVal = new ResourceCountCache(() -> this.systemDaoR4().getResourceCounts());
        retVal.setCacheMillis(14400000L);
        return retVal;
    }

    @Bean(autowire=Autowire.BY_TYPE)
    public IFulltextSearchSvc searchDaoR4() {
        FulltextSearchSvcImpl searchDao = new FulltextSearchSvcImpl();
        return searchDao;
    }

    @Bean(name={"mySystemDaoR4"}, autowire=Autowire.BY_NAME)
    public IFhirSystemDao<Bundle, Meta> systemDaoR4() {
        FhirSystemDaoR4 retVal = new FhirSystemDaoR4();
        return retVal;
    }

    @Bean(name={"mySystemProviderR4"})
    public JpaSystemProviderR4 systemProviderR4() {
        JpaSystemProviderR4 retVal = new JpaSystemProviderR4();
        retVal.setContext(this.fhirContextR4());
        retVal.setDao(this.systemDaoR4());
        return retVal;
    }

    @Bean
    public ITermLoaderSvc termLoaderService(ITermDeferredStorageSvc theDeferredStorageSvc, ITermCodeSystemStorageSvc theCodeSystemStorageSvc) {
        return new TermLoaderSvcImpl(theDeferredStorageSvc, theCodeSystemStorageSvc);
    }

    @Override
    @Bean(autowire=Autowire.BY_TYPE)
    public ITermReadSvcR4 terminologyService() {
        return new TermReadSvcR4();
    }
}

