/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.config.r5;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.ParserOptions;
import ca.uhn.fhir.jpa.api.dao.IFhirSystemDao;
import ca.uhn.fhir.jpa.config.BaseConfigDstu3Plus;
import ca.uhn.fhir.jpa.dao.BaseTransactionProcessor;
import ca.uhn.fhir.jpa.dao.FulltextSearchSvcImpl;
import ca.uhn.fhir.jpa.dao.IFulltextSearchSvc;
import ca.uhn.fhir.jpa.dao.r5.FhirSystemDaoR5;
import ca.uhn.fhir.jpa.dao.r5.TransactionProcessorVersionAdapterR5;
import ca.uhn.fhir.jpa.provider.GraphQLProvider;
import ca.uhn.fhir.jpa.provider.r5.JpaSystemProviderR5;
import ca.uhn.fhir.jpa.term.TermLoaderSvcImpl;
import ca.uhn.fhir.jpa.term.TermReadSvcR5;
import ca.uhn.fhir.jpa.term.TermVersionAdapterSvcR5;
import ca.uhn.fhir.jpa.term.api.ITermCodeSystemStorageSvc;
import ca.uhn.fhir.jpa.term.api.ITermDeferredStorageSvc;
import ca.uhn.fhir.jpa.term.api.ITermLoaderSvc;
import ca.uhn.fhir.jpa.term.api.ITermReadSvcR5;
import ca.uhn.fhir.jpa.term.api.ITermVersionAdapterSvc;
import ca.uhn.fhir.jpa.util.ResourceCountCache;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.Meta;
import org.springframework.beans.factory.annotation.Autowire;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
public class BaseR5Config
extends BaseConfigDstu3Plus {
    @Override
    public FhirContext fhirContext() {
        return this.fhirContextR5();
    }

    @Override
    @Bean
    public ITermVersionAdapterSvc terminologyVersionAdapterSvc() {
        return new TermVersionAdapterSvcR5();
    }

    @Bean
    @Primary
    public FhirContext fhirContextR5() {
        FhirContext retVal = FhirContext.forR5();
        ParserOptions parserOptions = retVal.getParserOptions();
        parserOptions.setDontStripVersionsFromReferencesAtPaths(new String[]{"AuditEvent.entity.what"});
        return retVal;
    }

    @Bean
    public BaseTransactionProcessor.ITransactionProcessorVersionAdapter transactionProcessorVersionFacade() {
        return new TransactionProcessorVersionAdapterR5();
    }

    @Bean(name={"myGraphQLProvider"})
    @Lazy
    public GraphQLProvider graphQLProvider() {
        return new GraphQLProvider(this.fhirContextR5(), this.validationSupportChain(), this.graphqlStorageServices());
    }

    @Bean(name={"myResourceCountsCache"})
    public ResourceCountCache resourceCountsCache() {
        ResourceCountCache retVal = new ResourceCountCache(() -> this.systemDaoR5().getResourceCounts());
        retVal.setCacheMillis(14400000L);
        return retVal;
    }

    @Bean(autowire=Autowire.BY_TYPE)
    public IFulltextSearchSvc searchDaoR5() {
        FulltextSearchSvcImpl searchDao = new FulltextSearchSvcImpl();
        return searchDao;
    }

    @Bean(name={"mySystemDaoR5"}, autowire=Autowire.BY_NAME)
    public IFhirSystemDao<Bundle, Meta> systemDaoR5() {
        FhirSystemDaoR5 retVal = new FhirSystemDaoR5();
        return retVal;
    }

    @Bean(name={"mySystemProviderR5"})
    public JpaSystemProviderR5 systemProviderR5() {
        JpaSystemProviderR5 retVal = new JpaSystemProviderR5();
        retVal.setContext(this.fhirContextR5());
        retVal.setDao(this.systemDaoR5());
        return retVal;
    }

    @Bean
    public ITermLoaderSvc terminologyLoaderService(ITermDeferredStorageSvc theDeferredStorageSvc, ITermCodeSystemStorageSvc theCodeSystemStorageSvc) {
        return new TermLoaderSvcImpl(theDeferredStorageSvc, theCodeSystemStorageSvc);
    }

    @Override
    @Bean(autowire=Autowire.BY_TYPE)
    public ITermReadSvcR5 terminologyService() {
        return new TermReadSvcR5();
    }
}

