/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao;

import ca.uhn.fhir.jpa.api.dao.IFhirSystemDao;
import ca.uhn.fhir.jpa.api.model.ExpungeOptions;
import ca.uhn.fhir.jpa.api.model.ExpungeOutcome;
import ca.uhn.fhir.jpa.dao.BaseHapiFhirDao;
import ca.uhn.fhir.jpa.dao.TransactionProcessor;
import ca.uhn.fhir.jpa.util.ResourceCountCache;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.interceptor.IServerInterceptor;
import ca.uhn.fhir.util.StopWatch;
import com.google.common.annotations.VisibleForTesting;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public abstract class BaseHapiFhirSystemDao<T extends IBaseBundle, MT>
extends BaseHapiFhirDao<IBaseResource>
implements IFhirSystemDao<T, MT> {
    private static final Logger ourLog = LoggerFactory.getLogger(BaseHapiFhirSystemDao.class);
    @Autowired
    @Qualifier(value="myResourceCountsCache")
    public ResourceCountCache myResourceCountsCache;
    @Autowired
    private TransactionProcessor myTransactionProcessor;

    @VisibleForTesting
    public void setTransactionProcessorForUnitTest(TransactionProcessor theTransactionProcessor) {
        this.myTransactionProcessor = theTransactionProcessor;
    }

    @Override
    @PostConstruct
    public void start() {
        super.start();
        this.myTransactionProcessor.setDao(this);
    }

    @Transactional(propagation=Propagation.NEVER)
    public ExpungeOutcome expunge(ExpungeOptions theExpungeOptions, RequestDetails theRequestDetails) {
        return this.myExpungeService.expunge(null, null, null, theExpungeOptions, theRequestDetails);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public Map<String, Long> getResourceCounts() {
        HashMap<String, Long> retVal = new HashMap<String, Long>();
        List<Map<?, ?>> counts = this.myResourceTableDao.getResourceCounts();
        for (Map<?, ?> next : counts) {
            retVal.put(next.get("type").toString(), Long.parseLong(next.get("count").toString()));
        }
        return retVal;
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    @Nullable
    public Map<String, Long> getResourceCountsFromCache() {
        return this.myResourceCountsCache.get();
    }

    public IBundleProvider history(Date theSince, Date theUntil, Integer theOffset, RequestDetails theRequestDetails) {
        if (theRequestDetails != null) {
            IServerInterceptor.ActionRequestDetails requestDetails = new IServerInterceptor.ActionRequestDetails(theRequestDetails);
            this.notifyInterceptors(RestOperationTypeEnum.HISTORY_SYSTEM, requestDetails);
        }
        StopWatch w = new StopWatch();
        IBundleProvider retVal = super.history(theRequestDetails, null, null, theSince, theUntil, theOffset);
        ourLog.info("Processed global history in {}ms", (Object)w.getMillisAndRestart());
        return retVal;
    }

    @Transactional(propagation=Propagation.NEVER)
    public T transaction(RequestDetails theRequestDetails, T theRequest) {
        return this.myTransactionProcessor.transaction(theRequestDetails, theRequest, false);
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public T transactionNested(RequestDetails theRequestDetails, T theRequest) {
        return this.myTransactionProcessor.transaction(theRequestDetails, theRequest, true);
    }

    @Override
    @Nullable
    protected String getResourceName() {
        return null;
    }
}

