/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.model.DaoMethodOutcome;
import ca.uhn.fhir.jpa.api.model.LazyDaoMethodOutcome;
import ca.uhn.fhir.jpa.dao.BaseHapiFhirResourceDao;
import ca.uhn.fhir.jpa.model.cross.IBasePersistedResource;
import ca.uhn.fhir.jpa.model.entity.ModelConfig;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.searchparam.util.JpaParamUtil;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.rest.api.QualifiedParamList;
import ca.uhn.fhir.rest.api.server.IPreResourceAccessDetails;
import ca.uhn.fhir.rest.api.server.IPreResourceShowDetails;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SimplePreResourceAccessDetails;
import ca.uhn.fhir.rest.api.server.SimplePreResourceShowDetails;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import ca.uhn.fhir.rest.param.QualifierDetails;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.ResourceGoneException;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.util.CompositeInterceptorBroadcaster;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import ca.uhn.fhir.util.BundleUtil;
import ca.uhn.fhir.util.FhirTerser;
import ca.uhn.fhir.util.OperationOutcomeUtil;
import ca.uhn.fhir.util.ResourceReferenceInfo;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.InstantType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public abstract class BaseStorageDao {
    @Autowired
    protected ISearchParamRegistry mySearchParamRegistry;
    @Autowired
    protected FhirContext myFhirContext;
    @Autowired
    protected DaoRegistry myDaoRegistry;
    @Autowired
    protected ModelConfig myModelConfig;

    @VisibleForTesting
    public void setSearchParamRegistry(ISearchParamRegistry theSearchParamRegistry) {
        this.mySearchParamRegistry = theSearchParamRegistry;
    }

    protected void preProcessResourceForStorage(IBaseResource theResource) {
    }

    protected void preProcessResourceForStorage(IBaseResource theResource, RequestDetails theRequestDetails, TransactionDetails theTransactionDetails, boolean thePerformIndexing) {
        this.verifyResourceTypeIsAppropriateForDao(theResource);
        this.verifyResourceIdIsValid(theResource);
        this.verifyBundleTypeIsAppropriateForStorage(theResource);
        this.replaceAbsoluteReferencesWithRelative(theResource);
        this.performAutoVersioning(theResource, thePerformIndexing);
    }

    private void verifyResourceTypeIsAppropriateForDao(IBaseResource theResource) {
        String type = this.getContext().getResourceType(theResource);
        if (this.getResourceName() != null && !this.getResourceName().equals(type)) {
            throw new InvalidRequestException(this.getContext().getLocalizer().getMessageSanitized(BaseHapiFhirResourceDao.class, "incorrectResourceType", new Object[]{type, this.getResourceName()}));
        }
    }

    private void verifyResourceIdIsValid(IBaseResource theResource) {
        if (theResource.getIdElement().hasIdPart() && !theResource.getIdElement().isIdPartValid()) {
            throw new InvalidRequestException(this.getContext().getLocalizer().getMessageSanitized(BaseHapiFhirResourceDao.class, "failedToCreateWithInvalidId", new Object[]{theResource.getIdElement().getIdPart()}));
        }
    }

    private void verifyBundleTypeIsAppropriateForStorage(IBaseResource theResource) {
        if (theResource instanceof IBaseBundle) {
            Set allowedBundleTypes = this.getConfig().getBundleTypesAllowedForStorage();
            String bundleType = BundleUtil.getBundleType((FhirContext)this.getContext(), (IBaseBundle)((IBaseBundle)theResource));
            if (!allowedBundleTypes.contains(bundleType = StringUtils.defaultString((String)bundleType))) {
                String message = this.myFhirContext.getLocalizer().getMessage(BaseStorageDao.class, "invalidBundleTypeForStorage", new Object[]{StringUtils.isNotBlank((CharSequence)bundleType) ? bundleType : "(missing)"});
                throw new UnprocessableEntityException(message);
            }
        }
    }

    private void replaceAbsoluteReferencesWithRelative(IBaseResource theResource) {
        if (!this.getConfig().getTreatBaseUrlsAsLocal().isEmpty()) {
            FhirTerser t = this.getContext().newTerser();
            List refs = t.getAllResourceReferences(theResource);
            for (ResourceReferenceInfo nextRef : refs) {
                IIdType refId = nextRef.getResourceReference().getReferenceElement();
                if (refId == null || !refId.hasBaseUrl() || !this.getConfig().getTreatBaseUrlsAsLocal().contains(refId.getBaseUrl())) continue;
                IIdType newRefId = refId.toUnqualified();
                nextRef.getResourceReference().setReference(newRefId.getValue());
            }
        }
    }

    private void performAutoVersioning(IBaseResource theResource, boolean thePerformIndexing) {
        if (thePerformIndexing) {
            Set<IBaseReference> referencesToVersion = BaseStorageDao.extractReferencesToAutoVersion(this.myFhirContext, this.myModelConfig, theResource);
            for (IBaseReference nextReference : referencesToVersion) {
                IIdType referenceElement = nextReference.getReferenceElement();
                if (referenceElement.hasBaseUrl()) continue;
                String resourceType = referenceElement.getResourceType();
                IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(resourceType);
                String targetVersionId = dao.getCurrentVersionId(referenceElement);
                String newTargetReference = referenceElement.withVersion(targetVersionId).getValue();
                nextReference.setReference(newTargetReference);
            }
        }
    }

    protected DaoMethodOutcome toMethodOutcome(RequestDetails theRequest, @Nonnull IBasePersistedResource theEntity, @Nonnull IBaseResource theResource) {
        DaoMethodOutcome outcome = new DaoMethodOutcome().setPersistentId(theEntity.getPersistentId());
        if (theEntity instanceof ResourceTable && ((ResourceTable)theEntity).isUnchangedInCurrentOperation()) {
            outcome.setNop(true);
        }
        IIdType id = null;
        if (theResource.getIdElement().getValue() != null) {
            id = theResource.getIdElement();
        }
        if (id == null) {
            id = theEntity.getIdDt();
            if (this.getContext().getVersion().getVersion().isRi()) {
                id = this.getContext().getVersion().newIdType().setValue(id.getValue());
            }
        }
        outcome.setId(id);
        if (theEntity.getDeleted() == null) {
            outcome.setResource(theResource);
        }
        outcome.setEntity(theEntity);
        if (outcome.getResource() != null) {
            SimplePreResourceAccessDetails accessDetails = new SimplePreResourceAccessDetails(outcome.getResource());
            HookParams params = new HookParams().add(IPreResourceAccessDetails.class, (Object)accessDetails).add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest);
            CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.getInterceptorBroadcaster(), (RequestDetails)theRequest, (Pointcut)Pointcut.STORAGE_PREACCESS_RESOURCES, (HookParams)params);
            if (accessDetails.isDontReturnResourceAtIndex(0)) {
                outcome.setResource(null);
            }
        }
        outcome.registerResourceViewCallback(() -> {
            if (outcome.getResource() != null) {
                SimplePreResourceShowDetails showDetails = new SimplePreResourceShowDetails(outcome.getResource());
                HookParams params = new HookParams().add(IPreResourceShowDetails.class, (Object)showDetails).add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest);
                CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.getInterceptorBroadcaster(), (RequestDetails)theRequest, (Pointcut)Pointcut.STORAGE_PRESHOW_RESOURCES, (HookParams)params);
                outcome.setResource(showDetails.getResource(0));
            }
        });
        return outcome;
    }

    protected DaoMethodOutcome toMethodOutcomeLazy(RequestDetails theRequest, ResourcePersistentId theResourcePersistentId, @Nonnull Supplier<LazyDaoMethodOutcome.EntityAndResource> theEntity, Supplier<IIdType> theIdSupplier) {
        LazyDaoMethodOutcome outcome = new LazyDaoMethodOutcome(theResourcePersistentId);
        outcome.setEntitySupplier(theEntity);
        outcome.setIdSupplier(theIdSupplier);
        outcome.setEntitySupplierUseCallback(() -> {
            if (outcome.getResource() != null) {
                SimplePreResourceAccessDetails accessDetails = new SimplePreResourceAccessDetails(outcome.getResource());
                HookParams params = new HookParams().add(IPreResourceAccessDetails.class, (Object)accessDetails).add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest);
                CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.getInterceptorBroadcaster(), (RequestDetails)theRequest, (Pointcut)Pointcut.STORAGE_PREACCESS_RESOURCES, (HookParams)params);
                if (accessDetails.isDontReturnResourceAtIndex(0)) {
                    outcome.setResource(null);
                }
            }
            outcome.registerResourceViewCallback(() -> {
                if (outcome.getResource() != null) {
                    SimplePreResourceShowDetails showDetails = new SimplePreResourceShowDetails(outcome.getResource());
                    HookParams params = new HookParams().add(IPreResourceShowDetails.class, (Object)showDetails).add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest);
                    CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.getInterceptorBroadcaster(), (RequestDetails)theRequest, (Pointcut)Pointcut.STORAGE_PRESHOW_RESOURCES, (HookParams)params);
                    outcome.setResource(showDetails.getResource(0));
                }
            });
        });
        return outcome;
    }

    protected void doCallHooks(TransactionDetails theTransactionDetails, RequestDetails theRequestDetails, Pointcut thePointcut, HookParams theParams) {
        if (theTransactionDetails.isAcceptingDeferredInterceptorBroadcasts(thePointcut)) {
            theTransactionDetails.addDeferredInterceptorBroadcast(thePointcut, theParams);
        } else {
            CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.getInterceptorBroadcaster(), (RequestDetails)theRequestDetails, (Pointcut)thePointcut, (HookParams)theParams);
        }
    }

    protected abstract IInterceptorBroadcaster getInterceptorBroadcaster();

    public IBaseOperationOutcome createErrorOperationOutcome(String theMessage, String theCode) {
        return this.createOperationOutcome("error", theMessage, theCode);
    }

    public IBaseOperationOutcome createInfoOperationOutcome(String theMessage) {
        return this.createOperationOutcome("information", theMessage, "informational");
    }

    private IBaseOperationOutcome createOperationOutcome(String theSeverity, String theMessage, String theCode) {
        IBaseOperationOutcome oo = OperationOutcomeUtil.newInstance((FhirContext)this.getContext());
        OperationOutcomeUtil.addIssue((FhirContext)this.getContext(), (IBaseOperationOutcome)oo, (String)theSeverity, (String)theMessage, null, (String)theCode);
        return oo;
    }

    @NotNull
    protected ResourceGoneException createResourceGoneException(IBasePersistedResource theResourceEntity) {
        StringBuilder b = new StringBuilder();
        b.append("Resource was deleted at ");
        b.append(new InstantType(theResourceEntity.getDeleted()).getValueAsString());
        ResourceGoneException retVal = new ResourceGoneException(b.toString());
        retVal.setResourceId(theResourceEntity.getIdDt());
        return retVal;
    }

    protected abstract DaoConfig getConfig();

    @Nullable
    protected abstract String getResourceName();

    protected abstract FhirContext getContext();

    @Transactional(propagation=Propagation.SUPPORTS)
    public void translateRawParameters(Map<String, List<String>> theSource, SearchParameterMap theTarget) {
        if (theSource == null || theSource.isEmpty()) {
            return;
        }
        Map searchParams = this.mySearchParamRegistry.getActiveSearchParams(this.getResourceName());
        Set<String> paramNames = theSource.keySet();
        for (String nextParamName : paramNames) {
            QualifierDetails qualifiedParamName = QualifierDetails.extractQualifiersFromParameterName((String)nextParamName);
            RuntimeSearchParam param = (RuntimeSearchParam)searchParams.get(qualifiedParamName.getParamName());
            if (param == null) {
                Collection validNames = this.mySearchParamRegistry.getValidSearchParameterNamesIncludingMeta(this.getResourceName());
                String msg = this.getContext().getLocalizer().getMessageSanitized(BaseHapiFhirResourceDao.class, "invalidSearchParameter", new Object[]{qualifiedParamName.getParamName(), this.getResourceName(), validNames});
                throw new InvalidRequestException(msg);
            }
            RuntimeSearchParam paramDef = this.mySearchParamRegistry.getActiveSearchParam(this.getResourceName(), qualifiedParamName.getParamName());
            for (String nextValue : theSource.get(nextParamName)) {
                QualifiedParamList qualifiedParam = QualifiedParamList.splitQueryStringByCommasIgnoreEscape((String)qualifiedParamName.getWholeQualifier(), (String)nextValue);
                List<QualifiedParamList> paramList = Collections.singletonList(qualifiedParam);
                IQueryParameterAnd parsedParam = JpaParamUtil.parseQueryParams((ISearchParamRegistry)this.mySearchParamRegistry, (FhirContext)this.getContext(), (RuntimeSearchParam)paramDef, (String)nextParamName, paramList);
                theTarget.add(qualifiedParamName.getParamName(), parsedParam);
            }
        }
    }

    @Nonnull
    public static Set<IBaseReference> extractReferencesToAutoVersion(FhirContext theFhirContext, ModelConfig theModelConfig, IBaseResource theResource) {
        Map references = Collections.emptyMap();
        if (!theModelConfig.getAutoVersionReferenceAtPaths().isEmpty()) {
            String resourceName = theFhirContext.getResourceType(theResource);
            for (String nextPath : theModelConfig.getAutoVersionReferenceAtPathsByResourceType(resourceName)) {
                List nextReferences = theFhirContext.newTerser().getValues((IBase)theResource, nextPath, IBaseReference.class);
                for (IBaseReference next : nextReferences) {
                    if (next.getReferenceElement().hasVersionIdPart()) continue;
                    if (references.isEmpty()) {
                        references = new IdentityHashMap();
                    }
                    references.put(next, null);
                }
            }
        }
        return references.keySet();
    }
}

