/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao;

import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.searchparam.registry.ISearchParamProvider;
import ca.uhn.fhir.model.dstu2.valueset.ResourceTypeEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Service
@Primary
public class DaoSearchParamProvider
implements ISearchParamProvider {
    @Autowired
    private DaoRegistry myDaoRegistry;

    public IBundleProvider search(SearchParameterMap theParams) {
        return this.getSearchParamDao().search(theParams);
    }

    private IFhirResourceDao getSearchParamDao() {
        return this.myDaoRegistry.getResourceDao(ResourceTypeEnum.SEARCHPARAMETER.getCode());
    }

    public IBaseResource read(IIdType theSearchParamId) {
        return this.getSearchParamDao().read(theSearchParamId);
    }
}

