/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.DefaultProfileValidationSupport;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValueSetExpansionOptions;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDaoCodeSystem;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDaoValueSet;
import ca.uhn.fhir.jpa.dao.BaseHapiFhirResourceDao;
import ca.uhn.fhir.jpa.dao.dstu3.FhirResourceDaoValueSetDstu3;
import ca.uhn.fhir.jpa.model.entity.BaseHasResource;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.util.LogicUtil;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.CodingDt;
import ca.uhn.fhir.model.dstu2.resource.ValueSet;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.param.UriParam;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.common.hapi.validation.support.CachingValidationSupport;
import org.hl7.fhir.common.hapi.validation.support.ValidationSupportChain;
import org.hl7.fhir.dstu2.model.ValueSet;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class FhirResourceDaoValueSetDstu2
extends BaseHapiFhirResourceDao<ca.uhn.fhir.model.dstu2.resource.ValueSet>
implements IFhirResourceDaoValueSet<ca.uhn.fhir.model.dstu2.resource.ValueSet, CodingDt, CodeableConceptDt>,
IFhirResourceDaoCodeSystem<ca.uhn.fhir.model.dstu2.resource.ValueSet, CodingDt, CodeableConceptDt> {
    private DefaultProfileValidationSupport myDefaultProfileValidationSupport;
    @Autowired
    private IValidationSupport myJpaValidationSupport;
    @Autowired
    @Qualifier(value="myFhirContextDstu2Hl7Org")
    private FhirContext myRiCtx;
    @Autowired
    private FhirContext myFhirContext;
    private CachingValidationSupport myValidationSupport;

    private void addCompose(String theFilter, ca.uhn.fhir.model.dstu2.resource.ValueSet theValueSetToPopulate, ca.uhn.fhir.model.dstu2.resource.ValueSet theSourceValueSet, ValueSet.CodeSystemConcept theConcept) {
        if (StringUtils.isBlank((CharSequence)theFilter)) {
            this.addCompose(theValueSetToPopulate, theSourceValueSet.getCodeSystem().getSystem(), theConcept.getCode(), theConcept.getDisplay());
        } else {
            String filter = theFilter.toLowerCase();
            if (theConcept.getDisplay().toLowerCase().contains(filter) || theConcept.getCode().toLowerCase().contains(filter)) {
                this.addCompose(theValueSetToPopulate, theSourceValueSet.getCodeSystem().getSystem(), theConcept.getCode(), theConcept.getDisplay());
            }
        }
        for (ValueSet.CodeSystemConcept nextChild : theConcept.getConcept()) {
            this.addCompose(theFilter, theValueSetToPopulate, theSourceValueSet, nextChild);
        }
    }

    private void addCompose(ca.uhn.fhir.model.dstu2.resource.ValueSet retVal, String theSystem, String theCode, String theDisplay) {
        if (StringUtils.isBlank((CharSequence)theCode)) {
            return;
        }
        ValueSet.ExpansionContains contains = retVal.getExpansion().addContains();
        contains.setSystem(theSystem);
        contains.setCode(theCode);
        contains.setDisplay(theDisplay);
    }

    public ca.uhn.fhir.model.dstu2.resource.ValueSet expand(IIdType theId, ValueSetExpansionOptions theOptions, RequestDetails theRequest) {
        ca.uhn.fhir.model.dstu2.resource.ValueSet source = this.loadValueSetForExpansion(theId, theRequest);
        return this.expand(source, theOptions);
    }

    public ca.uhn.fhir.model.dstu2.resource.ValueSet expand(ca.uhn.fhir.model.dstu2.resource.ValueSet source, ValueSetExpansionOptions theOptions) {
        ca.uhn.fhir.model.dstu2.resource.ValueSet retVal = new ca.uhn.fhir.model.dstu2.resource.ValueSet();
        retVal.setDate(DateTimeDt.withCurrentTime());
        String filter = null;
        if (theOptions != null) {
            filter = theOptions.getFilter();
        }
        for (ValueSet.ComposeInclude nextInclude : source.getCompose().getInclude()) {
            for (ValueSet.ComposeIncludeConcept next : nextInclude.getConcept()) {
                if (StringUtils.isBlank((CharSequence)filter)) {
                    this.addCompose(retVal, nextInclude.getSystem(), next.getCode(), next.getDisplay());
                    continue;
                }
                filter = filter.toLowerCase();
                if (!next.getDisplay().toLowerCase().contains(filter) && !next.getCode().toLowerCase().contains(filter)) continue;
                this.addCompose(retVal, nextInclude.getSystem(), next.getCode(), next.getDisplay());
            }
        }
        for (ValueSet.CodeSystemConcept next : source.getCodeSystem().getConcept()) {
            this.addCompose(filter, retVal, source, next);
        }
        return retVal;
    }

    public ca.uhn.fhir.model.dstu2.resource.ValueSet expandByIdentifier(String theUri, ValueSetExpansionOptions theOptions) {
        ca.uhn.fhir.model.dstu2.resource.ValueSet source;
        if (StringUtils.isBlank((CharSequence)theUri)) {
            throw new InvalidRequestException("URI must not be blank or missing");
        }
        ca.uhn.fhir.model.dstu2.resource.ValueSet defaultValueSet = (ca.uhn.fhir.model.dstu2.resource.ValueSet)this.myDefaultProfileValidationSupport.fetchResource(ca.uhn.fhir.model.dstu2.resource.ValueSet.class, theUri);
        if (defaultValueSet != null) {
            source = (ca.uhn.fhir.model.dstu2.resource.ValueSet)this.getContext().newJsonParser().parseResource(ca.uhn.fhir.model.dstu2.resource.ValueSet.class, this.myRiCtx.newJsonParser().encodeResourceToString((IBaseResource)defaultValueSet));
        } else {
            SearchParameterMap params = new SearchParameterMap();
            params.setLoadSynchronousUpTo(Integer.valueOf(1));
            params.add("url", (IQueryParameterType)new UriParam(theUri));
            IBundleProvider ids = this.search(params);
            if (ids.size() == 0) {
                throw new InvalidRequestException("Unknown ValueSet URI: " + theUri);
            }
            source = (ca.uhn.fhir.model.dstu2.resource.ValueSet)ids.getResources(0, 1).get(0);
        }
        return this.expand(source, theOptions);
    }

    public List<IIdType> findCodeSystemIdsContainingSystemAndCode(String theCode, String theSystem, RequestDetails theRequest) {
        if (theSystem != null && theSystem.startsWith("http://hl7.org/fhir/")) {
            return Collections.singletonList(new IdDt(theSystem));
        }
        Set ids = this.searchForIds(new SearchParameterMap("code", (IQueryParameterType)new TokenParam(theSystem, theCode)), theRequest);
        ArrayList<IIdType> valueSetIds = new ArrayList<IIdType>();
        for (ResourcePersistentId next : ids) {
            IIdType id = this.myIdHelperService.translatePidIdToForcedId(this.myFhirContext, "ValueSet", next);
            valueSetIds.add(id);
        }
        return valueSetIds;
    }

    private ca.uhn.fhir.model.dstu2.resource.ValueSet loadValueSetForExpansion(IIdType theId, RequestDetails theRequest) {
        ValueSet valueSet;
        if (theId.getValue().startsWith("http://hl7.org/fhir/") && (valueSet = (ValueSet)this.myValidationSupport.fetchResource(ValueSet.class, theId.getValue())) != null) {
            return (ca.uhn.fhir.model.dstu2.resource.ValueSet)this.getContext().newJsonParser().parseResource(ca.uhn.fhir.model.dstu2.resource.ValueSet.class, this.myRiCtx.newJsonParser().encodeResourceToString((IBaseResource)valueSet));
        }
        BaseHasResource sourceEntity = this.readEntity(theId, theRequest);
        if (sourceEntity == null) {
            throw new ResourceNotFoundException(theId);
        }
        ca.uhn.fhir.model.dstu2.resource.ValueSet source = (ca.uhn.fhir.model.dstu2.resource.ValueSet)this.toResource(sourceEntity, false);
        return source;
    }

    private IValidationSupport.LookupCodeResult lookup(List<ValueSet.ExpansionContains> theContains, String theSystem, String theCode) {
        for (ValueSet.ExpansionContains nextCode : theContains) {
            String system = nextCode.getSystem();
            String code = nextCode.getCode();
            if (!theSystem.equals(system) || !theCode.equals(code)) continue;
            IValidationSupport.LookupCodeResult retVal = new IValidationSupport.LookupCodeResult();
            retVal.setSearchedForCode(code);
            retVal.setSearchedForSystem(system);
            retVal.setFound(true);
            if (nextCode.getAbstract() != null) {
                retVal.setCodeIsAbstract(nextCode.getAbstract().booleanValue());
            }
            retVal.setCodeDisplay(nextCode.getDisplay());
            retVal.setCodeSystemVersion(nextCode.getVersion());
            retVal.setCodeSystemDisplayName("Unknown");
            return retVal;
        }
        return null;
    }

    @Nonnull
    public IValidationSupport.LookupCodeResult lookupCode(IPrimitiveType<String> theCode, IPrimitiveType<String> theSystem, CodingDt theCoding, RequestDetails theRequest) {
        String system;
        String code;
        boolean haveSystem;
        boolean haveCoding = theCoding != null && StringUtils.isNotBlank((CharSequence)theCoding.getSystem()) && StringUtils.isNotBlank((CharSequence)theCoding.getCode());
        boolean haveCode = theCode != null && !theCode.isEmpty();
        boolean bl = haveSystem = theSystem != null && !theSystem.isEmpty();
        if (!(haveCoding || haveSystem && haveCode)) {
            throw new InvalidRequestException("No code, coding, or codeableConcept provided to validate");
        }
        boolean[] blArray = new boolean[2];
        blArray[0] = haveCoding;
        boolean bl2 = blArray[1] = haveSystem && haveCode;
        if (!LogicUtil.multiXor(blArray) || haveSystem != haveCode) {
            throw new InvalidRequestException("$lookup can only validate (system AND code) OR (coding.system AND coding.code)");
        }
        if (haveCoding) {
            code = theCoding.getCode();
            system = theCoding.getSystem();
        } else {
            code = (String)theCode.getValue();
            system = (String)theSystem.getValue();
        }
        List<IIdType> valueSetIds = this.findCodeSystemIdsContainingSystemAndCode(code, system, theRequest);
        for (IIdType nextId : valueSetIds) {
            ca.uhn.fhir.model.dstu2.resource.ValueSet expansion = this.expand(nextId, null, theRequest);
            List contains = expansion.getExpansion().getContains();
            IValidationSupport.LookupCodeResult result = this.lookup(contains, system, code);
            if (result == null) continue;
            return result;
        }
        IValidationSupport.LookupCodeResult retVal = new IValidationSupport.LookupCodeResult();
        retVal.setFound(false);
        retVal.setSearchedForCode(code);
        retVal.setSearchedForSystem(system);
        return retVal;
    }

    public IFhirResourceDaoCodeSystem.SubsumesResult subsumes(IPrimitiveType<String> theCodeA, IPrimitiveType<String> theCodeB, IPrimitiveType<String> theSystem, CodingDt theCodingA, CodingDt theCodingB, RequestDetails theRequestDetails) {
        return this.myTerminologySvc.subsumes(theCodeA, theCodeB, theSystem, (IBaseCoding)theCodingA, (IBaseCoding)theCodingB);
    }

    @Override
    @PostConstruct
    public void postConstruct() {
        super.postConstruct();
        this.myDefaultProfileValidationSupport = new DefaultProfileValidationSupport(this.myFhirContext);
        this.myValidationSupport = new CachingValidationSupport((IValidationSupport)new ValidationSupportChain(new IValidationSupport[]{this.myDefaultProfileValidationSupport, this.myJpaValidationSupport}));
    }

    public void purgeCaches() {
    }

    public IValidationSupport.CodeValidationResult validateCode(IPrimitiveType<String> theValueSetIdentifier, IIdType theId, IPrimitiveType<String> theCode, IPrimitiveType<String> theSystem, IPrimitiveType<String> theDisplay, CodingDt theCoding, CodeableConceptDt theCodeableConcept, RequestDetails theRequest) {
        return this.myTerminologySvc.validateCode(FhirResourceDaoValueSetDstu3.vsValidateCodeOptions(), theId, FhirResourceDaoValueSetDstu2.toStringOrNull(theValueSetIdentifier), FhirResourceDaoValueSetDstu2.toStringOrNull(theSystem), FhirResourceDaoValueSetDstu2.toStringOrNull(theCode), FhirResourceDaoValueSetDstu2.toStringOrNull(theDisplay), (IBaseDatatype)theCoding, (IBaseDatatype)theCodeableConcept);
    }

    public IValidationSupport.CodeValidationResult validateCode(IIdType theCodeSystemId, IPrimitiveType<String> theCodeSystemUrl, IPrimitiveType<String> theVersion, IPrimitiveType<String> theCode, IPrimitiveType<String> theDisplay, CodingDt theCoding, CodeableConceptDt theCodeableConcept, RequestDetails theRequestDetails) {
        throw new UnsupportedOperationException();
    }

    public static String toStringOrNull(IPrimitiveType<String> thePrimitive) {
        return thePrimitive != null ? (String)thePrimitive.getValue() : null;
    }
}

