/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao;

import ca.uhn.fhir.jpa.dao.IFulltextSearchSvc;
import ca.uhn.fhir.jpa.dao.data.IForcedIdDao;
import ca.uhn.fhir.jpa.dao.index.IdHelperService;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.partition.IRequestPartitionHelperSvc;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.param.TokenParam;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.search.engine.search.predicate.dsl.BooleanPredicateClausesStep;
import org.hibernate.search.engine.search.predicate.dsl.PhrasePredicateFieldMoreStep;
import org.hibernate.search.engine.search.predicate.dsl.PredicateFinalStep;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.mapper.orm.Search;
import org.hibernate.search.mapper.orm.session.SearchSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

public class FulltextSearchSvcImpl
implements IFulltextSearchSvc {
    private static final Logger ourLog = LoggerFactory.getLogger(FulltextSearchSvcImpl.class);
    @Autowired
    protected IForcedIdDao myForcedIdDao;
    @PersistenceContext(type=PersistenceContextType.TRANSACTION)
    private EntityManager myEntityManager;
    @Autowired
    private PlatformTransactionManager myTxManager;
    @Autowired
    private IdHelperService myIdHelperService;
    private Boolean ourDisabled;
    @Autowired
    private IRequestPartitionHelperSvc myRequestPartitionHelperService;
    @Autowired
    private PartitionSettings myPartitionSettings;

    private void addTextSearch(SearchPredicateFactory f, BooleanPredicateClausesStep<?> b, List<List<IQueryParameterType>> theTerms, String theFieldName, String theFieldNameEdgeNGram, String theFieldNameTextNGram) {
        if (theTerms == null) {
            return;
        }
        for (List<IQueryParameterType> nextAnd : theTerms) {
            Set<String> terms = this.extractOrStringParams(nextAnd);
            if (terms.size() == 1) {
                b.must((PredicateFinalStep)((PhrasePredicateFieldMoreStep)f.phrase().field(theFieldName).boost(4.0f)).matching(terms.iterator().next().toLowerCase()).slop(2));
                continue;
            }
            if (terms.size() > 1) {
                String joinedTerms = StringUtils.join(terms, (char)' ');
                b.must((PredicateFinalStep)f.match().field(theFieldName).matching((Object)joinedTerms));
                continue;
            }
            ourLog.debug("No Terms found in query parameter {}", nextAnd);
        }
    }

    @Nonnull
    private Set<String> extractOrStringParams(List<? extends IQueryParameterType> nextAnd) {
        HashSet<String> terms = new HashSet<String>();
        for (IQueryParameterType iQueryParameterType : nextAnd) {
            StringParam nextOrString = (StringParam)iQueryParameterType;
            String nextValueTrimmed = StringUtils.defaultString((String)nextOrString.getValue()).trim();
            if (!StringUtils.isNotBlank((CharSequence)nextValueTrimmed)) continue;
            terms.add(nextValueTrimmed);
        }
        return terms;
    }

    private List<ResourcePersistentId> doSearch(String theResourceName, SearchParameterMap theParams, ResourcePersistentId theReferencingPid) {
        SearchSession session = Search.session((EntityManager)this.myEntityManager);
        List contentAndTerms = theParams.remove("_content");
        List textAndTerms = theParams.remove("_text");
        List longPids = session.search(ResourceTable.class).select(f -> f.field("myId", Long.class)).where(f -> f.bool(b -> {
            this.addTextSearch((SearchPredicateFactory)f, (BooleanPredicateClausesStep<?>)b, contentAndTerms, "myContentText", "mycontentTextEdgeNGram", "myContentTextNGram");
            this.addTextSearch((SearchPredicateFactory)f, (BooleanPredicateClausesStep<?>)b, textAndTerms, "myNarrativeText", "myNarrativeTextEdgeNGram", "myNarrativeTextNGram");
            if (theReferencingPid != null) {
                b.must((PredicateFinalStep)f.match().field("myResourceLinksField").matching((Object)theReferencingPid.toString()));
            }
            if (StringUtils.isNotBlank((CharSequence)theResourceName)) {
                b.must((PredicateFinalStep)f.match().field("myResourceType").matching((Object)theResourceName));
            }
        })).fetchAllHits();
        return this.convertLongsToResourcePersistentIds(longPids);
    }

    private List<ResourcePersistentId> convertLongsToResourcePersistentIds(List<Long> theLongPids) {
        return theLongPids.stream().map(pid -> new ResourcePersistentId(pid)).collect(Collectors.toList());
    }

    @Override
    public List<ResourcePersistentId> everything(String theResourceName, SearchParameterMap theParams, RequestDetails theRequest) {
        Object pid = null;
        if (theParams.get("_id") != null) {
            String idParamValue;
            IQueryParameterType idParam = (IQueryParameterType)((List)theParams.get("_id").get(0)).get(0);
            if (idParam instanceof TokenParam) {
                TokenParam idParm = (TokenParam)idParam;
                idParamValue = idParm.getValue();
            } else {
                StringParam idParm = (StringParam)idParam;
                idParamValue = idParm.getValue();
            }
        }
        Object referencingPid = pid;
        List<ResourcePersistentId> retVal = this.doSearch(null, theParams, (ResourcePersistentId)referencingPid);
        if (referencingPid != null) {
            retVal.add((ResourcePersistentId)referencingPid);
        }
        return retVal;
    }

    @Override
    public boolean isDisabled() {
        Boolean retVal = this.ourDisabled;
        if (retVal == null) {
            this.ourDisabled = retVal = (Boolean)new TransactionTemplate(this.myTxManager).execute(t -> {
                try {
                    SearchSession searchSession = Search.session((EntityManager)this.myEntityManager);
                    searchSession.search(ResourceTable.class);
                    return Boolean.FALSE;
                }
                catch (Exception e) {
                    ourLog.trace("FullText test failed", (Throwable)e);
                    ourLog.debug("Hibernate Search (Lucene) appears to be disabled on this server, fulltext will be disabled");
                    return Boolean.TRUE;
                }
            });
        }
        assert (retVal != null);
        return retVal;
    }

    @Override
    @Transactional
    public List<ResourcePersistentId> search(String theResourceName, SearchParameterMap theParams) {
        return this.doSearch(theResourceName, theParams, null);
    }
}

