/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao;

import ca.uhn.fhir.parser.DataFormatException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;

public class GZipUtil {
    public static String decompress(byte[] theResource) {
        try {
            GZIPInputStream is = new GZIPInputStream(new ByteArrayInputStream(theResource));
            return IOUtils.toString((InputStream)is, (String)"UTF-8");
        }
        catch (IOException e) {
            throw new DataFormatException("Failed to decompress contents", (Throwable)e);
        }
    }

    public static byte[] compress(String theEncoded) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            GZIPOutputStream gos = new GZIPOutputStream(os);
            IOUtils.write((String)theEncoded, (OutputStream)gos, (String)"UTF-8");
            gos.close();
            os.close();
            byte[] retVal = os.toByteArray();
            return retVal;
        }
        catch (IOException e) {
            throw new DataFormatException("Compress contents", (Throwable)e);
        }
    }
}

