/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao;

import ca.uhn.fhir.context.ComboSearchParamType;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.api.dao.IDao;
import ca.uhn.fhir.jpa.dao.IFulltextSearchSvc;
import ca.uhn.fhir.jpa.dao.IResultIterator;
import ca.uhn.fhir.jpa.dao.ISearchBuilder;
import ca.uhn.fhir.jpa.dao.data.IResourceSearchViewDao;
import ca.uhn.fhir.jpa.dao.data.IResourceTagDao;
import ca.uhn.fhir.jpa.dao.index.IdHelperService;
import ca.uhn.fhir.jpa.dao.predicate.PredicateBuilder;
import ca.uhn.fhir.jpa.dao.predicate.PredicateBuilderFactory;
import ca.uhn.fhir.jpa.dao.predicate.SearchBuilderJoinEnum;
import ca.uhn.fhir.jpa.dao.predicate.SearchBuilderJoinKey;
import ca.uhn.fhir.jpa.dao.predicate.querystack.QueryStack;
import ca.uhn.fhir.jpa.entity.ResourceSearchView;
import ca.uhn.fhir.jpa.interceptor.JpaPreResourceAccessDetails;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndexedSearchParam;
import ca.uhn.fhir.jpa.model.entity.IBaseResourceEntity;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.model.entity.ResourceTag;
import ca.uhn.fhir.jpa.model.search.SearchRuntimeDetails;
import ca.uhn.fhir.jpa.model.search.StorageProcessingMessage;
import ca.uhn.fhir.jpa.search.DatabaseBackedPagingProvider;
import ca.uhn.fhir.jpa.search.builder.SearchBuilder;
import ca.uhn.fhir.jpa.search.lastn.IElasticsearchSvc;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.searchparam.util.Dstu3DistanceHelper;
import ca.uhn.fhir.jpa.searchparam.util.LastNParameterHelper;
import ca.uhn.fhir.jpa.util.BaseIterator;
import ca.uhn.fhir.jpa.util.CurrentThreadCaptureQueriesListener;
import ca.uhn.fhir.jpa.util.QueryChunker;
import ca.uhn.fhir.jpa.util.ScrollableResultsIterator;
import ca.uhn.fhir.jpa.util.SqlQueryList;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.ResourceMetadataKeyEnum;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.valueset.BundleEntrySearchModeEnum;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import ca.uhn.fhir.rest.api.SortOrderEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.server.IPreResourceAccessDetails;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.ReferenceParam;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.util.CompositeInterceptorBroadcaster;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import ca.uhn.fhir.util.ICallable;
import ca.uhn.fhir.util.StopWatch;
import ca.uhn.fhir.util.UrlUtil;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.query.Query;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class LegacySearchBuilder
implements ISearchBuilder {
    private static final List<ResourcePersistentId> EMPTY_LONG_LIST = Collections.unmodifiableList(new ArrayList());
    private static final Logger ourLog = LoggerFactory.getLogger(LegacySearchBuilder.class);
    private static final ResourcePersistentId NO_MORE = new ResourcePersistentId((Object)-1L);
    private final String myResourceName;
    private final Class<? extends IBaseResource> myResourceType;
    private final IDao myCallingDao;
    @Autowired
    protected IInterceptorBroadcaster myInterceptorBroadcaster;
    @Autowired
    protected IResourceTagDao myResourceTagDao;
    @PersistenceContext(type=PersistenceContextType.TRANSACTION)
    protected EntityManager myEntityManager;
    private QueryStack myQueryStack;
    @Autowired
    private DaoConfig myDaoConfig;
    @Autowired
    private IResourceSearchViewDao myResourceSearchViewDao;
    @Autowired
    private FhirContext myContext;
    @Autowired
    private IdHelperService myIdHelperService;
    @Autowired(required=false)
    private IFulltextSearchSvc myFulltextSearchSvc;
    @Autowired(required=false)
    private IElasticsearchSvc myIElasticsearchSvc;
    @Autowired
    private ISearchParamRegistry mySearchParamRegistry;
    @Autowired
    private PredicateBuilderFactory myPredicateBuilderFactory;
    private List<ResourcePersistentId> myAlsoIncludePids;
    private CriteriaBuilder myCriteriaBuilder;
    private SearchParameterMap myParams;
    private String mySearchUuid;
    private int myFetchSize;
    private Integer myMaxResultsToFetch;
    private Set<ResourcePersistentId> myPidSet;
    private PredicateBuilder myPredicateBuilder;
    private RequestPartitionId myRequestPartitionId;
    @Autowired
    private PartitionSettings myPartitionSettings;

    public LegacySearchBuilder(IDao theDao, String theResourceName, Class<? extends IBaseResource> theResourceType) {
        this.myCallingDao = theDao;
        this.myResourceName = theResourceName;
        this.myResourceType = theResourceType;
    }

    @Override
    public void setMaxResultsToFetch(Integer theMaxResultsToFetch) {
        this.myMaxResultsToFetch = theMaxResultsToFetch;
    }

    private void searchForIdsWithAndOr(String theResourceName, String theNextParamName, List<List<IQueryParameterType>> theAndOrParams, RequestDetails theRequest) {
        this.myPredicateBuilder.searchForIdsWithAndOr(theResourceName, theNextParamName, theAndOrParams, theRequest, this.myRequestPartitionId);
    }

    private void searchForIdsWithAndOr(@Nonnull SearchParameterMap theParams, RequestDetails theRequest) {
        this.myParams = theParams;
        theParams.clean();
        if (this.myContext.getVersion().getVersion() == FhirVersionEnum.DSTU3) {
            Dstu3DistanceHelper.setNearDistance(this.myResourceType, (SearchParameterMap)theParams);
        }
        if (this.isCompositeUniqueSpCandidate()) {
            this.attemptCompositeUniqueSpProcessing(theParams, theRequest);
        }
        for (Map.Entry nextParamEntry : this.myParams.entrySet()) {
            String nextParamName = (String)nextParamEntry.getKey();
            if (this.myParams.isLastN() && LastNParameterHelper.isLastNParameter((String)nextParamName, (FhirContext)this.myContext)) continue;
            List andOrParams = (List)nextParamEntry.getValue();
            this.searchForIdsWithAndOr(this.myResourceName, nextParamName, andOrParams, theRequest);
        }
    }

    private boolean isCompositeUniqueSpCandidate() {
        return this.myDaoConfig.isUniqueIndexesEnabled() && this.myParams.getEverythingMode() == null && this.myParams.isAllParametersHaveNoModifier();
    }

    @Override
    public Iterator<Long> createCountQuery(SearchParameterMap theParams, String theSearchUuid, RequestDetails theRequest, @Nonnull RequestPartitionId theRequestPartitionId) {
        assert (theRequestPartitionId != null);
        assert (TransactionSynchronizationManager.isActualTransactionActive());
        this.init(theParams, theSearchUuid, theRequestPartitionId);
        List<TypedQuery<Long>> queries = this.createQuery(null, null, null, true, theRequest, null);
        return new CountQueryIterator(queries.get(0));
    }

    @Override
    public void setPreviouslyAddedResourcePids(@Nonnull List<ResourcePersistentId> thePidSet) {
        this.myPidSet = new HashSet<ResourcePersistentId>(thePidSet);
    }

    @Override
    public IResultIterator createQuery(SearchParameterMap theParams, SearchRuntimeDetails theSearchRuntimeDetails, RequestDetails theRequest, @Nonnull RequestPartitionId theRequestPartitionId) {
        assert (theRequestPartitionId != null);
        assert (TransactionSynchronizationManager.isActualTransactionActive());
        this.init(theParams, theSearchRuntimeDetails.getSearchUuid(), theRequestPartitionId);
        if (this.myPidSet == null) {
            this.myPidSet = new HashSet<ResourcePersistentId>();
        }
        return new QueryIterator(theSearchRuntimeDetails, theRequest);
    }

    private void init(SearchParameterMap theParams, String theSearchUuid, RequestPartitionId theRequestPartitionId) {
        this.myCriteriaBuilder = this.myEntityManager.getCriteriaBuilder();
        this.myQueryStack = new QueryStack(this.myCriteriaBuilder, this.myResourceName, theParams, theRequestPartitionId);
        this.myParams = theParams;
        this.mySearchUuid = theSearchUuid;
        this.myPredicateBuilder = new PredicateBuilder(this, this.myPredicateBuilderFactory);
        this.myRequestPartitionId = theRequestPartitionId;
    }

    private List<TypedQuery<Long>> createQuery(SortSpec sort, Integer theOffset, Integer theMaximumResults, boolean theCount, RequestDetails theRequest, SearchRuntimeDetails theSearchRuntimeDetails) {
        List<Object> pids = new ArrayList();
        if (this.myParams.containsKey("_content") || this.myParams.containsKey("_text") || this.myParams.isLastN()) {
            if (this.myParams.containsKey("_content") || this.myParams.containsKey("_text")) {
                if (this.myFulltextSearchSvc == null) {
                    if (this.myParams.containsKey("_text")) {
                        throw new InvalidRequestException("Fulltext search is not enabled on this service, can not process parameter: _text");
                    }
                    if (this.myParams.containsKey("_content")) {
                        throw new InvalidRequestException("Fulltext search is not enabled on this service, can not process parameter: _content");
                    }
                }
                pids = this.myParams.getEverythingMode() != null ? this.myFulltextSearchSvc.everything(this.myResourceName, this.myParams, theRequest) : this.myFulltextSearchSvc.search(this.myResourceName, this.myParams);
            } else if (this.myParams.isLastN()) {
                if (this.myIElasticsearchSvc == null && this.myParams.isLastN()) {
                    throw new InvalidRequestException("LastN operation is not enabled on this service, can not process this request");
                }
                List<String> lastnResourceIds = this.myIElasticsearchSvc.executeLastN(this.myParams, this.myContext, theMaximumResults);
                for (String lastnResourceId : lastnResourceIds) {
                    pids.add(this.myIdHelperService.resolveResourcePersistentIds(this.myRequestPartitionId, this.myResourceName, lastnResourceId));
                }
            }
            if (theSearchRuntimeDetails != null) {
                theSearchRuntimeDetails.setFoundIndexMatchesCount(pids.size());
                HookParams params = new HookParams().add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest).add(SearchRuntimeDetails.class, (Object)theSearchRuntimeDetails);
                CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest, (Pointcut)Pointcut.JPA_PERFTRACE_INDEXSEARCH_QUERY_COMPLETE, (HookParams)params);
            }
            if (pids.isEmpty()) {
                pids = Collections.singletonList(new ResourcePersistentId((Object)-1L));
            }
        }
        ArrayList<TypedQuery<Long>> myQueries = new ArrayList<TypedQuery<Long>>();
        if (!pids.isEmpty()) {
            if (theMaximumResults != null && pids.size() > theMaximumResults) {
                pids.subList(0, theMaximumResults - 1);
            }
            new QueryChunker().chunk(ResourcePersistentId.toLongList(pids), t -> this.doCreateChunkedQueries((List<Long>)t, sort, theOffset, theCount, theRequest, myQueries));
        } else {
            myQueries.add(this.createChunkedQuery(sort, theOffset, theMaximumResults, theCount, theRequest, null));
        }
        return myQueries;
    }

    private void doCreateChunkedQueries(List<Long> thePids, SortSpec sort, Integer theOffset, boolean theCount, RequestDetails theRequest, ArrayList<TypedQuery<Long>> theQueries) {
        if (thePids.size() < SearchBuilder.getMaximumPageSize()) {
            this.normalizeIdListForLastNInClause(thePids);
        }
        theQueries.add(this.createChunkedQuery(sort, theOffset, thePids.size(), theCount, theRequest, thePids));
    }

    private TypedQuery<Long> createChunkedQuery(SortSpec sort, Integer theOffset, Integer theMaximumResults, boolean theCount, RequestDetails theRequest, List<Long> thePidList) {
        if (sort != null) {
            assert (!theCount);
            this.myQueryStack.pushResourceTableQuery();
            List<Order> orders = this.createSort(this.myCriteriaBuilder, this.myQueryStack, sort);
            if (orders.size() > 0) {
                this.myQueryStack.orderBy(orders);
            }
        } else if (theCount) {
            this.myQueryStack.pushResourceTableCountQuery();
        } else if (this.myParams.getEverythingMode() != null && this.myParams.isLoadSynchronous()) {
            this.myQueryStack.pushResourceTableDistinctQuery();
        } else {
            this.myQueryStack.pushResourceTableQuery();
        }
        if (this.myParams.getEverythingMode() != null) {
            From join = this.myQueryStack.createJoin(SearchBuilderJoinEnum.REFERENCE, null);
            if (this.myParams.get("_id") != null) {
                StringParam idParam = (StringParam)((List)this.myParams.get("_id").get(0)).get(0);
                ResourcePersistentId pid = this.myIdHelperService.resolveResourcePersistentIds(this.myRequestPartitionId, this.myResourceName, idParam.getValue());
                if (this.myAlsoIncludePids == null) {
                    this.myAlsoIncludePids = new ArrayList<ResourcePersistentId>(1);
                }
                this.myAlsoIncludePids.add(pid);
                this.myQueryStack.addPredicate(this.myCriteriaBuilder.equal(join.get("myTargetResourcePid").as(Long.class), (Object)pid.getIdAsLong()));
            } else {
                Predicate targetTypePredicate = this.myCriteriaBuilder.equal(join.get("myTargetResourceType").as(String.class), (Object)this.myResourceName);
                Predicate sourceTypePredicate = this.myCriteriaBuilder.equal(this.myQueryStack.get("myResourceType").as(String.class), (Object)this.myResourceName);
                this.myQueryStack.addPredicate(this.myCriteriaBuilder.or((Expression)sourceTypePredicate, (Expression)targetTypePredicate));
            }
        } else {
            this.searchForIdsWithAndOr(this.myParams, theRequest);
        }
        if (thePidList != null && thePidList.size() > 0) {
            this.myQueryStack.addPredicate(this.myQueryStack.get("myId").as(Long.class).in(thePidList));
        }
        DateRangeParam lu = this.myParams.getLastUpdated();
        List<Predicate> lastUpdatedPredicates = this.createLastUpdatedPredicates(lu, this.myCriteriaBuilder);
        this.myQueryStack.addPredicates(lastUpdatedPredicates);
        CriteriaQuery outerQuery = (CriteriaQuery)this.myQueryStack.pop();
        TypedQuery query = this.myEntityManager.createQuery(outerQuery);
        assert (this.myQueryStack.isEmpty());
        if (!theCount && theOffset != null) {
            query.setFirstResult(theOffset.intValue());
        }
        if (theMaximumResults != null) {
            query.setMaxResults(theMaximumResults.intValue());
        }
        return query;
    }

    private List<Long> normalizeIdListForLastNInClause(List<Long> lastnResourceIds) {
        int listSize = lastnResourceIds.size();
        if (listSize > 1 && listSize < 10) {
            this.padIdListWithPlaceholders(lastnResourceIds, 10);
        } else if (listSize > 10 && listSize < 50) {
            this.padIdListWithPlaceholders(lastnResourceIds, 50);
        } else if (listSize > 50 && listSize < 100) {
            this.padIdListWithPlaceholders(lastnResourceIds, 100);
        } else if (listSize > 100 && listSize < 200) {
            this.padIdListWithPlaceholders(lastnResourceIds, 200);
        } else if (listSize > 200 && listSize < 500) {
            this.padIdListWithPlaceholders(lastnResourceIds, 500);
        } else if (listSize > 500 && listSize < 800) {
            this.padIdListWithPlaceholders(lastnResourceIds, 800);
        }
        return lastnResourceIds;
    }

    private void padIdListWithPlaceholders(List<Long> theIdList, int preferredListSize) {
        while (theIdList.size() < preferredListSize) {
            theIdList.add(-1L);
        }
    }

    private List<Order> createSort(CriteriaBuilder theBuilder, QueryStack theQueryStack, SortSpec theSort) {
        From join;
        SearchBuilderJoinEnum joinType;
        String[] sortAttrName;
        if (theSort == null || StringUtils.isBlank((CharSequence)theSort.getParamName())) {
            return Collections.emptyList();
        }
        ArrayList<Order> orders = new ArrayList<Order>(1);
        if ("_id".equals(theSort.getParamName())) {
            From forcedIdJoin = theQueryStack.createJoin(SearchBuilderJoinEnum.FORCED_ID, null);
            if (theSort.getOrder() == null || theSort.getOrder() == SortOrderEnum.ASC) {
                orders.add(theBuilder.asc((Expression)forcedIdJoin.get("myForcedId")));
                orders.add(theBuilder.asc(theQueryStack.get("myId")));
            } else {
                orders.add(theBuilder.desc((Expression)forcedIdJoin.get("myForcedId")));
                orders.add(theBuilder.desc(theQueryStack.get("myId")));
            }
            orders.addAll(this.createSort(theBuilder, theQueryStack, theSort.getChain()));
            return orders;
        }
        if ("_lastUpdated".equals(theSort.getParamName())) {
            if (theSort.getOrder() == null || theSort.getOrder() == SortOrderEnum.ASC) {
                orders.add(theBuilder.asc(theQueryStack.get("myUpdated")));
            } else {
                orders.add(theBuilder.desc(theQueryStack.get("myUpdated")));
            }
            orders.addAll(this.createSort(theBuilder, theQueryStack, theSort.getChain()));
            return orders;
        }
        RuntimeSearchParam param = this.mySearchParamRegistry.getActiveSearchParam(this.myResourceName, theSort.getParamName());
        if (param == null) {
            throw new InvalidRequestException("Unknown sort parameter '" + theSort.getParamName() + "'");
        }
        switch (param.getParamType()) {
            case STRING: {
                sortAttrName = new String[]{"myValueExact"};
                joinType = SearchBuilderJoinEnum.STRING;
                break;
            }
            case DATE: {
                sortAttrName = new String[]{"myValueLow"};
                joinType = SearchBuilderJoinEnum.DATE;
                break;
            }
            case REFERENCE: {
                sortAttrName = new String[]{"myTargetResourcePid"};
                joinType = SearchBuilderJoinEnum.REFERENCE;
                break;
            }
            case TOKEN: {
                sortAttrName = new String[]{"mySystem", "myValue"};
                joinType = SearchBuilderJoinEnum.TOKEN;
                break;
            }
            case NUMBER: {
                sortAttrName = new String[]{"myValue"};
                joinType = SearchBuilderJoinEnum.NUMBER;
                break;
            }
            case URI: {
                sortAttrName = new String[]{"myUri"};
                joinType = SearchBuilderJoinEnum.URI;
                break;
            }
            case QUANTITY: {
                sortAttrName = new String[]{"myValue"};
                joinType = SearchBuilderJoinEnum.QUANTITY;
                break;
            }
            default: {
                throw new InvalidRequestException("This server does not support _sort specifications of type " + param.getParamType() + " - Can't serve _sort=" + theSort.getParamName());
            }
        }
        SearchBuilderJoinKey key = new SearchBuilderJoinKey(theSort.getParamName(), joinType);
        Optional<Join<?, ?>> joinOpt = theQueryStack.getExistingJoin(key);
        if (!joinOpt.isPresent()) {
            join = theQueryStack.createJoin(joinType, theSort.getParamName());
            if (param.getParamType() == RestSearchParameterTypeEnum.REFERENCE) {
                theQueryStack.addPredicate(join.get("mySourcePath").as(String.class).in((Collection)param.getPathsSplit()));
            } else if (this.myDaoConfig.getDisableHashBasedSearches()) {
                Predicate joinParam1 = theBuilder.equal((Expression)join.get("myParamName"), (Object)theSort.getParamName());
                theQueryStack.addPredicate(joinParam1);
            } else {
                Long hashIdentity = BaseResourceIndexedSearchParam.calculateHashIdentity((PartitionSettings)this.myPartitionSettings, (RequestPartitionId)this.myRequestPartitionId, (String)this.myResourceName, (String)theSort.getParamName());
                Predicate joinParam1 = theBuilder.equal((Expression)join.get("myHashIdentity"), (Object)hashIdentity);
                theQueryStack.addPredicate(joinParam1);
            }
        } else {
            ourLog.debug("Reusing join for {}", (Object)theSort.getParamName());
            join = (From)joinOpt.get();
        }
        for (String next : sortAttrName) {
            if (theSort.getOrder() == null || theSort.getOrder() == SortOrderEnum.ASC) {
                orders.add(theBuilder.asc((Expression)join.get(next)));
                continue;
            }
            orders.add(theBuilder.desc((Expression)join.get(next)));
        }
        orders.addAll(this.createSort(theBuilder, theQueryStack, theSort.getChain()));
        return orders;
    }

    private void doLoadPids(Collection<ResourcePersistentId> thePids, Collection<ResourcePersistentId> theIncludedPids, List<IBaseResource> theResourceListToPopulate, boolean theForHistoryOperation, Map<ResourcePersistentId, Integer> thePosition) {
        List<Long> myLongPersistentIds = thePids.size() < SearchBuilder.getMaximumPageSize() ? this.normalizeIdListForLastNInClause(ResourcePersistentId.toLongList(thePids)) : ResourcePersistentId.toLongList(thePids);
        Collection<ResourceSearchView> resourceSearchViewList = this.myResourceSearchViewDao.findByResourceIds(myLongPersistentIds);
        Map<ResourcePersistentId, Collection<ResourceTag>> tagMap = this.getResourceTagMap(resourceSearchViewList);
        for (ResourceSearchView next : resourceSearchViewList) {
            ResourcePersistentId resourceId;
            if (next.getDeleted() != null) continue;
            Class resourceType = this.myContext.getResourceDefinition(next.getResourceType()).getImplementingClass();
            IBaseResource resource = this.myCallingDao.toResource(resourceType, (IBaseResourceEntity)next, tagMap.get(resourceId = new ResourcePersistentId((Object)next.getId())), theForHistoryOperation);
            if (resource == null) {
                ourLog.warn("Unable to find resource {}/{}/_history/{} in database", new Object[]{next.getResourceType(), next.getIdDt().getIdPart(), next.getVersion()});
                continue;
            }
            Integer index = thePosition.get(resourceId);
            if (index == null) {
                ourLog.warn("Got back unexpected resource PID {}", (Object)resourceId);
                continue;
            }
            if (resource instanceof IResource) {
                if (theIncludedPids.contains(resourceId)) {
                    ResourceMetadataKeyEnum.ENTRY_SEARCH_MODE.put((IResource)resource, (Object)BundleEntrySearchModeEnum.INCLUDE);
                } else {
                    ResourceMetadataKeyEnum.ENTRY_SEARCH_MODE.put((IResource)resource, (Object)BundleEntrySearchModeEnum.MATCH);
                }
            } else if (theIncludedPids.contains(resourceId)) {
                ResourceMetadataKeyEnum.ENTRY_SEARCH_MODE.put((IAnyResource)resource, (Object)BundleEntrySearchModeEnum.INCLUDE.getCode());
            } else {
                ResourceMetadataKeyEnum.ENTRY_SEARCH_MODE.put((IAnyResource)resource, (Object)BundleEntrySearchModeEnum.MATCH.getCode());
            }
            theResourceListToPopulate.set(index, resource);
        }
    }

    private Map<ResourcePersistentId, Collection<ResourceTag>> getResourceTagMap(Collection<ResourceSearchView> theResourceSearchViewList) {
        ArrayList<Long> idList = new ArrayList<Long>(theResourceSearchViewList.size());
        for (ResourceSearchView resource : theResourceSearchViewList) {
            if (!resource.isHasTags()) continue;
            idList.add(resource.getId());
        }
        HashMap<ResourcePersistentId, Collection<ResourceTag>> tagMap = new HashMap<ResourcePersistentId, Collection<ResourceTag>>();
        if (idList.size() == 0) {
            return tagMap;
        }
        Collection<ResourceTag> tagList = this.myResourceTagDao.findByResourceIds(idList);
        for (ResourceTag tag : tagList) {
            ResourcePersistentId resourceId = new ResourcePersistentId((Object)tag.getResourceId());
            ArrayList<ResourceTag> tagCol = (ArrayList<ResourceTag>)tagMap.get(resourceId);
            if (tagCol == null) {
                tagCol = new ArrayList<ResourceTag>();
                tagCol.add(tag);
                tagMap.put(resourceId, tagCol);
                continue;
            }
            tagCol.add(tag);
        }
        return tagMap;
    }

    @Override
    public void loadResourcesByPid(Collection<ResourcePersistentId> thePids, Collection<ResourcePersistentId> theIncludedPids, List<IBaseResource> theResourceListToPopulate, boolean theForHistoryOperation, RequestDetails theDetails) {
        if (thePids.isEmpty()) {
            ourLog.debug("The include pids are empty");
        }
        assert (new HashSet<ResourcePersistentId>(thePids).size() == thePids.size()) : "PID list contains duplicates: " + thePids;
        HashMap<ResourcePersistentId, Integer> position = new HashMap<ResourcePersistentId, Integer>();
        for (ResourcePersistentId next : thePids) {
            position.put(next, theResourceListToPopulate.size());
            theResourceListToPopulate.add(null);
        }
        ArrayList<ResourcePersistentId> pids = new ArrayList<ResourcePersistentId>(thePids);
        new QueryChunker<ResourcePersistentId>().chunk(pids, t -> this.doLoadPids((Collection<ResourcePersistentId>)t, theIncludedPids, theResourceListToPopulate, theForHistoryOperation, (Map<ResourcePersistentId, Integer>)position));
    }

    public HashSet<ResourcePersistentId> loadIncludes(FhirContext theContext, EntityManager theEntityManager, Collection<ResourcePersistentId> theMatches, Set<Include> theRevIncludes, boolean theReverseMode, DateRangeParam theLastUpdated, String theSearchIdOrDescription, RequestDetails theRequest, Integer theMaxCount) {
        boolean addedSomeThisRound;
        if (theMatches.size() == 0) {
            return new HashSet<ResourcePersistentId>();
        }
        if (theRevIncludes == null || theRevIncludes.isEmpty()) {
            return new HashSet<ResourcePersistentId>();
        }
        String searchFieldName = theReverseMode ? "myTargetResourcePid" : "mySourceResourcePid";
        String findFieldName = theReverseMode ? "mySourceResourcePid" : "myTargetResourcePid";
        Collection<ResourcePersistentId> nextRoundMatches = theMatches;
        HashSet<ResourcePersistentId> allAdded = new HashSet<ResourcePersistentId>();
        HashSet<ResourcePersistentId> original = new HashSet<ResourcePersistentId>(theMatches);
        ArrayList<Include> includes = new ArrayList<Include>(theRevIncludes);
        int roundCounts = 0;
        StopWatch w = new StopWatch();
        do {
            ++roundCounts;
            HashSet<ResourcePersistentId> pidsToInclude = new HashSet<ResourcePersistentId>();
            Iterator<Include> iter = includes.iterator();
            while (iter.hasNext()) {
                boolean matchAll;
                Include nextInclude = iter.next();
                if (!nextInclude.isRecurse()) {
                    iter.remove();
                }
                if (matchAll = "*".equals(nextInclude.getValue())) {
                    String sql = "SELECT r." + findFieldName + " FROM ResourceLink r WHERE r." + searchFieldName + " IN (:target_pids) ";
                    List<Collection<ResourcePersistentId>> partitions = this.partition(nextRoundMatches, SearchBuilder.getMaximumPageSize());
                    for (Collection<ResourcePersistentId> nextPartition : partitions) {
                        TypedQuery q = theEntityManager.createQuery(sql, Long.class);
                        q.setParameter("target_pids", (Object)ResourcePersistentId.toLongList(nextPartition));
                        List results = q.getResultList();
                        for (Long resourceLink : results) {
                            if (resourceLink == null) continue;
                            if (theReverseMode) {
                                pidsToInclude.add(new ResourcePersistentId((Object)resourceLink));
                                continue;
                            }
                            pidsToInclude.add(new ResourcePersistentId((Object)resourceLink));
                        }
                    }
                    continue;
                }
                String resType = nextInclude.getParamType();
                if (StringUtils.isBlank((CharSequence)resType)) continue;
                RuntimeResourceDefinition def = theContext.getResourceDefinition(resType);
                if (def == null) {
                    ourLog.warn("Unknown resource type in include/revinclude=" + nextInclude.getValue());
                    continue;
                }
                String paramName = nextInclude.getParamName();
                RuntimeSearchParam param = StringUtils.isNotBlank((CharSequence)paramName) ? this.mySearchParamRegistry.getActiveSearchParam(resType, paramName) : null;
                if (param == null) {
                    ourLog.warn("Unknown param name in include/revinclude=" + nextInclude.getValue());
                    continue;
                }
                List paths = param.getPathsSplit();
                String targetResourceType = StringUtils.defaultString((String)nextInclude.getParamTargetType(), null);
                for (String nextPath : paths) {
                    boolean haveTargetTypesDefinedByParam = param.hasTargets();
                    String sql = targetResourceType != null ? "SELECT r." + findFieldName + " FROM ResourceLink r WHERE r.mySourcePath = :src_path AND r." + searchFieldName + " IN (:target_pids) AND r.myTargetResourceType = :target_resource_type" : (haveTargetTypesDefinedByParam ? "SELECT r." + findFieldName + " FROM ResourceLink r WHERE r.mySourcePath = :src_path AND r." + searchFieldName + " IN (:target_pids) AND r.myTargetResourceType in (:target_resource_types)" : "SELECT r." + findFieldName + " FROM ResourceLink r WHERE r.mySourcePath = :src_path AND r." + searchFieldName + " IN (:target_pids)");
                    List<Collection<ResourcePersistentId>> partitions = this.partition(nextRoundMatches, SearchBuilder.getMaximumPageSize());
                    for (Collection<ResourcePersistentId> nextPartition : partitions) {
                        TypedQuery q = theEntityManager.createQuery(sql, Long.class);
                        q.setParameter("src_path", (Object)nextPath);
                        q.setParameter("target_pids", (Object)ResourcePersistentId.toLongList(nextPartition));
                        if (targetResourceType != null) {
                            q.setParameter("target_resource_type", (Object)targetResourceType);
                        } else if (haveTargetTypesDefinedByParam) {
                            q.setParameter("target_resource_types", (Object)param.getTargets());
                        }
                        List results = q.getResultList();
                        for (Long resourceLink : results) {
                            if (resourceLink == null) continue;
                            pidsToInclude.add(new ResourcePersistentId((Object)resourceLink));
                        }
                    }
                }
            }
            if (theReverseMode && theLastUpdated != null && (theLastUpdated.getLowerBoundAsInstant() != null || theLastUpdated.getUpperBoundAsInstant() != null)) {
                pidsToInclude = new HashSet<ResourcePersistentId>(LegacySearchBuilder.filterResourceIdsByLastUpdated(theEntityManager, theLastUpdated, pidsToInclude));
            }
            addedSomeThisRound = allAdded.addAll(pidsToInclude);
            nextRoundMatches = pidsToInclude;
        } while (includes.size() > 0 && nextRoundMatches.size() > 0 && addedSomeThisRound);
        allAdded.removeAll(original);
        ourLog.info("Loaded {} {} in {} rounds and {} ms for search {}", new Object[]{allAdded.size(), theReverseMode ? "_revincludes" : "_includes", roundCounts, w.getMillisAndRestart(), theSearchIdOrDescription});
        if (allAdded.size() > 0) {
            ArrayList<ResourcePersistentId> includedPidList = new ArrayList<ResourcePersistentId>(allAdded);
            JpaPreResourceAccessDetails accessDetails = new JpaPreResourceAccessDetails(includedPidList, (ICallable<ISearchBuilder>)((ICallable)() -> this));
            HookParams params = new HookParams().add(IPreResourceAccessDetails.class, (Object)accessDetails).add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest);
            CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest, (Pointcut)Pointcut.STORAGE_PREACCESS_RESOURCES, (HookParams)params);
            allAdded = new HashSet<ResourcePersistentId>(includedPidList);
            for (int i = includedPidList.size() - 1; i >= 0; --i) {
                ResourcePersistentId value;
                if (!accessDetails.isDontReturnResourceAtIndex(i) || (value = (ResourcePersistentId)includedPidList.remove(i)) == null) continue;
                allAdded.remove(value);
            }
        }
        return allAdded;
    }

    private List<Collection<ResourcePersistentId>> partition(Collection<ResourcePersistentId> theNextRoundMatches, int theMaxLoad) {
        if (theNextRoundMatches.size() <= theMaxLoad) {
            return Collections.singletonList(theNextRoundMatches);
        }
        ArrayList<Collection<ResourcePersistentId>> retVal = new ArrayList<Collection<ResourcePersistentId>>();
        ArrayList<ResourcePersistentId> current = null;
        for (ResourcePersistentId next : theNextRoundMatches) {
            if (current == null) {
                current = new ArrayList<ResourcePersistentId>(theMaxLoad);
                retVal.add(current);
            }
            current.add(next);
            if (current.size() < theMaxLoad) continue;
            current = null;
        }
        return retVal;
    }

    private void attemptCompositeUniqueSpProcessing(@Nonnull SearchParameterMap theParams, RequestDetails theRequest) {
        theParams.values().forEach(nextAndList -> this.ensureSubListsAreWritable((List)nextAndList));
        List activeUniqueSearchParams = this.mySearchParamRegistry.getActiveComboSearchParams(this.myResourceName, theParams.keySet());
        if (activeUniqueSearchParams.size() > 0) {
            Validate.isTrue((((RuntimeSearchParam)activeUniqueSearchParams.get(0)).getComboSearchParamType() == ComboSearchParamType.UNIQUE ? 1 : 0) != 0, (String)"Non unique combo parameters are not supported with the legacy search builder", (Object[])new Object[0]);
            StringBuilder sb = new StringBuilder();
            sb.append(this.myResourceName);
            sb.append("?");
            boolean first = true;
            ArrayList keys = new ArrayList(theParams.keySet());
            Collections.sort(keys);
            for (String nextParamName : keys) {
                ReferenceParam param;
                List nextValues = theParams.get(nextParamName);
                nextParamName = UrlUtil.escapeUrlParam((String)nextParamName);
                if (((List)nextValues.get(0)).size() != 1) {
                    sb = null;
                    break;
                }
                RuntimeSearchParam nextParamDef = this.mySearchParamRegistry.getActiveSearchParam(this.myResourceName, nextParamName);
                if (nextParamDef.getParamType() == RestSearchParameterTypeEnum.REFERENCE && StringUtils.isBlank((CharSequence)(param = (ReferenceParam)((List)nextValues.get(0)).get(0)).getResourceType())) {
                    sb = null;
                    break;
                }
                List nextAnd = (List)nextValues.remove(0);
                IQueryParameterType nextOr = (IQueryParameterType)nextAnd.remove(0);
                String nextOrValue = nextOr.getValueAsQueryToken(this.myContext);
                nextOrValue = UrlUtil.escapeUrlParam((String)nextOrValue);
                if (first) {
                    first = false;
                } else {
                    sb.append('&');
                }
                sb.append(nextParamName).append('=').append(nextOrValue);
            }
            if (sb != null) {
                String indexString = sb.toString();
                ourLog.debug("Checking for unique index for query: {}", (Object)indexString);
                StorageProcessingMessage msg = new StorageProcessingMessage().setMessage("Using unique index for query for search: " + indexString);
                HookParams params = new HookParams().add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest).add(StorageProcessingMessage.class, (Object)msg);
                CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest, (Pointcut)Pointcut.JPA_PERFTRACE_INFO, (HookParams)params);
                this.addPredicateCompositeStringUnique(theParams, indexString, this.myRequestPartitionId);
            }
        }
    }

    private <T> void ensureSubListsAreWritable(List<List<T>> theListOfLists) {
        for (int i = 0; i < theListOfLists.size(); ++i) {
            List<T> oldSubList = theListOfLists.get(i);
            if (oldSubList instanceof ArrayList) continue;
            ArrayList<T> newSubList = new ArrayList<T>(oldSubList);
            theListOfLists.set(i, newSubList);
        }
    }

    private void addPredicateCompositeStringUnique(@Nonnull SearchParameterMap theParams, String theIndexedString, RequestPartitionId theRequestPartitionId) {
        From join = this.myQueryStack.createJoin(SearchBuilderJoinEnum.COMPOSITE_UNIQUE, null);
        if (!theRequestPartitionId.isAllPartitions()) {
            Integer partitionId = theRequestPartitionId.getFirstPartitionIdOrNull();
            Predicate predicate = this.myCriteriaBuilder.equal(join.get("myPartitionIdValue").as(Integer.class), (Object)partitionId);
            this.myQueryStack.addPredicate(predicate);
        }
        Predicate predicate = this.myCriteriaBuilder.equal((Expression)join.get("myIndexString"), (Object)theIndexedString);
        this.myQueryStack.addPredicateWithImplicitTypeSelection(predicate);
        theParams.clean();
    }

    @Override
    public void setFetchSize(int theFetchSize) {
        this.myFetchSize = theFetchSize;
    }

    @VisibleForTesting
    void setParamsForUnitTest(SearchParameterMap theParams) {
        this.myParams = theParams;
    }

    public SearchParameterMap getParams() {
        return this.myParams;
    }

    @VisibleForTesting
    void setEntityManagerForUnitTest(EntityManager theEntityManager) {
        this.myEntityManager = theEntityManager;
    }

    public CriteriaBuilder getBuilder() {
        return this.myCriteriaBuilder;
    }

    public QueryStack getQueryStack() {
        return this.myQueryStack;
    }

    public Class<? extends IBaseResource> getResourceType() {
        return this.myResourceType;
    }

    public String getResourceName() {
        return this.myResourceName;
    }

    @VisibleForTesting
    public void setDaoConfigForUnitTest(DaoConfig theDaoConfig) {
        this.myDaoConfig = theDaoConfig;
    }

    private List<Predicate> createLastUpdatedPredicates(DateRangeParam theLastUpdated, CriteriaBuilder builder) {
        ArrayList<Predicate> lastUpdatedPredicates = new ArrayList<Predicate>();
        if (theLastUpdated != null) {
            if (theLastUpdated.getLowerBoundAsInstant() != null) {
                ourLog.debug("LastUpdated lower bound: {}", (Object)new InstantDt(theLastUpdated.getLowerBoundAsInstant()));
                Predicate predicateLower = builder.greaterThanOrEqualTo(this.myQueryStack.getLastUpdatedColumn(), (Comparable)theLastUpdated.getLowerBoundAsInstant());
                lastUpdatedPredicates.add(predicateLower);
            }
            if (theLastUpdated.getUpperBoundAsInstant() != null) {
                ourLog.debug("LastUpdated upper bound: {}", (Object)new InstantDt(theLastUpdated.getUpperBoundAsInstant()));
                Predicate predicateUpper = builder.lessThanOrEqualTo(this.myQueryStack.getLastUpdatedColumn(), (Comparable)theLastUpdated.getUpperBoundAsInstant());
                lastUpdatedPredicates.add(predicateUpper);
            }
        }
        return lastUpdatedPredicates;
    }

    private static List<Predicate> createLastUpdatedPredicates(DateRangeParam theLastUpdated, CriteriaBuilder builder, From<?, ResourceTable> from) {
        ArrayList<Predicate> lastUpdatedPredicates = new ArrayList<Predicate>();
        if (theLastUpdated != null) {
            if (theLastUpdated.getLowerBoundAsInstant() != null) {
                ourLog.debug("LastUpdated lower bound: {}", (Object)new InstantDt(theLastUpdated.getLowerBoundAsInstant()));
                Predicate predicateLower = builder.greaterThanOrEqualTo((Expression)from.get("myUpdated"), (Comparable)theLastUpdated.getLowerBoundAsInstant());
                lastUpdatedPredicates.add(predicateLower);
            }
            if (theLastUpdated.getUpperBoundAsInstant() != null) {
                Predicate predicateUpper = builder.lessThanOrEqualTo((Expression)from.get("myUpdated"), (Comparable)theLastUpdated.getUpperBoundAsInstant());
                lastUpdatedPredicates.add(predicateUpper);
            }
        }
        return lastUpdatedPredicates;
    }

    private static List<ResourcePersistentId> filterResourceIdsByLastUpdated(EntityManager theEntityManager, DateRangeParam theLastUpdated, Collection<ResourcePersistentId> thePids) {
        if (thePids.isEmpty()) {
            return Collections.emptyList();
        }
        CriteriaBuilder builder = theEntityManager.getCriteriaBuilder();
        CriteriaQuery cq = builder.createQuery(Long.class);
        Root from = cq.from(ResourceTable.class);
        cq.select((Selection)from.get("myId").as(Long.class));
        List<Predicate> lastUpdatedPredicates = LegacySearchBuilder.createLastUpdatedPredicates(theLastUpdated, builder, from);
        lastUpdatedPredicates.add(from.get("myId").as(Long.class).in((Collection)ResourcePersistentId.toLongList(thePids)));
        cq.where(LegacySearchBuilder.toPredicateArray(lastUpdatedPredicates));
        TypedQuery query = theEntityManager.createQuery(cq);
        return ResourcePersistentId.fromLongList((List)query.getResultList());
    }

    public static Predicate[] toPredicateArray(List<Predicate> thePredicates) {
        return thePredicates.toArray(new Predicate[0]);
    }

    private static class CountQueryIterator
    implements Iterator<Long> {
        private final TypedQuery<Long> myQuery;
        private boolean myCountLoaded;
        private Long myCount;

        CountQueryIterator(TypedQuery<Long> theQuery) {
            this.myQuery = theQuery;
        }

        @Override
        public boolean hasNext() {
            boolean retVal;
            boolean bl = retVal = this.myCount != null;
            if (!retVal && !this.myCountLoaded) {
                this.myCount = (Long)this.myQuery.getSingleResult();
                retVal = true;
                this.myCountLoaded = true;
            }
            return retVal;
        }

        @Override
        public Long next() {
            Validate.isTrue((boolean)this.hasNext());
            Validate.isTrue((this.myCount != null ? 1 : 0) != 0);
            Long retVal = this.myCount;
            this.myCount = null;
            return retVal;
        }
    }

    private final class QueryIterator
    extends BaseIterator<ResourcePersistentId>
    implements IResultIterator {
        private final SearchRuntimeDetails mySearchRuntimeDetails;
        private final RequestDetails myRequest;
        private final boolean myHaveRawSqlHooks;
        private final boolean myHavePerfTraceFoundIdHook;
        private boolean myFirst = true;
        private IncludesIterator myIncludesIterator;
        private ResourcePersistentId myNext;
        private Iterator<ResourcePersistentId> myPreResultsIterator;
        private ScrollableResultsIterator<Long> myResultsIterator;
        private Integer myOffset;
        private final SortSpec mySort;
        private boolean myStillNeedToFetchIncludes;
        private int mySkipCount = 0;
        private int myNonSkipCount = 0;
        private List<TypedQuery<Long>> myQueryList = new ArrayList<TypedQuery<Long>>();

        private QueryIterator(SearchRuntimeDetails theSearchRuntimeDetails, RequestDetails theRequest) {
            this.mySearchRuntimeDetails = theSearchRuntimeDetails;
            this.mySort = LegacySearchBuilder.this.myParams.getSort();
            this.myOffset = LegacySearchBuilder.this.myParams.getOffset();
            this.myRequest = theRequest;
            if (LegacySearchBuilder.this.myParams.getEverythingMode() != null) {
                this.myStillNeedToFetchIncludes = true;
            }
            this.myHavePerfTraceFoundIdHook = CompositeInterceptorBroadcaster.hasHooks((Pointcut)Pointcut.JPA_PERFTRACE_SEARCH_FOUND_ID, (IInterceptorBroadcaster)LegacySearchBuilder.this.myInterceptorBroadcaster, (RequestDetails)this.myRequest);
            this.myHaveRawSqlHooks = CompositeInterceptorBroadcaster.hasHooks((Pointcut)Pointcut.JPA_PERFTRACE_RAW_SQL, (IInterceptorBroadcaster)LegacySearchBuilder.this.myInterceptorBroadcaster, (RequestDetails)this.myRequest);
        }

        private boolean isPagingProviderDatabaseBacked() {
            if (this.myRequest == null || this.myRequest.getServer() == null) {
                return false;
            }
            return this.myRequest.getServer().getPagingProvider() instanceof DatabaseBackedPagingProvider;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fetchNext() {
            HookParams params;
            HookParams params2;
            try {
                if (this.myHaveRawSqlHooks) {
                    CurrentThreadCaptureQueriesListener.startCapturing();
                }
                if (this.myResultsIterator == null) {
                    if (LegacySearchBuilder.this.myMaxResultsToFetch == null) {
                        if (LegacySearchBuilder.this.myParams.getLoadSynchronousUpTo() != null) {
                            LegacySearchBuilder.this.myMaxResultsToFetch = LegacySearchBuilder.this.myParams.getLoadSynchronousUpTo();
                        } else if (LegacySearchBuilder.this.myParams.getCount() != null) {
                            LegacySearchBuilder.this.myMaxResultsToFetch = LegacySearchBuilder.this.myParams.getCount();
                        } else {
                            LegacySearchBuilder.this.myMaxResultsToFetch = LegacySearchBuilder.this.myDaoConfig.getFetchSizeDefaultMaximum();
                        }
                    }
                    this.initializeIteratorQuery(this.myOffset, LegacySearchBuilder.this.myMaxResultsToFetch);
                    if (LegacySearchBuilder.this.myAlsoIncludePids != null) {
                        this.myPreResultsIterator = LegacySearchBuilder.this.myAlsoIncludePids.iterator();
                    }
                }
                if (this.myNext == null) {
                    ResourcePersistentId next;
                    if (this.myPreResultsIterator != null && this.myPreResultsIterator.hasNext()) {
                        while (this.myPreResultsIterator.hasNext()) {
                            next = this.myPreResultsIterator.next();
                            if (next == null || !LegacySearchBuilder.this.myPidSet.add(next)) continue;
                            this.myNext = next;
                            break;
                        }
                    }
                    if (this.myNext == null) {
                        while (this.myResultsIterator.hasNext() || !this.myQueryList.isEmpty()) {
                            if (!this.myResultsIterator.hasNext()) {
                                this.retrieveNextIteratorQuery();
                            }
                            Long nextLong = this.myResultsIterator.next();
                            if (this.myHavePerfTraceFoundIdHook) {
                                params2 = new HookParams().add(Integer.class, (Object)System.identityHashCode(this)).add(Object.class, (Object)nextLong);
                                CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)LegacySearchBuilder.this.myInterceptorBroadcaster, (RequestDetails)this.myRequest, (Pointcut)Pointcut.JPA_PERFTRACE_SEARCH_FOUND_ID, (HookParams)params2);
                            }
                            if (nextLong != null) {
                                ResourcePersistentId next2 = new ResourcePersistentId((Object)nextLong);
                                if (LegacySearchBuilder.this.myPidSet.add(next2)) {
                                    this.myNext = next2;
                                    ++this.myNonSkipCount;
                                    break;
                                }
                                ++this.mySkipCount;
                            }
                            if (this.myResultsIterator.hasNext() || LegacySearchBuilder.this.myMaxResultsToFetch == null || this.mySkipCount + this.myNonSkipCount != LegacySearchBuilder.this.myMaxResultsToFetch || this.mySkipCount <= 0 || this.myNonSkipCount != 0) continue;
                            LegacySearchBuilder.this.myMaxResultsToFetch = LegacySearchBuilder.this.myMaxResultsToFetch + 1000;
                            StorageProcessingMessage message = new StorageProcessingMessage();
                            String msg = "Pass completed with no matching results. This indicates an inefficient query! Retrying with new max count of " + LegacySearchBuilder.this.myMaxResultsToFetch;
                            ourLog.warn(msg);
                            message.setMessage(msg);
                            HookParams params3 = new HookParams().add(RequestDetails.class, (Object)this.myRequest).addIfMatchesType(ServletRequestDetails.class, (Object)this.myRequest).add(StorageProcessingMessage.class, (Object)message);
                            CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)LegacySearchBuilder.this.myInterceptorBroadcaster, (RequestDetails)this.myRequest, (Pointcut)Pointcut.JPA_PERFTRACE_WARNING, (HookParams)params3);
                            this.initializeIteratorQuery(null, LegacySearchBuilder.this.myMaxResultsToFetch);
                        }
                    }
                    if (this.myNext == null) {
                        if (this.myStillNeedToFetchIncludes) {
                            this.myIncludesIterator = new IncludesIterator(LegacySearchBuilder.this.myPidSet, this.myRequest);
                            this.myStillNeedToFetchIncludes = false;
                        }
                        if (this.myIncludesIterator != null) {
                            while (this.myIncludesIterator.hasNext()) {
                                next = this.myIncludesIterator.next();
                                if (next == null || !LegacySearchBuilder.this.myPidSet.add(next)) continue;
                                this.myNext = next;
                                break;
                            }
                            if (this.myNext == null) {
                                this.myNext = NO_MORE;
                            }
                        } else {
                            this.myNext = NO_MORE;
                        }
                    }
                }
                this.mySearchRuntimeDetails.setFoundMatchesCount(LegacySearchBuilder.this.myPidSet.size());
            }
            finally {
                if (this.myHaveRawSqlHooks) {
                    SqlQueryList capturedQueries = CurrentThreadCaptureQueriesListener.getCurrentQueueAndStopCapturing();
                    params2 = new HookParams().add(RequestDetails.class, (Object)this.myRequest).addIfMatchesType(ServletRequestDetails.class, (Object)this.myRequest).add(SqlQueryList.class, (Object)capturedQueries);
                    CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)LegacySearchBuilder.this.myInterceptorBroadcaster, (RequestDetails)this.myRequest, (Pointcut)Pointcut.JPA_PERFTRACE_RAW_SQL, (HookParams)params2);
                }
            }
            if (this.myFirst) {
                params = new HookParams().add(RequestDetails.class, (Object)this.myRequest).addIfMatchesType(ServletRequestDetails.class, (Object)this.myRequest).add(SearchRuntimeDetails.class, (Object)this.mySearchRuntimeDetails);
                CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)LegacySearchBuilder.this.myInterceptorBroadcaster, (RequestDetails)this.myRequest, (Pointcut)Pointcut.JPA_PERFTRACE_SEARCH_FIRST_RESULT_LOADED, (HookParams)params);
                this.myFirst = false;
            }
            if (NO_MORE.equals((Object)this.myNext)) {
                params = new HookParams().add(RequestDetails.class, (Object)this.myRequest).addIfMatchesType(ServletRequestDetails.class, (Object)this.myRequest).add(SearchRuntimeDetails.class, (Object)this.mySearchRuntimeDetails);
                CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)LegacySearchBuilder.this.myInterceptorBroadcaster, (RequestDetails)this.myRequest, (Pointcut)Pointcut.JPA_PERFTRACE_SEARCH_SELECT_COMPLETE, (HookParams)params);
            }
        }

        private void initializeIteratorQuery(Integer theOffset, Integer theMaxResultsToFetch) {
            if (this.myQueryList.isEmpty()) {
                this.mySearchRuntimeDetails.setQueryStopwatch(new StopWatch());
                this.myQueryList = LegacySearchBuilder.this.createQuery(this.mySort, theOffset, theMaxResultsToFetch, false, this.myRequest, this.mySearchRuntimeDetails);
            }
            this.mySearchRuntimeDetails.setQueryStopwatch(new StopWatch());
            this.retrieveNextIteratorQuery();
            this.mySkipCount = 0;
            this.myNonSkipCount = 0;
        }

        private void retrieveNextIteratorQuery() {
            if (this.myQueryList != null && this.myQueryList.size() > 0) {
                TypedQuery<Long> query = this.myQueryList.remove(0);
                Query hibernateQuery = (Query)query;
                hibernateQuery.setFetchSize(LegacySearchBuilder.this.myFetchSize);
                ScrollableResults scroll = hibernateQuery.scroll(ScrollMode.FORWARD_ONLY);
                this.myResultsIterator = new ScrollableResultsIterator(scroll);
            } else {
                this.myResultsIterator = null;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.myNext == null) {
                this.fetchNext();
            }
            return !NO_MORE.equals((Object)this.myNext);
        }

        @Override
        public ResourcePersistentId next() {
            this.fetchNext();
            ResourcePersistentId retVal = this.myNext;
            this.myNext = null;
            Validate.isTrue((!NO_MORE.equals((Object)retVal) ? 1 : 0) != 0, (String)"No more elements", (Object[])new Object[0]);
            return retVal;
        }

        @Override
        public int getSkippedCount() {
            return this.mySkipCount;
        }

        @Override
        public int getNonSkippedCount() {
            return this.myNonSkipCount;
        }

        @Override
        public Collection<ResourcePersistentId> getNextResultBatch(long theBatchSize) {
            ArrayList<ResourcePersistentId> batch = new ArrayList<ResourcePersistentId>();
            while (this.hasNext() && (long)batch.size() < theBatchSize) {
                batch.add(this.next());
            }
            return batch;
        }

        @Override
        public void close() {
            if (this.myResultsIterator != null) {
                this.myResultsIterator.close();
            }
        }
    }

    public class IncludesIterator
    extends BaseIterator<ResourcePersistentId>
    implements Iterator<ResourcePersistentId> {
        private final RequestDetails myRequest;
        private Iterator<ResourcePersistentId> myCurrentIterator;
        private final Set<ResourcePersistentId> myCurrentPids;
        private ResourcePersistentId myNext;

        IncludesIterator(Set<ResourcePersistentId> thePidSet, RequestDetails theRequest) {
            this.myCurrentPids = new HashSet<ResourcePersistentId>(thePidSet);
            this.myCurrentIterator = EMPTY_LONG_LIST.iterator();
            this.myRequest = theRequest;
        }

        private void fetchNext() {
            while (this.myNext == null) {
                if (this.myCurrentIterator.hasNext()) {
                    this.myNext = this.myCurrentIterator.next();
                    break;
                }
                Set<Include> includes = Collections.singleton(new Include("*", true));
                Set newPids = LegacySearchBuilder.this.loadIncludes(LegacySearchBuilder.this.myContext, LegacySearchBuilder.this.myEntityManager, this.myCurrentPids, (Set)includes, false, LegacySearchBuilder.this.getParams().getLastUpdated(), LegacySearchBuilder.this.mySearchUuid, this.myRequest, (Integer)null);
                if (newPids.isEmpty()) {
                    this.myNext = NO_MORE;
                    break;
                }
                this.myCurrentPids.addAll(newPids);
                this.myCurrentIterator = newPids.iterator();
            }
        }

        @Override
        public boolean hasNext() {
            this.fetchNext();
            return !NO_MORE.equals((Object)this.myNext);
        }

        @Override
        public ResourcePersistentId next() {
            this.fetchNext();
            ResourcePersistentId retVal = this.myNext;
            this.myNext = null;
            return retVal;
        }
    }
}

