/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.model.search.StorageProcessingMessage;
import ca.uhn.fhir.jpa.searchparam.MatchUrlService;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.util.MemoryCacheService;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.util.CompositeInterceptorBroadcaster;
import ca.uhn.fhir.util.StopWatch;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MatchResourceUrlService {
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private FhirContext myContext;
    @Autowired
    private MatchUrlService myMatchUrlService;
    @Autowired
    private DaoConfig myDaoConfig;
    @Autowired
    private IInterceptorBroadcaster myInterceptorBroadcaster;
    @Autowired
    private MemoryCacheService myMemoryCacheService;

    public <R extends IBaseResource> Set<ResourcePersistentId> processMatchUrl(String theMatchUrl, Class<R> theResourceType, TransactionDetails theTransactionDetails, RequestDetails theRequest) {
        return this.processMatchUrl(theMatchUrl, theResourceType, theTransactionDetails, theRequest, null);
    }

    public <R extends IBaseResource> Set<ResourcePersistentId> processMatchUrl(String theMatchUrl, Class<R> theResourceType, TransactionDetails theTransactionDetails, RequestDetails theRequest, IBaseResource theConditionalOperationTargetOrNull) {
        String resourceType = this.myContext.getResourceType(theResourceType);
        String matchUrl = this.massageForStorage(resourceType, theMatchUrl);
        ResourcePersistentId resolvedInTransaction = (ResourcePersistentId)theTransactionDetails.getResolvedMatchUrls().get(matchUrl);
        if (resolvedInTransaction != null) {
            if (resolvedInTransaction == TransactionDetails.NOT_FOUND) {
                return Collections.emptySet();
            }
            return Collections.singleton(resolvedInTransaction);
        }
        ResourcePersistentId resolvedInCache = this.processMatchUrlUsingCacheOnly(resourceType, matchUrl);
        if (resolvedInCache != null) {
            return Collections.singleton(resolvedInCache);
        }
        RuntimeResourceDefinition resourceDef = this.myContext.getResourceDefinition(theResourceType);
        SearchParameterMap paramMap = this.myMatchUrlService.translateMatchUrl(matchUrl, resourceDef, new MatchUrlService.Flag[0]);
        if (paramMap.isEmpty() && paramMap.getLastUpdated() == null) {
            throw new InvalidRequestException("Invalid match URL[" + matchUrl + "] - URL has no search parameters");
        }
        paramMap.setLoadSynchronousUpTo(Integer.valueOf(2));
        Set<ResourcePersistentId> retVal = this.search(paramMap, theResourceType, theRequest, theConditionalOperationTargetOrNull);
        if (this.myDaoConfig.isMatchUrlCacheEnabled() && retVal.size() == 1) {
            ResourcePersistentId pid = retVal.iterator().next();
            this.myMemoryCacheService.putAfterCommit(MemoryCacheService.CacheEnum.MATCH_URL, matchUrl, pid);
        }
        return retVal;
    }

    private String massageForStorage(String theResourceType, String theMatchUrl) {
        Validate.notBlank((CharSequence)theMatchUrl, (String)"theMatchUrl must not be null or blank", (Object[])new Object[0]);
        int questionMarkIdx = theMatchUrl.indexOf("?");
        if (questionMarkIdx > 0) {
            return theMatchUrl;
        }
        if (questionMarkIdx == 0) {
            return theResourceType + theMatchUrl;
        }
        return theResourceType + "?" + theMatchUrl;
    }

    @Nullable
    public ResourcePersistentId processMatchUrlUsingCacheOnly(String theResourceType, String theMatchUrl) {
        ResourcePersistentId existing = null;
        if (this.myDaoConfig.getMatchUrlCache()) {
            String matchUrl = this.massageForStorage(theResourceType, theMatchUrl);
            existing = (ResourcePersistentId)this.myMemoryCacheService.getIfPresent(MemoryCacheService.CacheEnum.MATCH_URL, matchUrl);
        }
        return existing;
    }

    public <R extends IBaseResource> Set<ResourcePersistentId> search(SearchParameterMap theParamMap, Class<R> theResourceType, RequestDetails theRequest, @Nullable IBaseResource theConditionalOperationTargetOrNull) {
        StopWatch sw = new StopWatch();
        IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(theResourceType);
        if (dao == null) {
            throw new InternalErrorException("No DAO for resource type: " + theResourceType.getName());
        }
        Set retVal = dao.searchForIds(theParamMap, theRequest, theConditionalOperationTargetOrNull);
        if (CompositeInterceptorBroadcaster.hasHooks((Pointcut)Pointcut.JPA_PERFTRACE_INFO, (IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest)) {
            StorageProcessingMessage message = new StorageProcessingMessage();
            message.setMessage("Processed conditional resource URL with " + retVal.size() + " result(s) in " + sw);
            HookParams params = new HookParams().add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest).add(StorageProcessingMessage.class, (Object)message);
            CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest, (Pointcut)Pointcut.JPA_PERFTRACE_INFO, (HookParams)params);
        }
        return retVal;
    }

    public void matchUrlResolved(TransactionDetails theTransactionDetails, String theResourceType, String theMatchUrl, ResourcePersistentId theResourcePersistentId) {
        Validate.notBlank((CharSequence)theMatchUrl);
        Validate.notNull((Object)theResourcePersistentId);
        String matchUrl = this.massageForStorage(theResourceType, theMatchUrl);
        theTransactionDetails.addResolvedMatchUrl(matchUrl, theResourcePersistentId);
        if (this.myDaoConfig.isMatchUrlCacheEnabled()) {
            this.myMemoryCacheService.putAfterCommit(MemoryCacheService.CacheEnum.MATCH_URL, matchUrl, theResourcePersistentId);
        }
    }
}

