/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.dao.BaseTransactionProcessor;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.dstu2.resource.Bundle;
import ca.uhn.fhir.model.dstu2.resource.OperationOutcome;
import ca.uhn.fhir.model.dstu2.valueset.BundleTypeEnum;
import ca.uhn.fhir.model.dstu2.valueset.HTTPVerbEnum;
import ca.uhn.fhir.model.dstu2.valueset.IssueSeverityEnum;
import ca.uhn.fhir.model.dstu2.valueset.IssueTypeEnum;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class TransactionProcessorVersionAdapterDstu2
implements BaseTransactionProcessor.ITransactionProcessorVersionAdapter<Bundle, Bundle.Entry> {
    @Override
    public void setResponseStatus(Bundle.Entry theBundleEntry, String theStatus) {
        theBundleEntry.getResponse().setStatus(theStatus);
    }

    @Override
    public void setResponseLastModified(Bundle.Entry theBundleEntry, Date theLastModified) {
        theBundleEntry.getResponse().setLastModified(theLastModified, TemporalPrecisionEnum.MILLI);
    }

    @Override
    public void setResource(Bundle.Entry theBundleEntry, IBaseResource theResource) {
        theBundleEntry.setResource((IResource)theResource);
    }

    @Override
    public IBaseResource getResource(Bundle.Entry theBundleEntry) {
        return theBundleEntry.getResource();
    }

    @Override
    public String getBundleType(Bundle theRequest) {
        if (theRequest.getType() == null) {
            return null;
        }
        return (String)theRequest.getTypeElement().getValue();
    }

    @Override
    public void populateEntryWithOperationOutcome(BaseServerResponseException theCaughtEx, Bundle.Entry theEntry) {
        OperationOutcome oo = new OperationOutcome();
        oo.addIssue().setSeverity(IssueSeverityEnum.ERROR).setDiagnostics(theCaughtEx.getMessage()).setCode(IssueTypeEnum.EXCEPTION);
        theEntry.setResource((IResource)oo);
    }

    @Override
    public Bundle createBundle(String theBundleType) {
        Bundle resp = new Bundle();
        try {
            resp.setType(BundleTypeEnum.forCode((String)theBundleType));
        }
        catch (FHIRException theE) {
            throw new InternalErrorException("Unknown bundle type: " + theBundleType);
        }
        return resp;
    }

    @Override
    public List<Bundle.Entry> getEntries(Bundle theRequest) {
        return theRequest.getEntry();
    }

    @Override
    public void addEntry(Bundle theBundle, Bundle.Entry theEntry) {
        theBundle.addEntry(theEntry);
    }

    @Override
    public Bundle.Entry addEntry(Bundle theBundle) {
        return theBundle.addEntry();
    }

    @Override
    public String getEntryRequestVerb(FhirContext theContext, Bundle.Entry theEntry) {
        String retVal = null;
        HTTPVerbEnum value = (HTTPVerbEnum)theEntry.getRequest().getMethodElement().getValueAsEnum();
        if (value != null) {
            retVal = value.getCode();
        }
        return retVal;
    }

    @Override
    public String getFullUrl(Bundle.Entry theEntry) {
        return theEntry.getFullUrl();
    }

    @Override
    public String getEntryIfNoneExist(Bundle.Entry theEntry) {
        return theEntry.getRequest().getIfNoneExist();
    }

    @Override
    public String getEntryRequestUrl(Bundle.Entry theEntry) {
        return theEntry.getRequest().getUrl();
    }

    @Override
    public void setResponseLocation(Bundle.Entry theEntry, String theResponseLocation) {
        theEntry.getResponse().setLocation(theResponseLocation);
    }

    @Override
    public void setResponseETag(Bundle.Entry theEntry, String theEtag) {
        theEntry.getResponse().setEtag(theEtag);
    }

    @Override
    public String getEntryRequestIfMatch(Bundle.Entry theEntry) {
        return theEntry.getRequest().getIfMatch();
    }

    @Override
    public String getEntryRequestIfNoneExist(Bundle.Entry theEntry) {
        return theEntry.getRequest().getIfNoneExist();
    }

    @Override
    public String getEntryRequestIfNoneMatch(Bundle.Entry theEntry) {
        return theEntry.getRequest().getIfNoneMatch();
    }

    @Override
    public void setResponseOutcome(Bundle.Entry theEntry, IBaseOperationOutcome theOperationOutcome) {
        theEntry.setResource((IResource)theOperationOutcome);
    }

    @Override
    public void setRequestVerb(Bundle.Entry theEntry, String theVerb) {
        theEntry.getRequest().setMethod(HTTPVerbEnum.forCode((String)theVerb));
    }

    @Override
    public void setRequestUrl(Bundle.Entry theEntry, String theUrl) {
        theEntry.getRequest().setUrl(theUrl);
    }
}

