/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.data;

import ca.uhn.fhir.jpa.model.entity.ForcedId;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface IForcedIdDao
extends JpaRepository<ForcedId, Long> {
    @Query(value="SELECT f FROM ForcedId f WHERE myResourcePid IN (:resource_pids)")
    public List<ForcedId> findAllByResourcePid(@Param(value="resource_pids") List<Long> var1);

    @Query(value="SELECT f.myResourcePid FROM ForcedId f WHERE myForcedId IN (:forced_id)")
    public List<Long> findByForcedId(@Param(value="forced_id") Collection<String> var1);

    @Query(value="SELECT f.myResourcePid FROM ForcedId f WHERE myResourceType = :resource_type AND myForcedId = :forced_id")
    public Optional<Long> findByTypeAndForcedId(@Param(value="resource_type") String var1, @Param(value="forced_id") String var2);

    @Query(value="SELECT f.myResourcePid FROM ForcedId f WHERE myPartitionId.myPartitionId IS NULL AND myResourceType = :resource_type AND myForcedId = :forced_id")
    public Optional<Long> findByPartitionIdNullAndTypeAndForcedId(@Param(value="resource_type") String var1, @Param(value="forced_id") String var2);

    @Query(value="SELECT f.myResourcePid FROM ForcedId f WHERE myPartitionId.myPartitionId IN :partition_id AND myResourceType = :resource_type AND myForcedId = :forced_id")
    public Optional<Long> findByPartitionIdAndTypeAndForcedId(@Param(value="partition_id") Collection<Integer> var1, @Param(value="resource_type") String var2, @Param(value="forced_id") String var3);

    @Query(value="SELECT f.myResourcePid FROM ForcedId f WHERE (myPartitionId.myPartitionId IN :partition_id OR myPartitionId.myPartitionId IS NULL) AND myResourceType = :resource_type AND myForcedId = :forced_id")
    public Optional<Long> findByPartitionIdOrNullAndTypeAndForcedId(@Param(value="partition_id") Collection<Integer> var1, @Param(value="resource_type") String var2, @Param(value="forced_id") String var3);

    @Query(value="SELECT f FROM ForcedId f WHERE f.myResourcePid = :resource_pid")
    public Optional<ForcedId> findByResourcePid(@Param(value="resource_pid") Long var1);

    @Modifying
    @Query(value="DELETE FROM ForcedId t WHERE t.myId = :pid")
    public void deleteByPid(@Param(value="pid") Long var1);

    @Query(value="SELECT f.myForcedId, f.myResourcePid FROM ForcedId f WHERE myResourceType = :resource_type AND myForcedId IN ( :forced_id )")
    public Collection<Object[]> findByTypeAndForcedId(@Param(value="resource_type") String var1, @Param(value="forced_id") Collection<String> var2);

    @Query(value="SELECT f.myForcedId, f.myResourcePid FROM ForcedId f WHERE myPartitionIdValue IN ( :partition_id ) AND myResourceType = :resource_type AND myForcedId IN ( :forced_id )")
    public Collection<Object[]> findByTypeAndForcedIdInPartitionIds(@Param(value="resource_type") String var1, @Param(value="forced_id") Collection<String> var2, @Param(value="partition_id") Collection<Integer> var3);

    @Query(value="SELECT f.myForcedId, f.myResourcePid FROM ForcedId f WHERE (myPartitionIdValue IS NULL OR myPartitionIdValue IN ( :partition_id )) AND myResourceType = :resource_type AND myForcedId IN ( :forced_id )")
    public Collection<Object[]> findByTypeAndForcedIdInPartitionIdsOrNullPartition(@Param(value="resource_type") String var1, @Param(value="forced_id") Collection<String> var2, @Param(value="partition_id") Collection<Integer> var3);

    @Query(value="SELECT f.myForcedId, f.myResourcePid FROM ForcedId f WHERE myPartitionIdValue IS NULL AND myResourceType = :resource_type AND myForcedId IN ( :forced_id )")
    public Collection<Object[]> findByTypeAndForcedIdInPartitionNull(@Param(value="resource_type") String var1, @Param(value="forced_id") Collection<String> var2);

    @Query(value="SELECT    f.myResourceType, f.myResourcePid, f.myForcedId, t.myDeleted FROM ForcedId f JOIN ResourceTable t ON t.myId = f.myResourcePid WHERE f.myForcedId IN ( :forced_id )")
    public Collection<Object[]> findAndResolveByForcedIdWithNoType(@Param(value="forced_id") Collection<String> var1);

    @Query(value="SELECT    f.myResourceType, f.myResourcePid, f.myForcedId, t.myDeleted FROM ForcedId f JOIN ResourceTable t ON t.myId = f.myResourcePid WHERE f.myResourceType = :resource_type AND f.myForcedId IN ( :forced_id )")
    public Collection<Object[]> findAndResolveByForcedIdWithNoType(@Param(value="resource_type") String var1, @Param(value="forced_id") Collection<String> var2);

    @Query(value="SELECT    f.myResourceType, f.myResourcePid, f.myForcedId, t.myDeleted FROM ForcedId f JOIN ResourceTable t ON t.myId = f.myResourcePid WHERE f.myResourceType = :resource_type AND f.myForcedId IN ( :forced_id ) AND f.myPartitionIdValue IN :partition_id")
    public Collection<Object[]> findAndResolveByForcedIdWithNoTypeInPartition(@Param(value="resource_type") String var1, @Param(value="forced_id") Collection<String> var2, @Param(value="partition_id") Collection<Integer> var3);

    @Query(value="SELECT    f.myResourceType, f.myResourcePid, f.myForcedId, t.myDeleted FROM ForcedId f JOIN ResourceTable t ON t.myId = f.myResourcePid WHERE f.myResourceType = :resource_type AND f.myForcedId IN ( :forced_id ) AND f.myPartitionIdValue IS NULL")
    public Collection<Object[]> findAndResolveByForcedIdWithNoTypeInPartitionNull(@Param(value="resource_type") String var1, @Param(value="forced_id") Collection<String> var2);

    @Query(value="SELECT    f.myResourceType, f.myResourcePid, f.myForcedId, t.myDeleted FROM ForcedId f JOIN ResourceTable t ON t.myId = f.myResourcePid WHERE f.myResourceType = :resource_type AND f.myForcedId IN ( :forced_id ) AND (f.myPartitionIdValue IS NULL OR f.myPartitionIdValue IN :partition_id)")
    public Collection<Object[]> findAndResolveByForcedIdWithNoTypeInPartitionIdOrNullPartitionId(@Param(value="resource_type") String var1, @Param(value="forced_id") Collection<String> var2, @Param(value="forced_id") List<Integer> var3);
}

