/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.data;

import ca.uhn.fhir.jpa.entity.MdmLink;
import ca.uhn.fhir.mdm.api.MdmMatchResultEnum;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface IMdmLinkDao
extends JpaRepository<MdmLink, Long> {
    @Modifying
    @Query(value="DELETE FROM MdmLink f WHERE myGoldenResourcePid = :pid OR mySourcePid = :pid")
    public int deleteWithAnyReferenceToPid(@Param(value="pid") Long var1);

    @Modifying
    @Query(value="DELETE FROM MdmLink f WHERE (myGoldenResourcePid = :pid OR mySourcePid = :pid) AND myMatchResult <> :matchResult")
    public int deleteWithAnyReferenceToPidAndMatchResultNot(@Param(value="pid") Long var1, @Param(value="matchResult") MdmMatchResultEnum var2);

    @Query(value="SELECT ml2.myGoldenResourcePid as goldenPid, ml2.mySourcePid as sourcePid FROM MdmLink ml2 WHERE ml2.myMatchResult=:matchResult AND ml2.myGoldenResourcePid IN (SELECT ml.myGoldenResourcePid FROM MdmLink ml INNER JOIN ResourceLink hrl ON hrl.myTargetResourcePid=ml.mySourcePid AND hrl.mySourceResourcePid=:groupPid AND hrl.mySourcePath='Group.member.entity' AND hrl.myTargetResourceType='Patient')")
    public List<MdmPidTuple> expandPidsFromGroupPidGivenMatchResult(@Param(value="groupPid") Long var1, @Param(value="matchResult") MdmMatchResultEnum var2);

    @Query(value="SELECT ml.myGoldenResourcePid as goldenPid, ml.mySourcePid as sourcePid FROM MdmLink ml INNER JOIN MdmLink ml2 on ml.myGoldenResourcePid=ml2.myGoldenResourcePid WHERE ml2.mySourcePid=:sourcePid AND ml2.myMatchResult=:matchResult AND ml.myMatchResult=:matchResult")
    public List<MdmPidTuple> expandPidsBySourcePidAndMatchResult(@Param(value="sourcePid") Long var1, @Param(value="matchResult") MdmMatchResultEnum var2);

    @Query(value="SELECT ml.myGoldenResourcePid as goldenPid, ml.mySourcePid as sourcePid FROM MdmLink ml WHERE ml.myGoldenResourcePid = :goldenPid and ml.myMatchResult = :matchResult")
    public List<MdmPidTuple> expandPidsByGoldenResourcePidAndMatchResult(@Param(value="goldenPid") Long var1, @Param(value="matchResult") MdmMatchResultEnum var2);

    public static interface MdmPidTuple {
        public Long getGoldenPid();

        public Long getSourcePid();
    }
}

