/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.data;

import ca.uhn.fhir.jpa.entity.SearchResult;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface ISearchResultDao
extends JpaRepository<SearchResult, Long> {
    @Query(value="SELECT r.myResourcePid FROM SearchResult r WHERE r.mySearchPid = :search ORDER BY r.myOrder ASC")
    public Slice<Long> findWithSearchPid(@Param(value="search") Long var1, Pageable var2);

    @Query(value="SELECT r.myResourcePid FROM SearchResult r WHERE r.mySearchPid = :search")
    public List<Long> findWithSearchPidOrderIndependent(@Param(value="search") Long var1);

    @Query(value="SELECT r.myId FROM SearchResult r WHERE r.mySearchPid = :search")
    public Slice<Long> findForSearch(Pageable var1, @Param(value="search") Long var2);

    @Modifying
    @Query(value="DELETE FROM SearchResult s WHERE s.myId IN :ids")
    public void deleteByIds(@Param(value="ids") List<Long> var1);

    @Query(value="SELECT count(r) FROM SearchResult r WHERE r.mySearchPid = :search")
    public int countForSearch(@Param(value="search") Long var1);
}

