/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.data;

import ca.uhn.fhir.jpa.entity.TermConceptMap;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface ITermConceptMapDao
extends JpaRepository<TermConceptMap, Long> {
    @Query(value="DELETE FROM TermConceptMap cm WHERE cm.myId = :pid")
    @Modifying
    public void deleteTermConceptMapById(@Param(value="pid") Long var1);

    @Query(value="SELECT cm FROM TermConceptMap cm WHERE cm.myResourcePid = :resource_pid")
    public Optional<TermConceptMap> findTermConceptMapByResourcePid(@Param(value="resource_pid") Long var1);

    @Deprecated
    @Query(value="SELECT cm FROM TermConceptMap cm WHERE cm.myUrl = :url and cm.myVersion is null")
    public Optional<TermConceptMap> findTermConceptMapByUrl(@Param(value="url") String var1);

    @Query(value="SELECT cm FROM TermConceptMap cm WHERE cm.myUrl = :url and cm.myVersion is null")
    public Optional<TermConceptMap> findTermConceptMapByUrlAndNullVersion(@Param(value="url") String var1);

    @Query(value="SELECT cm FROM TermConceptMap cm INNER JOIN ResourceTable r ON r.myId = cm.myResourcePid WHERE cm.myUrl = :url ORDER BY r.myUpdated DESC")
    public List<TermConceptMap> getTermConceptMapEntitiesByUrlOrderByMostRecentUpdate(Pageable var1, @Param(value="url") String var2);

    @Query(value="SELECT cm FROM TermConceptMap cm WHERE cm.myUrl = :url AND cm.myVersion = :version")
    public Optional<TermConceptMap> findTermConceptMapByUrlAndVersion(@Param(value="url") String var1, @Param(value="version") String var2);
}

