/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.dstu3;

import ca.uhn.fhir.jpa.api.dao.IFhirResourceDaoSearchParameter;
import ca.uhn.fhir.jpa.dao.BaseHapiFhirResourceDao;
import ca.uhn.fhir.jpa.dao.r4.FhirResourceDaoSearchParameterR4;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.searchparam.extractor.ISearchParamExtractor;
import org.hl7.fhir.convertors.advisors.impl.BaseAdvisor_30_40;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_30_40;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.r4.model.SearchParameter;
import org.springframework.beans.factory.annotation.Autowired;

public class FhirResourceDaoSearchParameterDstu3
extends BaseHapiFhirResourceDao<org.hl7.fhir.dstu3.model.SearchParameter>
implements IFhirResourceDaoSearchParameter<org.hl7.fhir.dstu3.model.SearchParameter> {
    @Autowired
    private ISearchParamExtractor mySearchParamExtractor;

    protected void markAffectedResources(org.hl7.fhir.dstu3.model.SearchParameter theResource) {
        Boolean reindex = theResource != null ? CURRENTLY_REINDEXING.get((IAnyResource)theResource) : null;
        String expression = theResource != null ? theResource.getExpression() : null;
        this.markResourcesMatchingExpressionAsNeedingReindexing(reindex, expression);
    }

    @Override
    protected void postPersist(ResourceTable theEntity, org.hl7.fhir.dstu3.model.SearchParameter theResource) {
        super.postPersist(theEntity, theResource);
        this.markAffectedResources(theResource);
    }

    @Override
    protected void postUpdate(ResourceTable theEntity, org.hl7.fhir.dstu3.model.SearchParameter theResource) {
        super.postUpdate(theEntity, theResource);
        this.markAffectedResources(theResource);
    }

    @Override
    protected void preDelete(org.hl7.fhir.dstu3.model.SearchParameter theResourceToDelete, ResourceTable theEntityToDelete) {
        super.preDelete(theResourceToDelete, theEntityToDelete);
        this.markAffectedResources(theResourceToDelete);
    }

    @Override
    protected void validateResourceForStorage(org.hl7.fhir.dstu3.model.SearchParameter theResource, ResourceTable theEntityToSave) {
        super.validateResourceForStorage(theResource, theEntityToSave);
        FhirResourceDaoSearchParameterR4.validateSearchParam((SearchParameter)VersionConvertorFactory_30_40.convertResource((Resource)theResource, (BaseAdvisor_30_40)new BaseAdvisor_30_40(Boolean.valueOf(false))), this.getContext(), this.getConfig(), this.mySearchParamRegistry, this.mySearchParamExtractor);
    }
}

