/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.dstu3;

import ca.uhn.fhir.jpa.dao.BaseHapiFhirSystemDao;
import ca.uhn.fhir.jpa.dao.FhirResourceDaoMessageHeaderDstu2;
import ca.uhn.fhir.jpa.model.entity.TagDefinition;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.interceptor.IServerInterceptor;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.persistence.TypedQuery;
import org.hl7.fhir.dstu3.model.Bundle;
import org.hl7.fhir.dstu3.model.Meta;
import org.hl7.fhir.instance.model.api.IBaseBundle;

public class FhirSystemDaoDstu3
extends BaseHapiFhirSystemDao<Bundle, Meta> {
    @Override
    @PostConstruct
    public void start() {
        super.start();
    }

    public Meta metaGetOperation(RequestDetails theRequestDetails) {
        IServerInterceptor.ActionRequestDetails requestDetails = new IServerInterceptor.ActionRequestDetails(theRequestDetails);
        this.notifyInterceptors(RestOperationTypeEnum.META, requestDetails);
        String sql = "SELECT d FROM TagDefinition d WHERE d.myId IN (SELECT DISTINCT t.myTagId FROM ResourceTag t)";
        TypedQuery q = this.myEntityManager.createQuery(sql, TagDefinition.class);
        List tagDefinitions = q.getResultList();
        return this.toMeta(tagDefinitions);
    }

    private Meta toMeta(Collection<TagDefinition> tagDefinitions) {
        Meta retVal = new Meta();
        for (TagDefinition next : tagDefinitions) {
            switch (next.getTagType()) {
                case PROFILE: {
                    retVal.addProfile(next.getCode());
                    break;
                }
                case SECURITY_LABEL: {
                    retVal.addSecurity().setSystem(next.getSystem()).setCode(next.getCode()).setDisplay(next.getDisplay());
                    break;
                }
                case TAG: {
                    retVal.addTag().setSystem(next.getSystem()).setCode(next.getCode()).setDisplay(next.getDisplay());
                }
            }
        }
        return retVal;
    }

    public IBaseBundle processMessage(RequestDetails theRequestDetails, IBaseBundle theMessage) {
        return FhirResourceDaoMessageHeaderDstu2.throwProcessMessageNotImplemented();
    }
}

