/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.expunge;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.api.model.DeleteMethodOutcome;
import ca.uhn.fhir.jpa.dao.BaseHapiFhirResourceDao;
import ca.uhn.fhir.jpa.dao.data.IResourceLinkDao;
import ca.uhn.fhir.jpa.dao.expunge.PartitionRunner;
import ca.uhn.fhir.jpa.dao.expunge.ResourceForeignKey;
import ca.uhn.fhir.jpa.dao.expunge.ResourceTableFKProvider;
import ca.uhn.fhir.jpa.dao.index.IdHelperService;
import ca.uhn.fhir.jpa.model.entity.ResourceLink;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.util.CompositeInterceptorBroadcaster;
import ca.uhn.fhir.util.OperationOutcomeUtil;
import ca.uhn.fhir.util.StopWatch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Slice;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Service
@Deprecated
public class DeleteExpungeService {
    private static final Logger ourLog = LoggerFactory.getLogger(DeleteExpungeService.class);
    @Autowired
    protected PlatformTransactionManager myPlatformTransactionManager;
    @PersistenceContext(type=PersistenceContextType.TRANSACTION)
    private EntityManager myEntityManager;
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private ResourceTableFKProvider myResourceTableFKProvider;
    @Autowired
    private IResourceLinkDao myResourceLinkDao;
    @Autowired
    private IInterceptorBroadcaster myInterceptorBroadcaster;
    @Autowired
    private DaoConfig myDaoConfig;
    @Autowired
    private IdHelperService myIdHelper;

    public DeleteMethodOutcome expungeByResourcePids(String theUrl, String theResourceName, Slice<Long> thePids, RequestDetails theRequest) {
        String message;
        IBaseOperationOutcome oo;
        StopWatch w = new StopWatch();
        if (thePids.isEmpty()) {
            return new DeleteMethodOutcome();
        }
        HookParams params = new HookParams().add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest).add(String.class, (Object)theUrl);
        CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest, (Pointcut)Pointcut.STORAGE_PRE_DELETE_EXPUNGE, (HookParams)params);
        TransactionTemplate txTemplate = new TransactionTemplate(this.myPlatformTransactionManager);
        txTemplate.executeWithoutResult(t -> this.validateOkToDeleteAndExpunge(thePids));
        ourLog.info("Expunging all records linking to {} resources...", (Object)thePids.getNumber());
        AtomicLong expungedEntitiesCount = new AtomicLong();
        AtomicLong expungedResourcesCount = new AtomicLong();
        PartitionRunner partitionRunner = new PartitionRunner("Delete Expunging", "delete-expunge", this.myDaoConfig.getExpungeBatchSize(), this.myDaoConfig.getExpungeThreadCount());
        partitionRunner.runInPartitionedThreads(thePids, pidChunk -> this.deleteInTransaction(theResourceName, (List<Long>)pidChunk, expungedResourcesCount, expungedEntitiesCount, theRequest));
        ourLog.info("Expunged a total of {} records", (Object)expungedEntitiesCount);
        if (expungedResourcesCount.get() == 0L) {
            oo = OperationOutcomeUtil.newInstance((FhirContext)this.myFhirContext);
            message = this.myFhirContext.getLocalizer().getMessageSanitized(BaseHapiFhirResourceDao.class, "unableToDeleteNotFound", new Object[]{theUrl});
            String severity = "warning";
            String code = "not-found";
            OperationOutcomeUtil.addIssue((FhirContext)this.myFhirContext, (IBaseOperationOutcome)oo, (String)severity, (String)message, null, (String)code);
        } else {
            oo = OperationOutcomeUtil.newInstance((FhirContext)this.myFhirContext);
            message = this.myFhirContext.getLocalizer().getMessage(BaseHapiFhirResourceDao.class, "successfulDeletes", new Object[]{expungedResourcesCount.get(), w.getMillis()});
            String severity = "information";
            String code = "informational";
            OperationOutcomeUtil.addIssue((FhirContext)this.myFhirContext, (IBaseOperationOutcome)oo, (String)severity, (String)message, null, (String)code);
        }
        DeleteMethodOutcome retval = new DeleteMethodOutcome();
        retval.setExpungedResourcesCount(expungedResourcesCount.get());
        retval.setExpungedEntitiesCount(expungedEntitiesCount.get());
        retval.setOperationOutcome(oo);
        return retval;
    }

    public void validateOkToDeleteAndExpunge(Slice<Long> theAllTargetPids) {
        if (!this.myDaoConfig.isEnforceReferentialIntegrityOnDelete()) {
            ourLog.info("Referential integrity on delete disabled.  Skipping referential integrity check.");
            return;
        }
        List conflictResourceLinks = Collections.synchronizedList(new ArrayList());
        PartitionRunner partitionRunner = new PartitionRunner("Delete Expunging", "delete-expunge", this.myDaoConfig.getExpungeBatchSize(), this.myDaoConfig.getExpungeThreadCount());
        partitionRunner.runInPartitionedThreads(theAllTargetPids, someTargetPids -> this.findResourceLinksWithTargetPidIn(theAllTargetPids.getContent(), (List<Long>)someTargetPids, conflictResourceLinks));
        if (conflictResourceLinks.isEmpty()) {
            return;
        }
        ResourceLink firstConflict = (ResourceLink)conflictResourceLinks.get(0);
        String sourceResourceId = this.myIdHelper.resourceIdFromPidOrThrowException(firstConflict.getSourceResourcePid()).toVersionless().getValue();
        String targetResourceId = this.myIdHelper.resourceIdFromPidOrThrowException(firstConflict.getTargetResourcePid()).toVersionless().getValue();
        throw new InvalidRequestException("DELETE with _expunge=true failed.  Unable to delete " + targetResourceId + " because " + sourceResourceId + " refers to it via the path " + firstConflict.getSourcePath());
    }

    public void findResourceLinksWithTargetPidIn(List<Long> theAllTargetPids, List<Long> theSomeTargetPids, List<ResourceLink> theConflictResourceLinks) {
        if (theConflictResourceLinks.isEmpty()) {
            List conflictResourceLinks = this.myResourceLinkDao.findWithTargetPidIn(theSomeTargetPids).stream().filter(link -> !theAllTargetPids.contains(link.getSourceResourcePid())).collect(Collectors.toList());
            theConflictResourceLinks.addAll(conflictResourceLinks);
        }
    }

    private void deleteInTransaction(String theResourceName, List<Long> thePidChunk, AtomicLong theExpungedResourcesCount, AtomicLong theExpungedEntitiesCount, RequestDetails theRequest) {
        TransactionTemplate txTemplate = new TransactionTemplate(this.myPlatformTransactionManager);
        txTemplate.executeWithoutResult(t -> this.deleteAllRecordsLinkingTo(theResourceName, thePidChunk, theExpungedResourcesCount, theExpungedEntitiesCount, theRequest));
    }

    private void deleteAllRecordsLinkingTo(String theResourceName, List<Long> thePids, AtomicLong theExpungedResourcesCount, AtomicLong theExpungedEntitiesCount, RequestDetails theRequest) {
        HookParams params = new HookParams().add(String.class, (Object)theResourceName).add(List.class, thePids).add(AtomicLong.class, (Object)theExpungedEntitiesCount).add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest);
        CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest, (Pointcut)Pointcut.STORAGE_PRE_DELETE_EXPUNGE_PID_LIST, (HookParams)params);
        String pidListString = thePids.toString().replace("[", "(").replace("]", ")");
        List<ResourceForeignKey> resourceForeignKeys = this.myResourceTableFKProvider.getResourceForeignKeys();
        for (ResourceForeignKey resourceForeignKey : resourceForeignKeys) {
            this.deleteRecordsByColumn(pidListString, resourceForeignKey, theExpungedEntitiesCount);
        }
        ResourceForeignKey resourceTablePk = new ResourceForeignKey("HFJ_RESOURCE", "RES_ID");
        int entitiesDeleted = this.deleteRecordsByColumn(pidListString, resourceTablePk, theExpungedEntitiesCount);
        theExpungedResourcesCount.addAndGet(entitiesDeleted);
    }

    private int deleteRecordsByColumn(String thePidListString, ResourceForeignKey theResourceForeignKey, AtomicLong theExpungedEntitiesCount) {
        int entitesDeleted = this.myEntityManager.createNativeQuery("DELETE FROM " + theResourceForeignKey.table + " WHERE " + theResourceForeignKey.key + " IN " + thePidListString).executeUpdate();
        ourLog.info("Expunged {} records from {}", (Object)entitesDeleted, (Object)theResourceForeignKey.table);
        theExpungedEntitiesCount.addAndGet(entitesDeleted);
        return entitesDeleted;
    }
}

