/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.expunge;

import ca.uhn.fhir.jpa.api.model.ExpungeOptions;
import ca.uhn.fhir.jpa.api.model.ExpungeOutcome;
import ca.uhn.fhir.jpa.dao.expunge.ExpungeEverythingService;
import ca.uhn.fhir.jpa.dao.expunge.ExpungeOperation;
import ca.uhn.fhir.jpa.dao.expunge.IResourceExpungeService;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class ExpungeService {
    private static final Logger ourLog = LoggerFactory.getLogger(ExpungeService.class);
    @Autowired
    private ExpungeEverythingService myExpungeEverythingService;
    @Autowired
    private IResourceExpungeService myExpungeDaoService;
    @Autowired
    private ApplicationContext myApplicationContext;

    protected ExpungeOperation getExpungeOperation(String theResourceName, Long theResourceId, Long theVersion, ExpungeOptions theExpungeOptions, RequestDetails theRequestDetails) {
        return (ExpungeOperation)this.myApplicationContext.getBean(ExpungeOperation.class, new Object[]{theResourceName, theResourceId, theVersion, theExpungeOptions, theRequestDetails});
    }

    public ExpungeOutcome expunge(String theResourceName, Long theResourceId, Long theVersion, ExpungeOptions theExpungeOptions, RequestDetails theRequest) {
        ourLog.info("Expunge: ResourceName[{}] Id[{}] Version[{}] Options[{}]", new Object[]{theResourceName, theResourceId, theVersion, theExpungeOptions});
        if (theExpungeOptions.getLimit() < 1) {
            throw new InvalidRequestException("Expunge limit may not be less than 1.  Received expunge limit " + theExpungeOptions.getLimit() + ".");
        }
        if (theResourceName == null && theResourceId == null && theVersion == null && theExpungeOptions.isExpungeEverything()) {
            this.myExpungeEverythingService.expungeEverything(theRequest);
        }
        ExpungeOperation expungeOperation = this.getExpungeOperation(theResourceName, theResourceId, theVersion, theExpungeOptions, theRequest);
        return expungeOperation.call();
    }

    public void deleteAllSearchParams(Long theResourceId) {
        this.myExpungeDaoService.deleteAllSearchParams(theResourceId);
    }
}

