/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.index;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.dao.data.IForcedIdDao;
import ca.uhn.fhir.jpa.dao.data.IResourceTableDao;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.cross.IResourceLookup;
import ca.uhn.fhir.jpa.model.cross.ResourceLookup;
import ca.uhn.fhir.jpa.model.entity.ForcedId;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.search.builder.predicate.BaseJoiningPredicateBuilder;
import ca.uhn.fhir.jpa.util.MemoryCacheService;
import ca.uhn.fhir.jpa.util.QueryChunker;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.IdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IdHelperService {
    private static final String RESOURCE_PID = "RESOURCE_PID";
    private static final Logger ourLog = LoggerFactory.getLogger(IdHelperService.class);
    public static final Predicate[] EMPTY_PREDICATE_ARRAY = new Predicate[0];
    @Autowired
    protected IForcedIdDao myForcedIdDao;
    @Autowired
    protected IResourceTableDao myResourceTableDao;
    @Autowired
    private DaoConfig myDaoConfig;
    @Autowired
    private FhirContext myFhirCtx;
    @Autowired
    private MemoryCacheService myMemoryCacheService;
    @PersistenceContext(type=PersistenceContextType.TRANSACTION)
    private EntityManager myEntityManager;
    @Autowired
    private PartitionSettings myPartitionSettings;

    public void delete(ForcedId forcedId) {
        this.myForcedIdDao.deleteByPid(forcedId.getId());
    }

    @Nonnull
    public IResourceLookup resolveResourceIdentity(@Nonnull RequestPartitionId theRequestPartitionId, String theResourceType, String theResourceId) throws ResourceNotFoundException {
        IdDt id = new IdDt(theResourceType, theResourceId);
        Collection<IResourceLookup> matches = this.translateForcedIdToPids(theRequestPartitionId, Collections.singletonList(id));
        if (matches.isEmpty()) {
            throw new ResourceNotFoundException(id);
        }
        if (matches.size() > 1) {
            String msg = this.myFhirCtx.getLocalizer().getMessage(IdHelperService.class, "nonUniqueForcedId", new Object[0]);
            throw new PreconditionFailedException(msg);
        }
        return matches.iterator().next();
    }

    @Nonnull
    public ResourcePersistentId resolveResourcePersistentIds(@Nonnull RequestPartitionId theRequestPartitionId, String theResourceType, String theId) {
        ResourcePersistentId retVal;
        Validate.notNull((Object)theId, (String)"theId must not be null", (Object[])new Object[0]);
        if (this.myDaoConfig.getResourceClientIdStrategy() == DaoConfig.ClientIdStrategyEnum.ANY || !IdHelperService.isValidPid(theId)) {
            if (this.myDaoConfig.isDeleteEnabled()) {
                retVal = new ResourcePersistentId((Object)this.resolveResourceIdentity(theRequestPartitionId, theResourceType, theId).getResourceId());
            } else {
                String key = this.toForcedIdToPidKey(theRequestPartitionId, theResourceType, theId);
                retVal = this.myMemoryCacheService.getThenPutAfterCommit(MemoryCacheService.CacheEnum.FORCED_ID_TO_PID, key, t -> {
                    List<IdType> ids = Collections.singletonList(new IdType(theResourceType, theId));
                    List<ResourcePersistentId> resolvedIds = this.resolveResourcePersistentIdsWithCache(theRequestPartitionId, ids);
                    if (resolvedIds.isEmpty()) {
                        throw new ResourceNotFoundException((IIdType)ids.get(0));
                    }
                    return resolvedIds.get(0);
                });
            }
        } else {
            retVal = new ResourcePersistentId((Object)Long.parseLong(theId));
        }
        return retVal;
    }

    @Nonnull
    private String toForcedIdToPidKey(@Nonnull RequestPartitionId theRequestPartitionId, String theResourceType, String theId) {
        return RequestPartitionId.stringifyForKey((RequestPartitionId)theRequestPartitionId) + "/" + theResourceType + "/" + theId;
    }

    @Nonnull
    public List<ResourcePersistentId> resolveResourcePersistentIdsWithCache(RequestPartitionId theRequestPartitionId, List<IIdType> theIds) {
        theIds.forEach(id -> Validate.isTrue((boolean)id.hasIdPart()));
        if (theIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ResourcePersistentId> retVal = new ArrayList<ResourcePersistentId>(theIds.size());
        HashSet<IIdType> idsToCheck = new HashSet<IIdType>(theIds.size());
        for (IIdType nextId : theIds) {
            if (this.myDaoConfig.getResourceClientIdStrategy() != DaoConfig.ClientIdStrategyEnum.ANY && nextId.isIdPartValidLong()) {
                retVal.add(new ResourcePersistentId((Object)nextId.getIdPartAsLong()).setAssociatedResourceId(nextId));
                continue;
            }
            String key = this.toForcedIdToPidKey(theRequestPartitionId, nextId.getResourceType(), nextId.getIdPart());
            ResourcePersistentId cachedId = (ResourcePersistentId)this.myMemoryCacheService.getIfPresent(MemoryCacheService.CacheEnum.FORCED_ID_TO_PID, key);
            if (cachedId != null) {
                retVal.add(cachedId);
                continue;
            }
            idsToCheck.add(nextId);
        }
        if (idsToCheck.size() > 0) {
            CriteriaBuilder cb = this.myEntityManager.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = cb.createQuery(ForcedId.class);
            Root from = criteriaQuery.from(ForcedId.class);
            ArrayList<Predicate> predicates = new ArrayList<Predicate>(idsToCheck.size());
            for (IIdType next : idsToCheck) {
                ArrayList<Predicate> andPredicates = new ArrayList<Predicate>(3);
                if (StringUtils.isNotBlank((CharSequence)next.getResourceType())) {
                    Predicate typeCriteria = cb.equal(from.get("myResourceType").as(String.class), (Object)next.getResourceType());
                    andPredicates.add(typeCriteria);
                }
                Predicate idCriteria = cb.equal(from.get("myForcedId").as(String.class), (Object)next.getIdPart());
                andPredicates.add(idCriteria);
                if (theRequestPartitionId.isDefaultPartition() && this.myPartitionSettings.getDefaultPartitionId() == null) {
                    Predicate partitionIdCriteria = cb.isNull(from.get("myPartitionIdValue").as(Integer.class));
                    andPredicates.add(partitionIdCriteria);
                } else if (!theRequestPartitionId.isAllPartitions()) {
                    Predicate partitionIdCriteria;
                    List<Integer> partitionIds = theRequestPartitionId.getPartitionIds();
                    if ((partitionIds = BaseJoiningPredicateBuilder.replaceDefaultPartitionIdIfNonNull(this.myPartitionSettings, partitionIds)).size() > 1) {
                        partitionIdCriteria = from.get("myPartitionIdValue").as(Integer.class).in(partitionIds);
                        andPredicates.add(partitionIdCriteria);
                    } else {
                        partitionIdCriteria = cb.equal(from.get("myPartitionIdValue").as(Integer.class), (Object)partitionIds.get(0));
                        andPredicates.add(partitionIdCriteria);
                    }
                }
                predicates.add(cb.and(andPredicates.toArray(EMPTY_PREDICATE_ARRAY)));
            }
            criteriaQuery.where((Expression)cb.or(predicates.toArray(EMPTY_PREDICATE_ARRAY)));
            TypedQuery query = this.myEntityManager.createQuery(criteriaQuery);
            List results = query.getResultList();
            for (ForcedId nextId : results) {
                ResourcePersistentId persistentId = new ResourcePersistentId((Object)nextId.getResourceId());
                this.populateAssociatedResourceId(nextId.getResourceType(), nextId.getForcedId(), persistentId);
                retVal.add(persistentId);
                String key = this.toForcedIdToPidKey(theRequestPartitionId, nextId.getResourceType(), nextId.getForcedId());
                this.myMemoryCacheService.putAfterCommit(MemoryCacheService.CacheEnum.FORCED_ID_TO_PID, key, persistentId);
            }
        }
        return retVal;
    }

    private void populateAssociatedResourceId(String nextResourceType, String forcedId, ResourcePersistentId persistentId) {
        IIdType resourceId = this.myFhirCtx.getVersion().newIdType();
        resourceId.setValue(nextResourceType + "/" + forcedId);
        persistentId.setAssociatedResourceId(resourceId);
    }

    @Nonnull
    public IIdType translatePidIdToForcedId(FhirContext theCtx, String theResourceType, ResourcePersistentId theId) {
        IIdType retVal = theCtx.getVersion().newIdType();
        Optional<String> forcedId = this.translatePidIdToForcedIdWithCache(theId);
        if (forcedId.isPresent()) {
            retVal.setValue(theResourceType + '/' + forcedId.get());
        } else {
            retVal.setValue(theResourceType + '/' + theId.toString());
        }
        return retVal;
    }

    public Optional<String> translatePidIdToForcedIdWithCache(ResourcePersistentId theId) {
        return this.myMemoryCacheService.get(MemoryCacheService.CacheEnum.PID_TO_FORCED_ID, theId.getIdAsLong(), pid -> this.myForcedIdDao.findByResourcePid((Long)pid).map(t -> t.getForcedId()));
    }

    private ListMultimap<String, String> organizeIdsByResourceType(Collection<IIdType> theIds) {
        ListMultimap typeToIds = MultimapBuilder.hashKeys().arrayListValues().build();
        for (IIdType nextId : theIds) {
            if (this.myDaoConfig.getResourceClientIdStrategy() != DaoConfig.ClientIdStrategyEnum.ANY && IdHelperService.isValidPid(nextId)) continue;
            if (nextId.hasResourceType()) {
                typeToIds.put((Object)nextId.getResourceType(), (Object)nextId.getIdPart());
                continue;
            }
            typeToIds.put((Object)"", (Object)nextId.getIdPart());
        }
        return typeToIds;
    }

    private Collection<IResourceLookup> translateForcedIdToPids(@Nonnull RequestPartitionId theRequestPartitionId, Collection<IIdType> theId) {
        List<Long> pids;
        theId.forEach(id -> Validate.isTrue((boolean)id.hasIdPart()));
        if (theId.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IResourceLookup> retVal = new ArrayList<IResourceLookup>();
        RequestPartitionId requestPartitionId = this.replaceDefault(theRequestPartitionId);
        if (this.myDaoConfig.getResourceClientIdStrategy() != DaoConfig.ClientIdStrategyEnum.ANY && !(pids = theId.stream().filter(t -> IdHelperService.isValidPid(t)).map(t -> t.getIdPartAsLong()).collect(Collectors.toList())).isEmpty()) {
            this.resolvePids(requestPartitionId, pids, retVal);
        }
        ListMultimap<String, String> typeToIds = this.organizeIdsByResourceType(theId);
        for (Map.Entry nextEntry : typeToIds.asMap().entrySet()) {
            String nextResourceType = (String)nextEntry.getKey();
            Collection nextIds = (Collection)nextEntry.getValue();
            if (!this.myDaoConfig.isDeleteEnabled()) {
                Iterator forcedIdIterator = nextIds.iterator();
                while (forcedIdIterator.hasNext()) {
                    String nextForcedId = (String)forcedIdIterator.next();
                    String nextKey = nextResourceType + "/" + nextForcedId;
                    IResourceLookup cachedLookup = (IResourceLookup)this.myMemoryCacheService.getIfPresent(MemoryCacheService.CacheEnum.RESOURCE_LOOKUP, nextKey);
                    if (cachedLookup == null) continue;
                    forcedIdIterator.remove();
                    retVal.add(cachedLookup);
                }
            }
            if (nextIds.size() <= 0) continue;
            assert (StringUtils.isNotBlank((CharSequence)nextResourceType));
            Collection<Object[]> views = requestPartitionId.isAllPartitions() ? this.myForcedIdDao.findAndResolveByForcedIdWithNoType(nextResourceType, nextIds) : (requestPartitionId.isDefaultPartition() ? this.myForcedIdDao.findAndResolveByForcedIdWithNoTypeInPartitionNull(nextResourceType, nextIds) : (requestPartitionId.hasDefaultPartitionId() ? this.myForcedIdDao.findAndResolveByForcedIdWithNoTypeInPartitionIdOrNullPartitionId(nextResourceType, nextIds, requestPartitionId.getPartitionIdsWithoutDefault()) : this.myForcedIdDao.findAndResolveByForcedIdWithNoTypeInPartition(nextResourceType, nextIds, requestPartitionId.getPartitionIds())));
            for (Object[] next : views) {
                String resourceType = (String)next[0];
                Long resourcePid = (Long)next[1];
                String forcedId = (String)next[2];
                Date deletedAt = (Date)next[3];
                ResourceLookup lookup = new ResourceLookup(resourceType, resourcePid, deletedAt);
                retVal.add((IResourceLookup)lookup);
                if (this.myDaoConfig.isDeleteEnabled()) continue;
                String key = resourceType + "/" + forcedId;
                this.myMemoryCacheService.putAfterCommit(MemoryCacheService.CacheEnum.RESOURCE_LOOKUP, key, lookup);
            }
        }
        return retVal;
    }

    RequestPartitionId replaceDefault(RequestPartitionId theRequestPartitionId) {
        if (this.myPartitionSettings.getDefaultPartitionId() != null && !theRequestPartitionId.isAllPartitions() && theRequestPartitionId.hasDefaultPartitionId()) {
            List partitionIds = theRequestPartitionId.getPartitionIds().stream().map(t -> t == null ? this.myPartitionSettings.getDefaultPartitionId() : t).collect(Collectors.toList());
            return RequestPartitionId.fromPartitionIds(partitionIds);
        }
        return theRequestPartitionId;
    }

    private void resolvePids(@Nonnull RequestPartitionId theRequestPartitionId, List<Long> thePidsToResolve, List<IResourceLookup> theTarget) {
        if (!this.myDaoConfig.isDeleteEnabled()) {
            Iterator<Long> forcedIdIterator = thePidsToResolve.iterator();
            while (forcedIdIterator.hasNext()) {
                Long nextPid = forcedIdIterator.next();
                String nextKey = Long.toString(nextPid);
                IResourceLookup cachedLookup = (IResourceLookup)this.myMemoryCacheService.getIfPresent(MemoryCacheService.CacheEnum.RESOURCE_LOOKUP, nextKey);
                if (cachedLookup == null) continue;
                forcedIdIterator.remove();
                theTarget.add(cachedLookup);
            }
        }
        if (thePidsToResolve.size() > 0) {
            Collection<Object[]> lookup = theRequestPartitionId.isAllPartitions() ? this.myResourceTableDao.findLookupFieldsByResourcePid(thePidsToResolve) : (theRequestPartitionId.isDefaultPartition() ? this.myResourceTableDao.findLookupFieldsByResourcePidInPartitionNull(thePidsToResolve) : (theRequestPartitionId.hasDefaultPartitionId() ? this.myResourceTableDao.findLookupFieldsByResourcePidInPartitionIdsOrNullPartition(thePidsToResolve, theRequestPartitionId.getPartitionIdsWithoutDefault()) : this.myResourceTableDao.findLookupFieldsByResourcePidInPartitionIds(thePidsToResolve, theRequestPartitionId.getPartitionIds())));
            lookup.stream().map(t -> new ResourceLookup((String)t[0], (Long)t[1], (Date)t[2])).forEach(t -> {
                theTarget.add((IResourceLookup)t);
                if (!this.myDaoConfig.isDeleteEnabled()) {
                    String nextKey = Long.toString(t.getResourceId());
                    this.myMemoryCacheService.putAfterCommit(MemoryCacheService.CacheEnum.RESOURCE_LOOKUP, nextKey, t);
                }
            });
        }
    }

    public Set<String> translatePidsToFhirResourceIds(Set<Long> thePids) {
        Map<Long, Optional<String>> pidToForcedIdMap = this.translatePidsToForcedIds(thePids);
        Set<String> resolvedResourceIds = pidToForcedIdMap.entrySet().stream().map(entry -> ((Optional)entry.getValue()).isPresent() ? (String)((Optional)entry.getValue()).get() : ((Long)entry.getKey()).toString()).collect(Collectors.toSet());
        return resolvedResourceIds;
    }

    public Map<Long, Optional<String>> translatePidsToForcedIds(Set<Long> thePids) {
        HashMap<Long, Optional<String>> retVal = new HashMap<Long, Optional<String>>(this.myMemoryCacheService.getAllPresent(MemoryCacheService.CacheEnum.PID_TO_FORCED_ID, thePids));
        List remainingPids = thePids.stream().filter(t -> !retVal.containsKey(t)).collect(Collectors.toList());
        new QueryChunker().chunk(remainingPids, t -> {
            List<ForcedId> forcedIds = this.myForcedIdDao.findAllByResourcePid((List<Long>)t);
            for (ForcedId forcedId : forcedIds) {
                Long nextResourcePid = forcedId.getResourceId();
                Optional<String> nextForcedId = Optional.of(forcedId.getForcedId());
                retVal.put(nextResourcePid, nextForcedId);
                this.myMemoryCacheService.putAfterCommit(MemoryCacheService.CacheEnum.PID_TO_FORCED_ID, nextResourcePid, nextForcedId);
            }
        });
        remainingPids = thePids.stream().filter(t -> !retVal.containsKey(t)).collect(Collectors.toList());
        for (Long nextResourcePid : remainingPids) {
            retVal.put(nextResourcePid, Optional.empty());
            this.myMemoryCacheService.putAfterCommit(MemoryCacheService.CacheEnum.PID_TO_FORCED_ID, nextResourcePid, Optional.empty());
        }
        return retVal;
    }

    @Deprecated
    @Nullable
    public Long getPidOrNull(IBaseResource theResource) {
        IAnyResource anyResource = (IAnyResource)theResource;
        Long retVal = (Long)anyResource.getUserData(RESOURCE_PID);
        if (retVal == null) {
            IIdType id = theResource.getIdElement();
            try {
                retVal = this.resolveResourcePersistentIds(RequestPartitionId.allPartitions(), id.getResourceType(), id.getIdPart()).getIdAsLong();
            }
            catch (ResourceNotFoundException e) {
                return null;
            }
        }
        return retVal;
    }

    @Deprecated
    @Nonnull
    public Long getPidOrThrowException(IIdType theId) {
        List<IIdType> ids = Collections.singletonList(theId);
        List<ResourcePersistentId> resourcePersistentIds = this.resolveResourcePersistentIdsWithCache(RequestPartitionId.allPartitions(), ids);
        return resourcePersistentIds.get(0).getIdAsLong();
    }

    @Deprecated
    @Nonnull
    public List<Long> getPidsOrThrowException(List<IIdType> theIds) {
        List<ResourcePersistentId> resourcePersistentIds = this.resolveResourcePersistentIdsWithCache(RequestPartitionId.allPartitions(), theIds);
        return resourcePersistentIds.stream().map(ResourcePersistentId::getIdAsLong).collect(Collectors.toList());
    }

    @Nonnull
    public Long getPidOrThrowException(IAnyResource theResource) {
        Long retVal = (Long)theResource.getUserData(RESOURCE_PID);
        if (retVal == null) {
            throw new IllegalStateException(String.format("Unable to find %s in the user data for %s with ID %s", RESOURCE_PID, theResource, theResource.getId()));
        }
        return retVal;
    }

    public IIdType resourceIdFromPidOrThrowException(Long thePid) {
        Optional optionalResource = this.myResourceTableDao.findById(thePid);
        if (!optionalResource.isPresent()) {
            throw new ResourceNotFoundException("Requested resource not found");
        }
        return ((ResourceTable)optionalResource.get()).getIdDt().toVersionless();
    }

    public void addResolvedPidToForcedId(ResourcePersistentId theResourcePersistentId, @Nonnull RequestPartitionId theRequestPartitionId, String theResourceType, @Nullable String theForcedId) {
        if (theForcedId != null) {
            if (theResourcePersistentId.getAssociatedResourceId() == null) {
                this.populateAssociatedResourceId(theResourceType, theForcedId, theResourcePersistentId);
            }
            this.myMemoryCacheService.putAfterCommit(MemoryCacheService.CacheEnum.PID_TO_FORCED_ID, theResourcePersistentId.getIdAsLong(), Optional.of(theForcedId));
            String key = this.toForcedIdToPidKey(theRequestPartitionId, theResourceType, theForcedId);
            this.myMemoryCacheService.putAfterCommit(MemoryCacheService.CacheEnum.FORCED_ID_TO_PID, key, theResourcePersistentId);
        } else {
            this.myMemoryCacheService.putAfterCommit(MemoryCacheService.CacheEnum.PID_TO_FORCED_ID, theResourcePersistentId.getIdAsLong(), Optional.empty());
        }
    }

    @VisibleForTesting
    void setPartitionSettingsForUnitTest(PartitionSettings thePartitionSettings) {
        this.myPartitionSettings = thePartitionSettings;
    }

    public static boolean isValidPid(IIdType theId) {
        if (theId == null) {
            return false;
        }
        String idPart = theId.getIdPart();
        return IdHelperService.isValidPid(idPart);
    }

    public static boolean isValidPid(String theIdPart) {
        return StringUtils.isNumeric((CharSequence)theIdPart);
    }
}

