/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.mdm;

import ca.uhn.fhir.jpa.dao.data.IMdmLinkDao;
import ca.uhn.fhir.jpa.dao.index.IdHelperService;
import ca.uhn.fhir.mdm.api.MdmMatchResultEnum;
import ca.uhn.fhir.mdm.log.Logs;
import ca.uhn.fhir.model.primitive.IdDt;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MdmLinkExpandSvc {
    private static final Logger ourLog = Logs.getMdmTroubleshootingLog();
    @Autowired
    private IMdmLinkDao myMdmLinkDao;
    @Autowired
    private IdHelperService myIdHelperService;

    public Set<String> expandMdmBySourceResource(IBaseResource theResource) {
        ourLog.debug("About to MDM-expand source resource {}", (Object)theResource);
        return this.expandMdmBySourceResourceId(theResource.getIdElement());
    }

    public Set<String> expandMdmBySourceResourceId(IIdType theId) {
        ourLog.debug("About to expand source resource with resource id {}", (Object)theId);
        Long pidOrThrowException = this.myIdHelperService.getPidOrThrowException(theId);
        return this.expandMdmBySourceResourcePid(pidOrThrowException);
    }

    public Set<String> expandMdmBySourceResourcePid(Long theSourceResourcePid) {
        ourLog.debug("About to expand source resource with PID {}", (Object)theSourceResourcePid);
        List<IMdmLinkDao.MdmPidTuple> goldenPidSourcePidTuples = this.myMdmLinkDao.expandPidsBySourcePidAndMatchResult(theSourceResourcePid, MdmMatchResultEnum.MATCH);
        return this.flattenPidTuplesToSet(theSourceResourcePid, goldenPidSourcePidTuples);
    }

    public Set<String> expandMdmByGoldenResourceId(Long theGoldenResourcePid) {
        ourLog.debug("About to expand golden resource with PID {}", (Object)theGoldenResourcePid);
        List<IMdmLinkDao.MdmPidTuple> goldenPidSourcePidTuples = this.myMdmLinkDao.expandPidsByGoldenResourcePidAndMatchResult(theGoldenResourcePid, MdmMatchResultEnum.MATCH);
        return this.flattenPidTuplesToSet(theGoldenResourcePid, goldenPidSourcePidTuples);
    }

    public Set<String> expandMdmByGoldenResourcePid(Long theGoldenResourcePid) {
        ourLog.debug("About to expand golden resource with PID {}", (Object)theGoldenResourcePid);
        List<IMdmLinkDao.MdmPidTuple> goldenPidSourcePidTuples = this.myMdmLinkDao.expandPidsByGoldenResourcePidAndMatchResult(theGoldenResourcePid, MdmMatchResultEnum.MATCH);
        return this.flattenPidTuplesToSet(theGoldenResourcePid, goldenPidSourcePidTuples);
    }

    public Set<String> expandMdmByGoldenResourceId(IdDt theId) {
        ourLog.debug("About to expand golden resource with golden resource id {}", (Object)theId);
        Long pidOrThrowException = this.myIdHelperService.getPidOrThrowException((IIdType)theId);
        return this.expandMdmByGoldenResourcePid(pidOrThrowException);
    }

    @Nonnull
    private Set<String> flattenPidTuplesToSet(Long initialPid, List<IMdmLinkDao.MdmPidTuple> goldenPidSourcePidTuples) {
        HashSet<Long> flattenedPids = new HashSet<Long>();
        goldenPidSourcePidTuples.forEach(tuple -> {
            flattenedPids.add(tuple.getSourcePid());
            flattenedPids.add(tuple.getGoldenPid());
        });
        Set<String> resourceIds = this.myIdHelperService.translatePidsToFhirResourceIds(flattenedPids);
        ourLog.debug("Pid {} has been expanded to [{}]", (Object)initialPid, (Object)String.join((CharSequence)",", resourceIds));
        return resourceIds;
    }
}

