/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.predicate;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.dao.LegacySearchBuilder;
import ca.uhn.fhir.jpa.dao.predicate.SearchBuilderJoinEnum;
import ca.uhn.fhir.jpa.dao.predicate.SearchFuzzUtil;
import ca.uhn.fhir.jpa.dao.predicate.querystack.QueryStack;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.entity.BasePartitionable;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndexedSearchParam;
import ca.uhn.fhir.jpa.model.entity.SearchParamPresent;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.param.ParamPrefixEnum;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Predicate;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

abstract class BasePredicateBuilder {
    private static final Logger ourLog = LoggerFactory.getLogger(BasePredicateBuilder.class);
    final CriteriaBuilder myCriteriaBuilder;
    final QueryStack myQueryStack;
    final Class<? extends IBaseResource> myResourceType;
    final String myResourceName;
    final SearchParameterMap myParams;
    @Autowired
    FhirContext myContext;
    @Autowired
    DaoConfig myDaoConfig;
    boolean myDontUseHashesForSearch;
    @Autowired
    private PartitionSettings myPartitionSettings;

    BasePredicateBuilder(LegacySearchBuilder theSearchBuilder) {
        this.myCriteriaBuilder = theSearchBuilder.getBuilder();
        this.myQueryStack = theSearchBuilder.getQueryStack();
        this.myResourceType = theSearchBuilder.getResourceType();
        this.myResourceName = theSearchBuilder.getResourceName();
        this.myParams = theSearchBuilder.getParams();
    }

    @PostConstruct
    private void postConstruct() {
        this.myDontUseHashesForSearch = this.myDaoConfig.getDisableHashBasedSearches();
    }

    void addPredicateParamMissingForReference(String theResourceName, String theParamName, boolean theMissing, RequestPartitionId theRequestPartitionId) {
        From paramPresentJoin = this.myQueryStack.createJoin(SearchBuilderJoinEnum.PRESENCE, null);
        Expression hashPresence = paramPresentJoin.get("myHashPresence").as(Long.class);
        Long hash = SearchParamPresent.calculateHashPresence((PartitionSettings)this.myPartitionSettings, (RequestPartitionId)theRequestPartitionId, (String)theResourceName, (String)theParamName, (Boolean)(!theMissing ? 1 : 0));
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(this.myCriteriaBuilder.equal(hashPresence, (Object)hash));
        this.addPartitionIdPredicate(theRequestPartitionId, paramPresentJoin, predicates);
        this.myQueryStack.addPredicatesWithImplicitTypeSelection(predicates);
    }

    void addPredicateParamMissingForNonReference(String theResourceName, String theParamName, boolean theMissing, From<?, ? extends BaseResourceIndexedSearchParam> theJoin, RequestPartitionId theRequestPartitionId) {
        if (!theRequestPartitionId.isAllPartitions()) {
            if (theRequestPartitionId.isDefaultPartition()) {
                this.myQueryStack.addPredicate(this.myCriteriaBuilder.isNull((Expression)theJoin.get("myPartitionIdValue")));
            } else {
                this.myQueryStack.addPredicate(theJoin.get("myPartitionIdValue").in((Collection)theRequestPartitionId.getPartitionIds()));
            }
        }
        this.myQueryStack.addPredicateWithImplicitTypeSelection(this.myCriteriaBuilder.equal((Expression)theJoin.get("myResourceType"), (Object)theResourceName));
        this.myQueryStack.addPredicate(this.myCriteriaBuilder.equal((Expression)theJoin.get("myParamName"), (Object)theParamName));
        this.myQueryStack.addPredicate(this.myCriteriaBuilder.equal((Expression)theJoin.get("myMissing"), (Object)theMissing));
    }

    Predicate combineParamIndexPredicateWithParamNamePredicate(String theResourceName, String theParamName, From<?, ? extends BaseResourceIndexedSearchParam> theFrom, Predicate thePredicate, RequestPartitionId theRequestPartitionId) {
        ArrayList<Predicate> andPredicates = new ArrayList<Predicate>();
        this.addPartitionIdPredicate(theRequestPartitionId, theFrom, andPredicates);
        if (this.myDontUseHashesForSearch) {
            Predicate resourceTypePredicate = this.myCriteriaBuilder.equal((Expression)theFrom.get("myResourceType"), (Object)theResourceName);
            Predicate paramNamePredicate = this.myCriteriaBuilder.equal((Expression)theFrom.get("myParamName"), (Object)theParamName);
            andPredicates.add(resourceTypePredicate);
            andPredicates.add(paramNamePredicate);
            andPredicates.add(thePredicate);
        } else {
            long hashIdentity = BaseResourceIndexedSearchParam.calculateHashIdentity((PartitionSettings)this.myPartitionSettings, (RequestPartitionId)theRequestPartitionId, (String)theResourceName, (String)theParamName);
            Predicate hashIdentityPredicate = this.myCriteriaBuilder.equal((Expression)theFrom.get("myHashIdentity"), (Object)hashIdentity);
            andPredicates.add(hashIdentityPredicate);
            andPredicates.add(thePredicate);
        }
        return this.myCriteriaBuilder.and(BasePredicateBuilder.toArray(andPredicates));
    }

    public PartitionSettings getPartitionSettings() {
        return this.myPartitionSettings;
    }

    Predicate createPredicateNumeric(String theResourceName, String theParamName, From<?, ? extends BaseResourceIndexedSearchParam> theFrom, CriteriaBuilder builder, IQueryParameterType theParam, ParamPrefixEnum thePrefix, BigDecimal theValue, Expression<BigDecimal> thePath, String invalidMessageName, RequestPartitionId theRequestPartitionId) {
        Predicate num;
        switch (thePrefix) {
            case GREATERTHAN: {
                num = builder.gt(thePath, (Number)theValue);
                break;
            }
            case GREATERTHAN_OR_EQUALS: {
                num = builder.ge(thePath, (Number)theValue);
                break;
            }
            case LESSTHAN: {
                num = builder.lt(thePath, (Number)theValue);
                break;
            }
            case LESSTHAN_OR_EQUALS: {
                num = builder.le(thePath, (Number)theValue);
                break;
            }
            case EQUAL: {
                num = builder.equal(thePath, (Object)theValue);
                break;
            }
            case NOT_EQUAL: {
                num = builder.notEqual(thePath, (Object)theValue);
                break;
            }
            case APPROXIMATE: {
                BigDecimal mul = SearchFuzzUtil.calculateFuzzAmount(thePrefix, theValue);
                BigDecimal low = theValue.subtract(mul, MathContext.DECIMAL64);
                BigDecimal high = theValue.add(mul, MathContext.DECIMAL64);
                Predicate lowPred = builder.ge(thePath.as(BigDecimal.class), (Number)low);
                Predicate highPred = builder.le(thePath.as(BigDecimal.class), (Number)high);
                num = builder.and((Expression)lowPred, (Expression)highPred);
                ourLog.trace("Searching for {} <= val <= {}", (Object)low, (Object)high);
                break;
            }
            default: {
                String msg = this.myContext.getLocalizer().getMessage(LegacySearchBuilder.class, invalidMessageName, new Object[]{thePrefix.getValue(), theParam.getValueAsQueryToken(this.myContext)});
                throw new InvalidRequestException(msg);
            }
        }
        if (theParamName == null) {
            return num;
        }
        return this.combineParamIndexPredicateWithParamNamePredicate(theResourceName, theParamName, theFrom, num, theRequestPartitionId);
    }

    void addPartitionIdPredicate(RequestPartitionId theRequestPartitionId, From<?, ? extends BasePartitionable> theJoin, List<Predicate> theCodePredicates) {
        if (!theRequestPartitionId.isAllPartitions()) {
            Predicate partitionPredicate = theRequestPartitionId.isDefaultPartition() ? this.myCriteriaBuilder.isNull(theJoin.get("myPartitionIdValue").as(Integer.class)) : theJoin.get("myPartitionIdValue").as(Integer.class).in((Collection)theRequestPartitionId.getPartitionIds());
            this.myQueryStack.addPredicate(partitionPredicate);
        }
    }

    static String createLeftAndRightMatchLikeExpression(String likeExpression) {
        return "%" + likeExpression.replace("%", "[%]") + "%";
    }

    static String createLeftMatchLikeExpression(String likeExpression) {
        return likeExpression.replace("%", "[%]") + "%";
    }

    static String createRightMatchLikeExpression(String likeExpression) {
        return "%" + likeExpression.replace("%", "[%]");
    }

    static Predicate[] toArray(List<Predicate> thePredicates) {
        return thePredicates.toArray(new Predicate[0]);
    }
}

