/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.predicate;

import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.dao.LegacySearchBuilder;
import ca.uhn.fhir.jpa.dao.predicate.BasePredicateBuilder;
import ca.uhn.fhir.jpa.dao.predicate.IPredicateBuilder;
import ca.uhn.fhir.jpa.dao.predicate.SearchBuilderJoinEnum;
import ca.uhn.fhir.jpa.dao.predicate.SearchFilterParser;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamCoords;
import ca.uhn.fhir.jpa.util.CoordCalculator;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.param.QuantityParam;
import ca.uhn.fhir.rest.param.SpecialParam;
import ca.uhn.fhir.rest.param.TokenParam;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.search.engine.spatial.GeoBoundingBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class PredicateBuilderCoords
extends BasePredicateBuilder
implements IPredicateBuilder {
    private static final Logger ourLog = LoggerFactory.getLogger(PredicateBuilderCoords.class);

    public PredicateBuilderCoords(LegacySearchBuilder theSearchBuilder) {
        super(theSearchBuilder);
    }

    private Predicate createPredicateCoords(IQueryParameterType theParam, String theResourceName, RuntimeSearchParam theSearchParam, CriteriaBuilder theBuilder, From<?, ResourceIndexedSearchParamCoords> theFrom, RequestPartitionId theRequestPartitionId) {
        Predicate longitudePredicate;
        Predicate latitudePredicate;
        String longitudeValue;
        String latitudeValue;
        String[] parts;
        String value;
        TokenParam param;
        Double distanceKm = 0.0;
        if (theParam instanceof TokenParam) {
            param = (TokenParam)theParam;
            value = param.getValue();
            parts = value.split(":");
            if (parts.length != 2) {
                throw new IllegalArgumentException("Invalid position format '" + value + "'.  Required format is 'latitude:longitude'");
            }
            latitudeValue = parts[0];
            longitudeValue = parts[1];
            if (StringUtils.isBlank((CharSequence)latitudeValue) || StringUtils.isBlank((CharSequence)longitudeValue)) {
                throw new IllegalArgumentException("Invalid position format '" + value + "'.  Both latitude and longitude must be provided.");
            }
            QuantityParam distanceParam = this.myParams.getNearDistanceParam();
            if (distanceParam != null) {
                distanceKm = distanceParam.getValue().doubleValue();
            }
        } else if (theParam instanceof SpecialParam) {
            String distanceString;
            param = (SpecialParam)theParam;
            value = param.getValue();
            parts = value.split("\\|");
            if (parts.length < 2 || parts.length > 4) {
                throw new IllegalArgumentException("Invalid position format '" + value + "'.  Required format is 'latitude|longitude' or 'latitude|longitude|distance' or 'latitude|longitude|distance|units'");
            }
            latitudeValue = parts[0];
            longitudeValue = parts[1];
            if (StringUtils.isBlank((CharSequence)latitudeValue) || StringUtils.isBlank((CharSequence)longitudeValue)) {
                throw new IllegalArgumentException("Invalid position format '" + value + "'.  Both latitude and longitude must be provided.");
            }
            if (parts.length >= 3 && !StringUtils.isBlank((CharSequence)(distanceString = parts[2]))) {
                distanceKm = Double.valueOf(distanceString);
            }
        } else {
            throw new IllegalArgumentException("Invalid position type: " + theParam.getClass());
        }
        if (distanceKm == 0.0) {
            latitudePredicate = theBuilder.equal((Expression)theFrom.get("myLatitude"), (Object)latitudeValue);
            longitudePredicate = theBuilder.equal((Expression)theFrom.get("myLongitude"), (Object)longitudeValue);
        } else {
            if (distanceKm < 0.0) {
                throw new IllegalArgumentException("Invalid near-distance parameter '" + distanceKm + "' must be >= 0.0");
            }
            if (distanceKm > 10000.0) {
                throw new IllegalArgumentException("Invalid near-distance parameter '" + distanceKm + "' must be <= " + 10000.0);
            }
            double latitudeDegrees = Double.parseDouble(latitudeValue);
            double longitudeDegrees = Double.parseDouble(longitudeValue);
            GeoBoundingBox box = CoordCalculator.getBox(latitudeDegrees, longitudeDegrees, distanceKm);
            latitudePredicate = this.latitudePredicateFromBox(theBuilder, theFrom, box);
            longitudePredicate = this.longitudePredicateFromBox(theBuilder, theFrom, box);
        }
        Predicate singleCode = theBuilder.and((Expression)latitudePredicate, (Expression)longitudePredicate);
        return this.combineParamIndexPredicateWithParamNamePredicate(theResourceName, theSearchParam.getName(), theFrom, singleCode, theRequestPartitionId);
    }

    private Predicate latitudePredicateFromBox(CriteriaBuilder theBuilder, From<?, ResourceIndexedSearchParamCoords> theFrom, GeoBoundingBox theBox) {
        return theBuilder.and((Expression)theBuilder.greaterThanOrEqualTo((Expression)theFrom.get("myLatitude"), (Comparable)Double.valueOf(theBox.bottomRight().latitude())), (Expression)theBuilder.lessThanOrEqualTo((Expression)theFrom.get("myLatitude"), (Comparable)Double.valueOf(theBox.topLeft().latitude())));
    }

    @VisibleForTesting
    Predicate longitudePredicateFromBox(CriteriaBuilder theBuilder, From<?, ResourceIndexedSearchParamCoords> theFrom, GeoBoundingBox theBox) {
        if (theBox.bottomRight().longitude() < theBox.topLeft().longitude()) {
            return theBuilder.or((Expression)theBuilder.greaterThanOrEqualTo((Expression)theFrom.get("myLongitude"), (Comparable)Double.valueOf(theBox.bottomRight().longitude())), (Expression)theBuilder.lessThanOrEqualTo((Expression)theFrom.get("myLongitude"), (Comparable)Double.valueOf(theBox.topLeft().longitude())));
        }
        return theBuilder.and((Expression)theBuilder.greaterThanOrEqualTo((Expression)theFrom.get("myLongitude"), (Comparable)Double.valueOf(theBox.topLeft().longitude())), (Expression)theBuilder.lessThanOrEqualTo((Expression)theFrom.get("myLongitude"), (Comparable)Double.valueOf(theBox.bottomRight().longitude())));
    }

    @Override
    public Predicate addPredicate(String theResourceName, RuntimeSearchParam theSearchParam, List<? extends IQueryParameterType> theList, SearchFilterParser.CompareOperation theOperation, RequestPartitionId theRequestPartitionId) {
        From join = this.myQueryStack.createJoin(SearchBuilderJoinEnum.COORDS, theSearchParam.getName());
        if (theList.get(0).getMissing() != null) {
            this.addPredicateParamMissingForNonReference(theResourceName, theSearchParam.getName(), theList.get(0).getMissing(), join, theRequestPartitionId);
            return null;
        }
        ArrayList<Predicate> codePredicates = new ArrayList<Predicate>();
        this.addPartitionIdPredicate(theRequestPartitionId, join, codePredicates);
        for (IQueryParameterType iQueryParameterType : theList) {
            Predicate singleCode = this.createPredicateCoords(iQueryParameterType, theResourceName, theSearchParam, this.myCriteriaBuilder, join, theRequestPartitionId);
            codePredicates.add(singleCode);
        }
        Predicate retVal = this.myCriteriaBuilder.or(PredicateBuilderCoords.toArray(codePredicates));
        this.myQueryStack.addPredicateWithImplicitTypeSelection(retVal);
        return retVal;
    }
}

