/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.predicate;

import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.dao.LegacySearchBuilder;
import ca.uhn.fhir.jpa.dao.predicate.BasePredicateBuilder;
import ca.uhn.fhir.jpa.dao.predicate.IPredicateBuilder;
import ca.uhn.fhir.jpa.dao.predicate.SearchBuilderJoinEnum;
import ca.uhn.fhir.jpa.dao.predicate.SearchFilterParser;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndexedSearchParam;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamDate;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.rest.param.DateParam;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.ParamPrefixEnum;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class PredicateBuilderDate
extends BasePredicateBuilder
implements IPredicateBuilder {
    private static final Logger ourLog = LoggerFactory.getLogger(PredicateBuilderDate.class);

    public PredicateBuilderDate(LegacySearchBuilder theSearchBuilder) {
        super(theSearchBuilder);
    }

    @Override
    public Predicate addPredicate(String theResourceName, RuntimeSearchParam theSearchParam, List<? extends IQueryParameterType> theList, SearchFilterParser.CompareOperation operation, RequestPartitionId theRequestPartitionId) {
        String key;
        String paramName = theSearchParam.getName();
        boolean newJoin = false;
        Map<String, From<?, ResourceIndexedSearchParamDate>> joinMap = this.myQueryStack.getJoinMap();
        Object join = joinMap.get(key = theResourceName + " " + paramName);
        if (join == null) {
            join = this.myQueryStack.createJoin(SearchBuilderJoinEnum.DATE, paramName);
            joinMap.put(key, (From<?, ResourceIndexedSearchParamDate>)join);
            newJoin = true;
        }
        if (theList.get(0).getMissing() != null) {
            Boolean missing = theList.get(0).getMissing();
            this.addPredicateParamMissingForNonReference(theResourceName, paramName, missing, (From<?, ? extends BaseResourceIndexedSearchParam>)join, theRequestPartitionId);
            return null;
        }
        ArrayList<Predicate> codePredicates = new ArrayList<Predicate>();
        for (IQueryParameterType iQueryParameterType : theList) {
            Predicate p = this.createPredicateDate(iQueryParameterType, this.myCriteriaBuilder, (From<?, ResourceIndexedSearchParamDate>)join, operation);
            codePredicates.add(p);
        }
        Predicate orPredicates = this.myCriteriaBuilder.or(PredicateBuilderDate.toArray(codePredicates));
        if (newJoin) {
            Predicate predicate = this.combineParamIndexPredicateWithParamNamePredicate(theResourceName, paramName, (From<?, ? extends BaseResourceIndexedSearchParam>)join, orPredicates, theRequestPartitionId);
            this.myQueryStack.addPredicateWithImplicitTypeSelection(predicate);
        } else {
            this.myQueryStack.addPredicateWithImplicitTypeSelection(orPredicates);
        }
        return orPredicates;
    }

    public Predicate createPredicateDate(IQueryParameterType theParam, String theResourceName, String theParamName, CriteriaBuilder theBuilder, From<?, ResourceIndexedSearchParamDate> theFrom, RequestPartitionId theRequestPartitionId) {
        Predicate predicateDate = this.createPredicateDate(theParam, theBuilder, theFrom, null);
        return this.combineParamIndexPredicateWithParamNamePredicate(theResourceName, theParamName, theFrom, predicateDate, theRequestPartitionId);
    }

    private Predicate createPredicateDate(IQueryParameterType theParam, CriteriaBuilder theBuilder, From<?, ResourceIndexedSearchParamDate> theFrom, SearchFilterParser.CompareOperation theOperation) {
        Predicate p;
        if (theParam instanceof DateParam) {
            DateParam date = (DateParam)theParam;
            if (!date.isEmpty()) {
                if (theOperation == SearchFilterParser.CompareOperation.ne) {
                    date = new DateParam(ParamPrefixEnum.EQUAL, date.getValueAsString());
                }
                DateRangeParam range = new DateRangeParam(date);
                p = this.createPredicateDateFromRange(theBuilder, theFrom, range, theOperation);
            } else {
                p = null;
            }
        } else if (theParam instanceof DateRangeParam) {
            DateRangeParam range = (DateRangeParam)theParam;
            p = this.createPredicateDateFromRange(theBuilder, theFrom, range, theOperation);
        } else {
            throw new IllegalArgumentException("Invalid token type: " + theParam.getClass());
        }
        return p;
    }

    private boolean isNullOrDayPrecision(DateParam theDateParam) {
        return theDateParam == null || theDateParam.getPrecision().ordinal() == TemporalPrecisionEnum.DAY.ordinal();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Predicate createPredicateDateFromRange(CriteriaBuilder theBuilder, From<?, ResourceIndexedSearchParamDate> theFrom, DateRangeParam theRange, SearchFilterParser.CompareOperation operation) {
        void var12_23;
        void var11_20;
        String highValueField;
        String lowValueField;
        Date lowerBoundInstant = theRange.getLowerBoundAsInstant();
        Date upperBoundInstant = theRange.getUpperBoundAsInstant();
        DateParam lowerBound = theRange.getLowerBound();
        DateParam upperBound = theRange.getUpperBound();
        Integer lowerBoundAsOrdinal = theRange.getLowerBoundAsDateInteger();
        Integer upperBoundAsOrdinal = theRange.getUpperBoundAsDateInteger();
        boolean isOrdinalComparison = this.isNullOrDayPrecision(lowerBound) && this.isNullOrDayPrecision(upperBound) && this.myDaoConfig.getModelConfig().getUseOrdinalDatesForDayPrecisionSearches();
        Predicate lt = null;
        Predicate gt = null;
        Predicate lb = null;
        Predicate ub = null;
        if (isOrdinalComparison) {
            lowValueField = "myValueLowDateOrdinal";
            highValueField = "myValueHighDateOrdinal";
            Integer n = lowerBoundAsOrdinal;
            Integer n2 = upperBoundAsOrdinal;
        } else {
            lowValueField = "myValueLow";
            highValueField = "myValueHigh";
            Date date = lowerBoundInstant;
            Date date2 = upperBoundInstant;
        }
        if (operation == SearchFilterParser.CompareOperation.lt) {
            if (lowerBoundInstant != null) {
                lb = theBuilder.lessThanOrEqualTo((Expression)theFrom.get(lowValueField), (Comparable)var11_20);
                if (this.myDaoConfig.isAccountForDateIndexNulls()) {
                    lb = theBuilder.or((Expression)lb, (Expression)theBuilder.lessThanOrEqualTo((Expression)theFrom.get(highValueField), (Comparable)var11_20));
                }
            } else {
                if (upperBoundInstant == null) throw new InvalidRequestException("lowerBound and upperBound value not correctly specified for compare theOperation");
                ub = theBuilder.lessThanOrEqualTo((Expression)theFrom.get(lowValueField), (Comparable)var12_23);
                if (this.myDaoConfig.isAccountForDateIndexNulls()) {
                    ub = theBuilder.or((Expression)ub, (Expression)theBuilder.lessThanOrEqualTo((Expression)theFrom.get(highValueField), (Comparable)var12_23));
                }
            }
        } else if (operation == SearchFilterParser.CompareOperation.le) {
            if (lowerBoundInstant != null) {
                lb = theBuilder.lessThanOrEqualTo((Expression)theFrom.get(lowValueField), (Comparable)var11_20);
                if (this.myDaoConfig.isAccountForDateIndexNulls()) {
                    lb = theBuilder.or((Expression)lb, (Expression)theBuilder.lessThanOrEqualTo((Expression)theFrom.get(highValueField), (Comparable)var11_20));
                }
            } else {
                if (upperBoundInstant == null) throw new InvalidRequestException("lowerBound and upperBound value not correctly specified for compare theOperation");
                ub = theBuilder.lessThanOrEqualTo((Expression)theFrom.get(lowValueField), (Comparable)var12_23);
                if (this.myDaoConfig.isAccountForDateIndexNulls()) {
                    ub = theBuilder.or((Expression)ub, (Expression)theBuilder.lessThanOrEqualTo((Expression)theFrom.get(highValueField), (Comparable)var12_23));
                }
            }
        } else if (operation == SearchFilterParser.CompareOperation.gt) {
            if (upperBoundInstant != null) {
                ub = theBuilder.greaterThanOrEqualTo((Expression)theFrom.get(highValueField), (Comparable)var12_23);
                if (this.myDaoConfig.isAccountForDateIndexNulls()) {
                    ub = theBuilder.or((Expression)ub, (Expression)theBuilder.greaterThanOrEqualTo((Expression)theFrom.get(lowValueField), (Comparable)var12_23));
                }
            } else {
                if (lowerBoundInstant == null) throw new InvalidRequestException("upperBound and lowerBound value not correctly specified for compare theOperation");
                lb = theBuilder.greaterThanOrEqualTo((Expression)theFrom.get(highValueField), (Comparable)var11_20);
                if (this.myDaoConfig.isAccountForDateIndexNulls()) {
                    lb = theBuilder.or((Expression)lb, (Expression)theBuilder.greaterThanOrEqualTo((Expression)theFrom.get(lowValueField), (Comparable)var11_20));
                }
            }
        } else if (operation == SearchFilterParser.CompareOperation.ge) {
            if (upperBoundInstant != null) {
                ub = theBuilder.greaterThanOrEqualTo((Expression)theFrom.get(highValueField), (Comparable)var12_23);
                if (this.myDaoConfig.isAccountForDateIndexNulls()) {
                    ub = theBuilder.or((Expression)ub, (Expression)theBuilder.greaterThanOrEqualTo((Expression)theFrom.get(lowValueField), (Comparable)var12_23));
                }
            } else {
                if (lowerBoundInstant == null) throw new InvalidRequestException("upperBound and lowerBound value not correctly specified for compare theOperation");
                lb = theBuilder.greaterThanOrEqualTo((Expression)theFrom.get(highValueField), (Comparable)var11_20);
                if (this.myDaoConfig.isAccountForDateIndexNulls()) {
                    lb = theBuilder.or((Expression)lb, (Expression)theBuilder.greaterThanOrEqualTo((Expression)theFrom.get(lowValueField), (Comparable)var11_20));
                }
            }
        } else if (operation == SearchFilterParser.CompareOperation.ne) {
            if (lowerBoundInstant == null || upperBoundInstant == null) {
                throw new InvalidRequestException("lowerBound and/or upperBound value not correctly specified for compare operation");
            }
            lt = theBuilder.lessThan((Expression)theFrom.get(lowValueField), (Comparable)var11_20);
            gt = theBuilder.greaterThan((Expression)theFrom.get(highValueField), (Comparable)var12_23);
            lb = theBuilder.or((Expression)lt, (Expression)gt);
        } else {
            if (operation != SearchFilterParser.CompareOperation.eq && operation != null) throw new InvalidRequestException(String.format("Unsupported operator specified, operator=%s", operation.name()));
            if (lowerBoundInstant != null) {
                gt = theBuilder.greaterThanOrEqualTo((Expression)theFrom.get(lowValueField), (Comparable)var11_20);
                lt = theBuilder.greaterThanOrEqualTo((Expression)theFrom.get(highValueField), (Comparable)var11_20);
                lb = lowerBound.getPrefix() == ParamPrefixEnum.STARTS_AFTER || lowerBound.getPrefix() == ParamPrefixEnum.EQUAL ? gt : theBuilder.or((Expression)gt, (Expression)lt);
            }
            if (upperBoundInstant != null) {
                gt = theBuilder.lessThanOrEqualTo((Expression)theFrom.get(lowValueField), (Comparable)var12_23);
                lt = theBuilder.lessThanOrEqualTo((Expression)theFrom.get(highValueField), (Comparable)var12_23);
                ub = theRange.getUpperBound().getPrefix() == ParamPrefixEnum.ENDS_BEFORE || theRange.getUpperBound().getPrefix() == ParamPrefixEnum.EQUAL ? lt : theBuilder.or((Expression)gt, (Expression)lt);
            }
        }
        if (isOrdinalComparison) {
            ourLog.trace("Ordinal date range is {} - {} ", (Object)lowerBoundAsOrdinal, (Object)upperBoundAsOrdinal);
        } else {
            ourLog.trace("Date range is {} - {}", (Object)lowerBoundInstant, (Object)upperBoundInstant);
        }
        if (lb != null && ub != null) {
            return theBuilder.and((Expression)lb, (Expression)ub);
        }
        if (lb == null) return ub;
        return lb;
    }
}

