/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.predicate;

import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.dao.LegacySearchBuilder;
import ca.uhn.fhir.jpa.dao.predicate.BasePredicateBuilder;
import ca.uhn.fhir.jpa.dao.predicate.IPredicateBuilder;
import ca.uhn.fhir.jpa.dao.predicate.SearchBuilderJoinEnum;
import ca.uhn.fhir.jpa.dao.predicate.SearchFilterParser;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.param.NumberParam;
import ca.uhn.fhir.rest.param.ParamPrefixEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class PredicateBuilderNumber
extends BasePredicateBuilder
implements IPredicateBuilder {
    private static final Logger ourLog = LoggerFactory.getLogger(PredicateBuilderNumber.class);

    public PredicateBuilderNumber(LegacySearchBuilder theSearchBuilder) {
        super(theSearchBuilder);
    }

    @Override
    public Predicate addPredicate(String theResourceName, RuntimeSearchParam theSearchParam, List<? extends IQueryParameterType> theList, SearchFilterParser.CompareOperation operation, RequestPartitionId theRequestPartitionId) {
        From join = this.myQueryStack.createJoin(SearchBuilderJoinEnum.NUMBER, theSearchParam.getName());
        if (theList.get(0).getMissing() != null) {
            this.addPredicateParamMissingForNonReference(theResourceName, theSearchParam.getName(), theList.get(0).getMissing(), join, theRequestPartitionId);
            return null;
        }
        ArrayList<Predicate> codePredicates = new ArrayList<Predicate>();
        this.addPartitionIdPredicate(theRequestPartitionId, join, codePredicates);
        for (IQueryParameterType iQueryParameterType : theList) {
            if (iQueryParameterType instanceof NumberParam) {
                NumberParam param = (NumberParam)iQueryParameterType;
                BigDecimal value = param.getValue();
                if (value == null) continue;
                Path fromObj = join.get("myValue");
                ParamPrefixEnum prefix = (ParamPrefixEnum)ObjectUtils.defaultIfNull((Object)param.getPrefix(), (Object)ParamPrefixEnum.EQUAL);
                if (operation == SearchFilterParser.CompareOperation.ne) {
                    prefix = ParamPrefixEnum.NOT_EQUAL;
                } else if (operation == SearchFilterParser.CompareOperation.lt) {
                    prefix = ParamPrefixEnum.LESSTHAN;
                } else if (operation == SearchFilterParser.CompareOperation.le) {
                    prefix = ParamPrefixEnum.LESSTHAN_OR_EQUALS;
                } else if (operation == SearchFilterParser.CompareOperation.gt) {
                    prefix = ParamPrefixEnum.GREATERTHAN;
                } else if (operation == SearchFilterParser.CompareOperation.ge) {
                    prefix = ParamPrefixEnum.GREATERTHAN_OR_EQUALS;
                } else if (operation == SearchFilterParser.CompareOperation.eq) {
                    prefix = ParamPrefixEnum.EQUAL;
                } else if (operation != null) {
                    throw new IllegalArgumentException("Invalid operator specified for number type");
                }
                String invalidMessageName = "invalidNumberPrefix";
                Predicate predicateNumeric = this.createPredicateNumeric(theResourceName, theSearchParam.getName(), join, this.myCriteriaBuilder, iQueryParameterType, prefix, value, (Expression<BigDecimal>)fromObj, invalidMessageName, theRequestPartitionId);
                Predicate predicateOuter = this.combineParamIndexPredicateWithParamNamePredicate(theResourceName, theSearchParam.getName(), join, predicateNumeric, theRequestPartitionId);
                codePredicates.add(predicateOuter);
                continue;
            }
            throw new IllegalArgumentException("Invalid token type: " + iQueryParameterType.getClass());
        }
        Predicate predicate = this.myCriteriaBuilder.or(PredicateBuilderNumber.toArray(codePredicates));
        this.myQueryStack.addPredicateWithImplicitTypeSelection(predicate);
        return predicate;
    }
}

